//
//  OffcnToast.h
//  OffcnToast
//
//  Created by LS on 8/18/15.
//  Copyright (c) 2015 LS. All rights reserved.
//

#import <UIKit/UIKit.h>

typedef NS_ENUM(NSInteger, OffcnToastShowType)
{
    OffcnToastShowTypeTop,
    OffcnToastShowTypeCenter,
    OffcnToastShowTypeBottom
};

@interface OffcnToast : UILabel

@property (nonatomic, assign) CFTimeInterval forwardAnimationDuration;
@property (nonatomic, assign) CFTimeInterval backwardAnimationDuration;
@property (nonatomic, assign) UIEdgeInsets   textInsets;
@property (nonatomic, assign) CGFloat        maxWidth;

//toast
+(void)toastWithTitlemessage:(NSString *)titlemessage;

+ (id)toastWithText:(NSString *)text;

- (id)initWithText:(NSString *)text;
- (void)showInView:(UIView *)view;    //Default is OffcnToastShowTypeBottom
- (void)showInView:(UIView *)view showType:(OffcnToastShowType)type;

@end
