//
//  OffcnDownloadManager.m
//  OffcnLiveSDK
//
//  Created by vockey on 2019/1/22.
//  Copyright © 2019年 中公教育. All rights reserved.
//

#import "OffcnDownloadManager.h"
#import "MJExtension.h"
#import "RealReachability.h"
#import "AFNetworking.h"
#import "OffcnToast.h"
#include <sys/param.h>
#include <sys/mount.h>

#define m3u8Name @"index.m3u8"
#define m3u8PartName(password) [NSString stringWithFormat:@"%@.m3u8",password]

#define sqliteName(password) [NSString stringWithFormat:@"%@.db",password]

@implementation SDDetailedModel

@end

@implementation OffcnDownloadManagerModel

@end

@interface OffcnDownloadManager()

@property (nonatomic, strong) OffcnDownloadManager *downloadManager;

@property (nonatomic, strong) AFURLSessionManager *manager;
@end

@implementation OffcnDownloadManager

static OffcnDownloadManager *downloadManager;
+ (instancetype)sharedInstance{
    static dispatch_once_t onceToken;
    dispatch_once(&onceToken, ^{
        downloadManager = [[OffcnDownloadManager alloc]init];
    });
    return downloadManager;
}
- (instancetype)init{
    self = [super init];
    if (self) {
        NSURLSessionConfiguration *configuration = [NSURLSessionConfiguration backgroundSessionConfigurationWithIdentifier:@"com.zg.offcn"];
        configuration.HTTPMaximumConnectionsPerHost = 8;
        
        //设置请求超时为10秒钟
        configuration.timeoutIntervalForRequest = 30;
        //在蜂窝网络情况下是否继续请求（上传或下载）
        configuration.allowsCellularAccess = YES;
        
        self.manager = [[AFURLSessionManager alloc] initWithSessionConfiguration:configuration];
        
        //网络变化的通知
        
        
        NSURLSessionDownloadTask *task;
        [[NSNotificationCenter defaultCenter] addObserver:self
                                                 selector:@selector(downLoadData:)
                                                     name:@"com.alamofire.networking.task.complete"
                                                   object:task];
    }
    return  self;
}
#pragma mark - 添加一个通知监听网络状态切换
-(void)startNotifierRealReachability{
    
    [[NSNotificationCenter defaultCenter] addObserver:self selector:@selector(networkChanged:)                                            name:kRealReachabilityChangedNotification object:nil];

    GLobalRealReachability.hostForPing = @"live.offcncloud.com";
    GLobalRealReachability.pingTimeout = 10;
    [GLobalRealReachability startNotifier];

    ReachabilityStatus status = [GLobalRealReachability currentReachabilityStatus];
    [self realNetworkingStatus:status];
}
- (void)networkChanged:(NSNotification *)notification
{
    RealReachability *reachability= (RealReachability *)notification.object;
    ReachabilityStatus status= [reachability currentReachabilityStatus];
    [self realNetworkingStatus:status];
}
-(void)realNetworkingStatus:(ReachabilityStatus)status{

    if (self.reachabilitystatusCallBack) {
        if (status == RealStatusNotReachable || status == RealStatusUnknown){

            [self requesJsonWithUrlStr:@"https://live.offcncloud.com" account:nil hook:nil extensionDic:nil Finished:^(BOOL success, id response, NSString *message) {
                if (!success) {
                    [self requesJsonWithUrlStr:@"https://www.baidu.com" account:nil hook:nil extensionDic:nil Finished:^(BOOL success, id response, NSString *message) {
                        if (!success) {
                            self.reachabilitystatusCallBack(OffcnRealStatusNotReachable);
                        }
                    }];
                }
            }];
        }else if (status == RealStatusViaWWAN){
            self.reachabilitystatusCallBack(OffcnRealStatusViaWWAN);
        }else if (status == RealStatusViaWiFi){
            self.reachabilitystatusCallBack(OffcnRealStatusViaWiFi);
        }
    }
}
/********下载模块的关键的代码 包括强退闪退都会有********/
- (void)downLoadData:(NSNotification *)notification{
    
    if ([notification.object isKindOfClass:[NSURLSessionDownloadTask class]]) {
//        NSURLSessionDownloadTask *task = notification.object;
//        NSString *urlHost = [task.currentRequest.URL absoluteString];
        NSError *error  = [notification.userInfo objectForKey:AFNetworkingTaskDidCompleteErrorKey] ;
        if (error) {
            if (error.code == -1001) {
                NSLog(@"下载出错,看一下网络是否正常");
            }
//            NSData *resumeData = [error.userInfo objectForKey:@"NSURLSessionDownloadTaskResumeData"];
            
            //这个是因为 用户比如强退程序之后 ,再次进来的时候 存进去这个继续的data需要用户去刷新列表
        }else{
//            if ([self.downLoadHistoryDictionary valueForKey:urlHost]) {
//                [self.downLoadHistoryDictionary removeObjectForKey:urlHost];
//                [self saveDownLoadHistoryDirectory];
//            }
        }
    }
    
}
-(NSMutableDictionary *)blockOperationDic{
    if (!_blockOperationDic) {
        _blockOperationDic = [[NSMutableDictionary alloc] init];
    }
    return _blockOperationDic;
}
-(NSMutableDictionary *)downloadTaskDic{
    if (!_downloadTaskDic) {
        _downloadTaskDic = [[NSMutableDictionary alloc] init];
    }
    return _downloadTaskDic;
}
-(NSMutableDictionary *)modelDic{
    if (!_modelDic) {
        _modelDic = [[NSMutableDictionary alloc] init];
        
        _modelDic = [NSMutableDictionary dictionaryWithContentsOfFile:[self.documentPath stringByAppendingPathComponent:@"modelDic.plist"]];
        if (!_modelDic) {
            _modelDic = [[NSMutableDictionary alloc] init];
        }
        
        for (int i=0; i<_modelDic.allValues.count; i++) {
            int itemFileSize = [[_modelDic.allValues[i] valueForKey:@"itemFileSize"] intValue];
            if (!itemFileSize) {
                long long folderSize = [self folderSizeAtPath:[self.documentPath stringByAppendingPathComponent:[NSString stringWithFormat:@"%@",_modelDic.allKeys[i]]]];
                [_modelDic.allValues[i] setValue:[self localFileSizeTextWithFolderSize:folderSize] forKey:@"itemFileSize"];
            }
        }
    }
    return _modelDic;
}

- (void)downloadDataWithPassword:(NSString *)password hook:(NSString *)hook documentPath:(NSString *)documentPath downloadState:(OffcnDownloadState)downloadState extensionDic:(NSDictionary *)extensionDic{
    if (!documentPath.length) {
        [OffcnToast toastWithTitlemessage:@"路径为空"];
        return;
    }
    if (downloadState != OffcnDownloadStateAllClean) {
        if (!password.length) {
            [OffcnToast toastWithTitlemessage:@"请设置房间口令"];
            return;
        }
    }
    
    _downloadManager = [OffcnDownloadManager sharedInstance];
    
    if (!self.maxOperationCount) {
        self.maxOperationCount = 3;
    }
    
    self.modelDic = [NSMutableDictionary dictionaryWithContentsOfFile:[documentPath stringByAppendingPathComponent:@"modelDic.plist"]];
    [self.modelDic enumerateKeysAndObjectsUsingBlock:^(id  _Nonnull key, id  _Nonnull obj, BOOL * _Nonnull stop) {
        OffcnDownloadManagerModel *model = [OffcnDownloadManagerModel mj_objectWithKeyValues:obj];
        self.modelDic[key] = model;
    }];
    
    if (![[self.modelDic allKeys] containsObject:password]) {
        OffcnDownloadManagerModel *model = [[OffcnDownloadManagerModel alloc] init];
        [self.modelDic setObject:model forKey:password];
    }
    
    OffcnDownloadManagerModel *model = [self.modelDic objectForKey:password];
    model.password = password;
    model.documentPath = documentPath;
    model.extensionDic = extensionDic;
    model.downloadState = downloadState;
    model.hook = hook;
    
    if (downloadState == OffcnDownloadStateResume) {
        if (self.blockOperationDic.allValues.count >= self.maxOperationCount) {
            return;
        }
        //开始下载或继续下载
        if (model.progress != 1) {
            __weak typeof(self) weakSelf = self;
            NSOperationQueue *queue1 = [[NSOperationQueue alloc] init];
            queue1.maxConcurrentOperationCount = 1;
            NSBlockOperation *op1 = [NSBlockOperation blockOperationWithBlock:^{
                if (model.flowUrlStr) {
                    NSString *m3u8NamePath = [[self videoPathWithModel:model] stringByAppendingPathComponent:m3u8Name];
                    
                    NSString *destinationPath = [[self videoPathWithModel:model] stringByAppendingPathComponent:m3u8PartName(model.password)];
                    
                    NSFileManager *mgr = [NSFileManager defaultManager];
                    if ([mgr fileExistsAtPath:m3u8NamePath] && [mgr fileExistsAtPath:destinationPath]) {
                        [weakSelf dealPlayListWithModel:model];
                    }else{
                        [weakSelf handleM3U8WithModel:model];
                    }
                }else{
                    [weakSelf getFlowUrlStrWithModel:model];
                }
            }];
    
            [queue1 addOperation:op1];
            [self.blockOperationDic setValue:queue1 forKey:password];
        }
    }else if (downloadState == OffcnDownloadStateSuspended){
        //暂停
        NSURLSessionDownloadTask *downloadTask = [self.downloadTaskDic valueForKey:password];
        [downloadTask cancel];
        [downloadTask cancelByProducingResumeData:^(NSData * _Nullable resumeData) {
            
        }];
        
        NSOperationQueue *queue1 = [self.blockOperationDic valueForKey:password];
        [queue1 cancelAllOperations];
        [self.blockOperationDic removeObjectForKey:password];
        
        model.downloadState = OffcnDownloadStateSuspended;
        [self writeToFileWithModel:model];
        
        if (self.downloadStateCallBack) {
            self.downloadStateCallBack(model.password,OffcnDownloadStateSuspended,self);
        }
        
    }else if (downloadState == OffcnDownloadStateClean){
        //清除当前的视频
        //暂停下载任务
        NSURLSessionDownloadTask *downloadTask = [self.downloadTaskDic valueForKey:password];
        [downloadTask cancel];
        [downloadTask cancelByProducingResumeData:^(NSData * _Nullable resumeData) {
            
        }];
        
        NSOperationQueue *queue1 = [self.blockOperationDic valueForKey:password];
        [queue1 cancelAllOperations];
        [self.blockOperationDic removeObjectForKey:password];
        
        NSFileManager *fileManager = [NSFileManager defaultManager];
        NSString *ItemPath = [documentPath stringByAppendingPathComponent:[NSString stringWithFormat:@"%@",password]];
        if ([fileManager fileExistsAtPath:ItemPath]) {
            
            // 删除沙盒中的视频资源
            [fileManager removeItemAtPath:ItemPath error:nil];
        }
        // 删除plist中的model
        if ([fileManager fileExistsAtPath:[self modelDicPathWith:model]]) {
            
            NSMutableDictionary *dict = [self getModelDicFromPathWith:model];
            [dict removeObjectForKey:password];
            [dict writeToFile:[self modelDicPathWith:model] atomically:YES];
        }
        [self.modelDic removeObjectForKey:password];
        
    }else if (downloadState == OffcnDownloadStateAllClean){
        //暂停所有下载任务
        NSArray *arr = self.downloadTaskDic.allKeys;
        for (int i=0; i<arr.count; i++) {
           
            NSURLSessionDownloadTask *downloadTask = [self.downloadTaskDic valueForKey:arr[i]];
            [downloadTask cancel];
        }
        [[self.blockOperationDic allValues] enumerateObjectsUsingBlock:^(NSOperationQueue * obj, NSUInteger idx, BOOL * _Nonnull stop) {
            [obj cancelAllOperations];
        }];
        [self.blockOperationDic removeAllObjects];
        //清除所有的视频
        NSFileManager *fileManager = [NSFileManager defaultManager];
        if ([fileManager fileExistsAtPath:documentPath]) {
            // 删除沙盒中所有资源
            [fileManager removeItemAtPath:documentPath error:nil];
        }
        
        [self.modelDic removeAllObjects];
    }
}
- (void)getFlowUrlStrWithModel:(OffcnDownloadManagerModel *)model{
    
    [self requesJsonWithUrlStr:@"" account:model.password hook:model.hook extensionDic:model.extensionDic Finished:^(BOOL success, id response, NSString *message) {
        if (success) {
            
            SDDetailedModel *DetailedModel = [SDDetailedModel mj_objectWithKeyValues:response];
            NSString *url = [NSString stringWithFormat:@"http:%@",DetailedModel.vod];
            model.flowUrlStr = url;
            NSString *partStr = [NSString stringWithFormat:@"http:%@",DetailedModel.vodName];
            model.flowUrlPartStr = partStr;
            
            model.room_name = DetailedModel.room_name;
            model.sqlite = DetailedModel.sqlite;
            
            [self handleM3U8WithModel:model];
        }else{
    
            NSOperationQueue *queue1 = [self.blockOperationDic valueForKey:model.password];
            [queue1 cancelAllOperations];
            [self.blockOperationDic removeObjectForKey:model.password];
            
            NSURLSessionDownloadTask *downloadTask = [self.downloadTaskDic valueForKey:model.password];
            if (downloadTask && downloadTask.state != NSURLSessionTaskStateCanceling) {
                if (message.length) {
                    [OffcnToast toastWithTitlemessage:message];
                }else{
                    [OffcnToast toastWithTitlemessage:@"下载失败"];
                }
                model.downloadState = OffcnDownloadStateFailed;
                if (self.downloadStateCallBack) {
                    self.downloadStateCallBack(model.password,OffcnDownloadStateFailed,self);
                }
            }
            
            [self writeToFileWithModel:model];
        }
    }];
}
//下载m3u8文件
- (void)handleM3U8WithModel:(OffcnDownloadManagerModel *)model{
    NSString *partStrPath = [[self videoPathWithModel:model] stringByAppendingPathComponent:m3u8PartName(model.password)];
    [self downloadURL:model.flowUrlPartStr
             password:model.password
      destinationPath:partStrPath
             progress:nil
           completion:^(NSURLResponse *response, NSURL *filePath, NSError *error) {
               if (!error) {
                   model.itemM3U8Path = partStrPath;
               } else {
                   
                   NSOperationQueue *queue1 = [self.blockOperationDic valueForKey:model.password];
                   [queue1 cancelAllOperations];
                   [self.blockOperationDic removeObjectForKey:model.password];
                   
                   NSFileManager *fileManager = [NSFileManager defaultManager];
                   NSString *ItemPath = [model.documentPath stringByAppendingPathComponent:[NSString stringWithFormat:@"%@",model.password]];
                   if ([fileManager fileExistsAtPath:ItemPath]) {
                       
                       // 删除沙盒中的视频资源
                       [fileManager removeItemAtPath:ItemPath error:nil];
                   }
                   // 删除plist中的model
                   if ([fileManager fileExistsAtPath:[self modelDicPathWith:model]]) {
                       
                       NSMutableDictionary *dict = [self getModelDicFromPathWith:model];
                       [dict removeObjectForKey:model.password];
                       [dict writeToFile:[self modelDicPathWith:model] atomically:YES];
                   }
                   
                   NSURLSessionDownloadTask *downloadTask = [self.downloadTaskDic valueForKey:model.password];
                   
                   if (downloadTask && downloadTask.state != NSURLSessionTaskStateCanceling) {
                       
                       [OffcnToast toastWithTitlemessage:@"下载失败,请重新尝试"];
                       
                       model.downloadState = OffcnDownloadStateFailed;
                       if (self.downloadStateCallBack) {
                           self.downloadStateCallBack(model.password,OffcnDownloadStateFailed,self);
                       }
                   }
                   
                   [self writeToFileWithModel:model];
                   
                   [self.modelDic removeObjectForKey:model.password];
               }
           }];
    
    NSString *destinationPath = [[self videoPathWithModel:model] stringByAppendingPathComponent:m3u8Name];
    
    __weak typeof(self) wkSelf = self;
    [self downloadURL:model.flowUrlStr
      password:model.password
      destinationPath:destinationPath
             progress:nil
           completion:^(NSURLResponse *response, NSURL *filePath, NSError *error) {
               if (!error) {
                   
                   [wkSelf dealPlayListWithModel:model];
               } else {
                   
                   NSOperationQueue *queue1 = [self.blockOperationDic valueForKey:model.password];
                   [queue1 cancelAllOperations];
                   [self.blockOperationDic removeObjectForKey:model.password];
                   
                   NSFileManager *fileManager = [NSFileManager defaultManager];
                   NSString *ItemPath = [model.documentPath stringByAppendingPathComponent:[NSString stringWithFormat:@"%@",model.password]];
                   if ([fileManager fileExistsAtPath:ItemPath]) {
                       
                       // 删除沙盒中的视频资源
                       [fileManager removeItemAtPath:ItemPath error:nil];
                   }
                   // 删除plist中的model
                   if ([fileManager fileExistsAtPath:[self modelDicPathWith:model]]) {
                       
                       NSMutableDictionary *dict = [self getModelDicFromPathWith:model];
                       [dict removeObjectForKey:model.password];
                       [dict writeToFile:[self modelDicPathWith:model] atomically:YES];
                   }
                   
                   NSURLSessionDownloadTask *downloadTask = [self.downloadTaskDic valueForKey:model.password];
                   
                   if (downloadTask && downloadTask.state != NSURLSessionTaskStateCanceling) {
                       
                       [OffcnToast toastWithTitlemessage:@"下载失败,请重新尝试"];
                       
                       model.downloadState = OffcnDownloadStateFailed;
                       if (self.downloadStateCallBack) {
                           self.downloadStateCallBack(model.password,OffcnDownloadStateFailed,self);
                       }
                   }
                   
                   [self writeToFileWithModel:model];
                   
                   [self.modelDic removeObjectForKey:model.password];
               }
           }];

    NSString *sqliteStrPath = [[self videoPathWithModel:model] stringByAppendingPathComponent:sqliteName(model.password)];
    [self downloadURL:model.sqlite
             password:model.password
      destinationPath:sqliteStrPath
             progress:nil
           completion:^(NSURLResponse *response, NSURL *filePath, NSError *error) {
               if (!error) {
                   model.itemSqlitePath = sqliteStrPath;
               }else{
                   
                   NSFileManager *fileManager = [NSFileManager defaultManager];
                   if ([fileManager fileExistsAtPath:sqliteStrPath]) {
                       // 删除沙盒中的视频资源
                       [fileManager removeItemAtPath:sqliteStrPath error:nil];
                   }
                   [self downloadURL:model.sqlite
                            password:model.password
                     destinationPath:sqliteStrPath
                            progress:nil
                          completion:^(NSURLResponse *response, NSURL *filePath, NSError *error) {
                              if (!error) {
                                  model.itemSqlitePath = sqliteStrPath;
                              }else{
                                  
                                  NSFileManager *fileManager = [NSFileManager defaultManager];
                                  if ([fileManager fileExistsAtPath:sqliteStrPath]) {
                                      // 删除沙盒中的视频资源
                                      [fileManager removeItemAtPath:sqliteStrPath error:nil];
                                  }
                              }
                          }];
               }
           }];
}
//获取ModelDic
-(NSMutableDictionary *)getModelDicFromPathWith:(OffcnDownloadManagerModel *)model{
    NSMutableDictionary *dict = [NSMutableDictionary dictionaryWithContentsOfFile:[self modelDicPathWith:model]];
    if (dict == nil) dict = [NSMutableDictionary dictionary];
    return dict;
}
-(NSString *)modelDicPathWith:(OffcnDownloadManagerModel *)model{
    NSString *modelDicPath = [model.documentPath stringByAppendingPathComponent:@"modelDic.plist"];
    return modelDicPath;
}
// 视频列表路径
- (NSString *)videoPathWithModel:(OffcnDownloadManagerModel *)model{
    NSString *vedioPath = [model.documentPath stringByAppendingPathComponent:[NSString stringWithFormat:@"%@",model.password]];
    model.itemPath = vedioPath;
    NSFileManager *mgr = [NSFileManager defaultManager];
    if (![mgr fileExistsAtPath:vedioPath]) {
        [mgr createDirectoryAtPath:vedioPath
       withIntermediateDirectories:YES
                        attributes:nil
                             error:nil];
    }
    return vedioPath;
}
// 处理m3u8文件
- (void)dealPlayListWithModel:(OffcnDownloadManagerModel *)model{
    
    // 读取m3u8文件内容
    NSString *filePath = [[self videoPathWithModel:model] stringByAppendingPathComponent:m3u8Name];
    NSString *content = [NSString stringWithContentsOfFile:filePath
                                                  encoding:NSUTF8StringEncoding
                                                     error:nil];
    NSArray *array = [content componentsSeparatedByString:@"\n"];
    
    // 筛选出 .ts 文件
    NSMutableArray *listArr = [NSMutableArray arrayWithCapacity:array.count];
    for (NSString *str in array) {
        if ([str containsString:@".ts"]) {
            [listArr addObject:str];
        }
    }
    
    NSString *firstStr = listArr.firstObject;
    NSString *videoName = [firstStr componentsSeparatedByString:@"."].firstObject;
    
    NSLog(@"%@",[NSString stringWithFormat:@"共有 %lu 个视频", (unsigned long)listArr.count]);
    // 下载 ts 文件
    [self downloadVideoWithArr:listArr andIndex:model.index>0?model.index+1:0 videoName:videoName model:model];
}
// 循环下载 ts 文件
- (void)downloadVideoWithArr:(NSArray *)listArr andIndex:(NSInteger)index videoName:(NSString *)videoName model:(OffcnDownloadManagerModel *)model2{
    NSLog(@"%ld",(long)index);
    OffcnDownloadManagerModel *ManagerModel = [self.modelDic objectForKey:model2.password];
    if (ManagerModel) {
        if (ManagerModel.downloadState != OffcnDownloadStateResume && ManagerModel.downloadState != OffcnDownloadStateProgress) {
            return;
        }
        if (listArr.count<=0) {
            return;
        }
        if (index >= listArr.count-1) {
            NSURLSessionDownloadTask *downloadTask = [self.downloadTaskDic valueForKey:ManagerModel.password];
            if (downloadTask && downloadTask.state == NSURLSessionTaskStateRunning) {
                [downloadTask cancel];
            }
            NSOperationQueue *queue1 = [self.blockOperationDic valueForKey:ManagerModel.password];
            [queue1 cancelAllOperations];
            [self.blockOperationDic removeObjectForKey:ManagerModel.password];
            
            NSLog(@"视频下载完成");
            NSLog(@"%@----%@",[NSString stringWithFormat:@"共有 %lu 个ts文件, 下载中：%.2f%%, 当前下载成功第%lu", (unsigned long)listArr.count, (float)index/listArr.count * 100, index],ManagerModel.password);
            ManagerModel.index = listArr.count-1;
            ManagerModel.listArr = [NSArray arrayWithArray:listArr];
            ManagerModel.progress = 1;
            
            ManagerModel.downloadState = OffcnDownloadStateCompleted;
            
            if (self.downloadStateCallBack) {
                self.downloadStateCallBack(ManagerModel.password,OffcnDownloadStateProgress,self);
            }
            
            if (self.downloadStateCallBack) {
                self.downloadStateCallBack(ManagerModel.password,OffcnDownloadStateCompleted,self);
            }
           
            long long folderSize = [self folderSizeAtPath:[ManagerModel.documentPath stringByAppendingPathComponent:[NSString stringWithFormat:@"%@",ManagerModel.password]]];
            ManagerModel.itemFileSize = [self localFileSizeTextWithFolderSize:folderSize];
            
            [self writeToFileWithModel:ManagerModel];
            return;
        }
        
        ManagerModel.downloadState = OffcnDownloadStateProgress;
        
        NSString *listName = listArr[index];
        // 拼接ts全路径，有的文件直接包含，不需要拼接
        NSString *downloadURL = @"";
        if ([listName containsString:@"http"]) {
            downloadURL = listName;
        }else{
            downloadURL = [ManagerModel.flowUrlStr stringByReplacingOccurrencesOfString:ManagerModel.flowUrlStr.lastPathComponent withString:listName];
        }
        
        // 存储路径
        NSString *destinationPath = [[self videoPathWithModel:ManagerModel] stringByAppendingPathComponent:downloadURL.lastPathComponent];
        if ([[NSFileManager defaultManager] fileExistsAtPath:destinationPath]) {
            
            if (ManagerModel.downloadState == OffcnDownloadStateResume || ManagerModel.downloadState == OffcnDownloadStateProgress) {
                
                ManagerModel.index = index;
                ManagerModel.listArr = [NSArray arrayWithArray:listArr];
                ManagerModel.progress = (float)index/listArr.count;
                NSLog(@"%@----%@",[NSString stringWithFormat:@"共有 %lu 个ts文件, 下载中：%.2f%%, 当前下载成功第%ld", (unsigned long)listArr.count, (float)index/listArr.count * 100, (long)index],ManagerModel.password);
                
                if (self.downloadStateCallBack) {
                    self.downloadStateCallBack(ManagerModel.password,OffcnDownloadStateProgress,self);
                }
            }
            
            [self writeToFileWithModel:ManagerModel];
            
            [self downloadVideoWithArr:listArr andIndex:index+1 videoName:videoName model:ManagerModel];
            return;
        }
        
        __weak typeof(self) wkSelf = self;
        [self downloadURL:downloadURL
                 password:ManagerModel.password
          destinationPath:destinationPath
                 progress:nil
               completion:^(NSURLResponse *response, NSURL *filePath, NSError *error) {
                   if (!error) {
                       
                       if (ManagerModel.downloadState == OffcnDownloadStateResume || ManagerModel.downloadState == OffcnDownloadStateProgress) {
                           
                           ManagerModel.index = index;
                           ManagerModel.listArr = [NSArray arrayWithArray:listArr];
                           ManagerModel.progress = (float)index/listArr.count;
                           NSLog(@"%@----%@",[NSString stringWithFormat:@"共有 %lu 个ts文件, 下载中：%.2f%%, 当前下载成功第%ld", (unsigned long)listArr.count, (float)index/listArr.count * 100, (long)index],ManagerModel.password);
                           
                           if (self.downloadStateCallBack) {
                               self.downloadStateCallBack(ManagerModel.password,OffcnDownloadStateProgress,self);
                           }
                       }
                       
                       
                       [self writeToFileWithModel:ManagerModel];
                       
                       [wkSelf downloadVideoWithArr:listArr andIndex:index+1 videoName:videoName model:ManagerModel];
                   }else{
                       
                       NSOperationQueue *queue1 = [self.blockOperationDic valueForKey:ManagerModel.password];
                       [queue1 cancelAllOperations];
                       [self.blockOperationDic removeObjectForKey:ManagerModel.password];
                       
                       NSURLSessionDownloadTask *downloadTask = [self.downloadTaskDic valueForKey:ManagerModel.password];
                       if (downloadTask && downloadTask.state != NSURLSessionTaskStateCanceling){
                           
                           ManagerModel.downloadState = OffcnDownloadStateFailed;
                           if (self.downloadStateCallBack) {
                               self.downloadStateCallBack(ManagerModel.password,OffcnDownloadStateFailed,self);
                           }
                       }
                       
                       [self writeToFileWithModel:ManagerModel];
                       
                       NSFileManager *fileManager = [NSFileManager defaultManager];
                       if ([fileManager fileExistsAtPath:destinationPath]) {
                           
                           // 删除沙盒中的ts片资源
                           [fileManager removeItemAtPath:destinationPath error:nil];
                       }
                   }
               }];
    }
}
// 下载方法
- (void)downloadURL:(NSString *)downloadURL
    password:(NSString *)password
    destinationPath:(NSString *)destinationPath
           progress:(void (^)(NSProgress *downloadProgress))progress
         completion:(void (^)(NSURLResponse *response, NSURL *filePath, NSError *error))completion {
    
    NSURLRequest *request = [NSURLRequest requestWithURL:[NSURL URLWithString: downloadURL]];
    
    NSURLSessionDownloadTask *downloadTask =
    [self.manager downloadTaskWithRequest:request
                           progress:^(NSProgress * _Nonnull downloadProgress) {
                               if (progress) {
                                   progress(downloadProgress);
                               }
                           }
                        destination:^NSURL * _Nonnull(NSURL * _Nonnull targetPath, NSURLResponse * _Nonnull response) {
                            
                            NSURL *filePathUrl = nil;
                            if (destinationPath) {
                                filePathUrl = [NSURL fileURLWithPath:destinationPath];
                            }
                            if (filePathUrl) {
                                return filePathUrl;
                            }
                            NSString *caches = [NSSearchPathForDirectoriesInDomains(NSCachesDirectory, NSUserDomainMask, YES) lastObject];
                            NSString *fullpath = [caches stringByAppendingPathComponent:response.suggestedFilename];
                            filePathUrl = [NSURL fileURLWithPath:fullpath];
                            return filePathUrl;
                        }
                  completionHandler:^(NSURLResponse * _Nonnull response, NSURL * _Nonnull filePath, NSError * _Nonnull error) {
                      if (!error) {
                          OffcnDownloadManagerModel *ManagerModel = [self.modelDic objectForKey:password];
                          if (ManagerModel) {
                              if (ManagerModel.downloadState == OffcnDownloadStateResume || ManagerModel.downloadState == OffcnDownloadStateProgress) {
                                  if (completion) {
                                      completion(response, filePath, error);
                                  }
                              }
                          }
                      }else{
                          OffcnDownloadManagerModel *ManagerModel = [self.modelDic objectForKey:password];
                          if (ManagerModel) {
                              if (ManagerModel.downloadState != OffcnDownloadStateSuspended && ManagerModel.downloadState !=  OffcnDownloadStateClean && ManagerModel.downloadState !=  OffcnDownloadStateAllClean) {
                                  if (completion) {
                                      completion(response, filePath, error);
                                  }
                              }
                          }
                      }
                  }];
    
    [downloadTask resume];
    if (password) {
        [self.downloadTaskDic setValue:downloadTask forKey:password];
    }
    NSLog(@"%lu-----uuu----%ld---%@",(unsigned long)downloadTask.taskIdentifier,(long)downloadTask.state,[NSThread currentThread]);
}

-(void)writeToFileWithModel:(OffcnDownloadManagerModel *)model{
    
    OffcnDownloadManagerModel *ManagerModel = [self.modelDic objectForKey:model.password];
    if (ManagerModel) {
        if (ManagerModel.downloadState == OffcnDownloadStateClean || ManagerModel.downloadState == OffcnDownloadStateAllClean) {
            
        }else{
            [self.modelDic setObject:model forKey:model.password];
            
            NSMutableDictionary *dict = [self getModelDicFromPathWith:model];
            dict[model.password] = [model mj_keyValues];
            
            [dict writeToFile:[self modelDicPathWith:model] atomically:YES];
        }
    }
}
//获取手机剩余存储空间
-(void)getFreespace{
//    NSFileManager *fm = [NSFileManager defaultManager];
//    NSDictionary *fat = [fm attributesOfFileSystemForPath:NSHomeDirectory() error:nil];
//    NSLog(@"容量：%lldG 可用容量：%lldG",[[fat objectForKey:NSFileSystemSize] longLongValue]/1000000000,[[fat objectForKey:NSFileSystemFreeSize] longLongValue]/1000000000);
    struct statfs buf;
    long long freespace = -1;
    if(statfs("/var", &buf) >= 0){
        freespace = (long long)(buf.f_bsize * buf.f_bfree);
    }
    
    CGFloat free = (CGFloat)freespace;
    
    if (free>=1024*1024*1024)//大于1G，则转化成G单位的字符串
    {
//        [OffcnToast toastWithTitlemessage:[NSString stringWithFormat:@"手机剩余存储空间为:%.1fG",free/1024/1024/1024]];
    }
    else if(free<1024*1024*1024&&free>=1024*1024)//大于1M，则转化成M单位的字符串
    {
//        [OffcnToast toastWithTitlemessage:[NSString stringWithFormat:@"手机剩余存储空间为:%.1fM",free/1024/1024]];
    }
    else if(free>=1024&&free<1024*1024) //不到1M,但是超过了1KB，则转化成KB单位
    {
        [OffcnToast toastWithTitlemessage:[NSString stringWithFormat:@"手机剩余存储空间为:%.1fK",free/1024]];
    }
    else//剩下的都是小于1K的，则转化成B单位
    {
        [OffcnToast toastWithTitlemessage:[NSString stringWithFormat:@"手机剩余存储空间为:%.1fB",free]];
    }
}
//单个文件的大小
- (long long)fileSizeAtPath:(NSString*)filePath{
    NSFileManager* manager = [NSFileManager defaultManager];
    if ([manager fileExistsAtPath:filePath]){
        return [[manager attributesOfItemAtPath:filePath error:nil] fileSize];
    }
    return 0;
}
//遍历文件夹获得文件夹大小，返回字节
- (long long)folderSizeAtPath:(NSString*)folderPath{
    NSFileManager* manager = [NSFileManager defaultManager];
    if (![manager fileExistsAtPath:folderPath])
        return 0;
    NSString* fileName = [folderPath copy];
    long long folderSize = 0;
    
    BOOL isdir;
    [manager fileExistsAtPath:fileName isDirectory:&isdir];
    if (isdir != YES) {
        return [self fileSizeAtPath:fileName];
    }
    else
    {
        NSArray * items = [manager contentsOfDirectoryAtPath:fileName error:nil];
        for (int i =0; i<items.count; i++) {
            BOOL subisdir;
            NSString* fileAbsolutePath = [fileName stringByAppendingPathComponent:items[i]];
            
            [manager fileExistsAtPath:fileAbsolutePath isDirectory:&subisdir];
            if (subisdir==YES) {
                folderSize += [self folderSizeAtPath:fileAbsolutePath]; //文件夹就递归计算
            }
            else
            {
                folderSize += [self fileSizeAtPath:fileAbsolutePath];//文件直接计算
            }
        }
    }
    return folderSize; //folderSize/(1024*1024)递归时候会运算两次出错，所以返回字节。在外面再计算
}
-(NSString *)localFileSizeTextWithFolderSize:(long long)size{
//    NSString *sizeText = @"0";
//    if (size >= pow(10, 9)) { // size >= 1GB
//        sizeText = [NSString stringWithFormat:@"%.2fGB", size / pow(10, 9)];
//    } else if (size >= pow(10, 6)) { // 1GB > size >= 1MB
//        sizeText = [NSString stringWithFormat:@"%.2fMB", size / pow(10, 6)];
//    } else if (size >= pow(10, 3)) { // 1MB > size >= 1KB
//        sizeText = [NSString stringWithFormat:@"%.2fKB", size / pow(10, 3)];
//    } else { // 1KB > size
//        sizeText = [NSString stringWithFormat:@"%lldB", size];
//    }
    
    return [NSString stringWithFormat:@"%lld", size];
}
-(void)dealloc{
    
    [[NSNotificationCenter defaultCenter] removeObserver:self];
}


- (void)requesJsonWithUrlStr:(NSString *)urlStr account:(NSString *)account hook:(NSString *)hook extensionDic:(NSDictionary *)extensionDic Finished:(void(^)(BOOL success,id response,NSString *message))finished{
    
    NSURL *url = [NSURL URLWithString:urlStr];
    NSMutableURLRequest *request = [NSMutableURLRequest requestWithURL:url];

    if (account) {
        request.HTTPMethod = @"POST";
        [request setValue:account forKey:@"account"];
        [request setValue:hook forKey:@"hook"];
        if (extensionDic && [extensionDic allKeys].count) {
            [extensionDic enumerateKeysAndObjectsUsingBlock:^(NSString *key, id  _Nonnull obj, BOOL * _Nonnull stop) {
                if ([key isEqualToString:@"account"]) {
                    
                }else{
                    [request setValue:obj forKey:key];
                }
            }];
        }
    }
    
    [NSURLConnection sendAsynchronousRequest:request queue:[NSOperationQueue mainQueue]  completionHandler:^(NSURLResponse * _Nullable response, NSData * _Nullable data, NSError * _Nullable connectionError) {
        
        if (!connectionError) {
            if (!data) {
                data = [NSData data];
            }
            NSDictionary *dic = [NSJSONSerialization JSONObjectWithData:data options:NSJSONReadingMutableContainers error:nil];
            finished(YES,dic,nil);
        }else{
            finished(NO,nil,connectionError.localizedDescription);
        }
    }];
}
@end
