//
//  OffcnDownloadManager.h
//  OffcnLiveSDK
//
//  Created by vockey on 2019/1/22.
//  Copyright © 2019年 中公教育. All rights reserved.
//

#import <Foundation/Foundation.h>

typedef NS_ENUM(NSUInteger, OffcnDownloadState) {
    OffcnDownloadStateResume = 0,//开始下载或继续下载
    OffcnDownloadStateSuspended,//暂停
    OffcnDownloadStateClean,//清除当前的视频
    OffcnDownloadStateAllClean,//清除所有的视频
    
    OffcnDownloadStateWaiting,//等待
    OffcnDownloadStateProgress,//进度//进行中
    OffcnDownloadStateCompleted,//下载完成
    OffcnDownloadStateFailed,//下载失败
};

typedef NS_ENUM(NSInteger, OffcnReachabilityStatus) {
    OffcnRealStatusUnknown = -1,
    OffcnRealStatusNotReachable = 0,
    OffcnRealStatusViaWWAN = 1,
    OffcnRealStatusViaWiFi = 2
};

@interface SDDetailedModel : NSObject

@property (nonatomic, copy) NSString *room_name;//房间名称
@property (nonatomic, copy) NSString *vod;//回放流地址m3u8--ts序号全地址
@property (nonatomic, copy) NSString *vodName;//回放流地址m3u8--只是ts序号
@property (nonatomic, copy) NSString *sqlite;//接口返回聊天数据库地址
@end

@interface OffcnDownloadManagerModel : NSObject

//沙盒所有视频所在路径
@property (nonatomic, copy) NSString *documentPath;
//沙盒每个下载视频路径
@property (nonatomic, copy) NSString *itemPath;
//沙盒每个下载视频m3u8文件路径
@property (nonatomic, copy) NSString *itemM3U8Path;
//沙盒每个下载视频聊天数据库地址
@property (nonatomic, copy) NSString *itemSqlitePath;

//口令
@property (nonatomic, copy) NSString *password;
//房间名称
@property (nonatomic, copy) NSString *room_name;
//流地址ts全地址
@property (nonatomic, copy) NSString *flowUrlStr;
//流地址ts序号地址
@property (nonatomic, copy) NSString *flowUrlPartStr;
//接口返回聊天数据库地址
@property (nonatomic, copy) NSString *sqlite;

//下载最后的ts片角标
@property (nonatomic, assign) NSInteger index;
//总ts片数据
@property (nonatomic, strong) NSArray *listArr;
//进度
@property (nonatomic, assign) float progress;

//沙盒每个下载完成的视频的本地占用大小
@property (nonatomic, copy) NSString *itemFileSize;

//任务
//@property (nonatomic, strong) NSURLSessionDownloadTask *downloadTask;
//下载状态
@property (nonatomic, assign) OffcnDownloadState downloadState;

//extensionDic 拓展字段
@property (nonatomic, strong) NSDictionary *extensionDic;
//关于鉴权的回调地址
@property (nonatomic, copy) NSString *hook;

@end


@class OffcnDownloadManager;
//下载进度OffcnDownloadStateProgress,完成OffcnDownloadStateCompleted,失败OffcnDownloadStateFailed,暂停OffcnDownloadStateSuspended回调
typedef void(^stateCallBack)(NSString *password,OffcnDownloadState state,OffcnDownloadManager *downloadManager);

//网络监测
typedef void(^reachabilityStatusCallBack)(OffcnReachabilityStatus status);

@interface OffcnDownloadManager : NSObject

//队列集合
@property (nonatomic, strong) NSMutableDictionary *blockOperationDic;
//任务集合
@property (nonatomic, strong) NSMutableDictionary *downloadTaskDic;


//沙盒所有视频所在路径
@property (nonatomic, copy) NSString *documentPath;
//实时下载数据
@property (nonatomic, strong) NSMutableDictionary *modelDic;


//下载进度OffcnDownloadStateProgress,完成OffcnDownloadStateCompleted,失败OffcnDownloadStateFailed,暂停OffcnDownloadStateSuspended回调
@property (nonatomic, copy) stateCallBack downloadStateCallBack;

//网络监测到使用手机流量提醒回调
@property (nonatomic, copy) reachabilityStatusCallBack reachabilitystatusCallBack;

/**
 创建单例

 @return 单例
 */
+ (instancetype)sharedInstance;

@property (nonatomic, assign) NSInteger maxOperationCount;

/**
 下载
 @param password 房间口令
 @param hook 鉴权回调地址(OffcnDownloadStateResume开始下载或继续下载时传入)
 @param documentPath 需要下载的沙盒路径
 @param downloadState 操作事件
 @param extensionDic 扩展字段
 */
- (void)downloadDataWithPassword:(NSString *)password hook:(NSString *)hook documentPath:(NSString *)documentPath downloadState:(OffcnDownloadState)downloadState extensionDic:(NSDictionary *)extensionDic;
@end
