package test;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.PrintWriter;
import java.io.UnsupportedEncodingException;
import java.net.URL;
import java.net.URLConnection;
import java.text.SimpleDateFormat;
import java.util.Date;


public class HttpRequest implements Runnable{

    private String url;
    private String param;
    
    public HttpRequest(String url, String param) {
		this.url = url;
		this.param = param;
	}
    
	public static void main(String[] args) {
		HttpRequest hr=new HttpRequest("http://test.tiku.eoffcn.com:81/mock/mock/newMockList","");
		hr.run();
    }
	
	@Override
	public void run() {
		System.out.println("开始时间："+new SimpleDateFormat("yyyy-MM-dd HH:mm:ss").format(new Date()));
		 PrintWriter out = null;
	        BufferedReader in = null;
	        String result = "";
	        try {
	            URL realUrl = new URL(url);
	            // 打开和URL之间的连接
	            URLConnection conn = realUrl.openConnection();
	            // 设置通用的请求属性
	            conn.setRequestProperty("Authorization", "Bearer eyJhbGciOiJIUzI1NiIsImtpZCI6ImxlZ2FjeS10b2tlbi1rZXkiLCJ0eXAiOiJKV1QifQ.eyJqdGkiOiI5MTI2ZDQ0NTI3YWY0NWI2ODM2OTM1YWZhOWZmMTVkNSIsInN1YiI6ImJlc3RidXktYWNjZXB0YW5jZSIsImF1dGhvcml0aWVzIjpbImNsaWVudHMucmVhZCIsInVhYS5yZXNvdXJjZSIsImJlc3RidXktYWNjZXB0YW5jZS5hcGkiLCJmYWN0b3Jpbmctc2VydmVyLmFwaSIsInB1aHVpLW5vdGlmaWNhdGlvbi1zZXJ2ZXIuYXBpIiwicHVodWktc2lnbi1zZXJ2ZXItcmVzdGZ1bC5hcGkiLCJwdWh1aS1zZXR0bGVtZW50LWNsb3VkLXNlcnZlci5hcGkiLCJjcmVkaXQtcXVlcnkuYXBpIl0sInNjb3BlIjpbImNsaWVudHMucmVhZCIsInVhYS5yZXNvdXJjZSIsImJlc3RidXktYWNjZXB0YW5jZS5hcGkiLCJmYWN0b3Jpbmctc2VydmVyLmFwaSIsInB1aHVpLW5vdGlmaWNhdGlvbi1zZXJ2ZXIuYXBpIiwicHVodWktc2lnbi1zZXJ2ZXItcmVzdGZ1bC5hcGkiLCJwdWh1aS1zZXR0bGVtZW50LWNsb3VkLXNlcnZlci5hcGkiLCJjcmVkaXQtcXVlcnkuYXBpIl0sImNsaWVudF9pZCI6ImJlc3RidXktYWNjZXB0YW5jZSIsImNpZCI6ImJlc3RidXktYWNjZXB0YW5jZSIsImF6cCI6ImJlc3RidXktYWNjZXB0YW5jZSIsImdyYW50X3R5cGUiOiJjbGllbnRfY3JlZGVudGlhbHMiLCJyZXZfc2lnIjoiODU0MGNmNWQiLCJpYXQiOjE0ODc1ODI5ODMsImV4cCI6MTQ4NzYyNjE4MywiaXNzIjoiaHR0cDovL2xvY2FsaG9zdDo4MDgwL3VhYS9vYXV0aC90b2tlbiIsInppZCI6InVhYSIsImF1ZCI6WyJiZXN0YnV5LWFjY2VwdGFuY2UiLCJjbGllbnRzIiwidWFhIiwiZmFjdG9yaW5nLXNlcnZlciIsInB1aHVpLW5vdGlmaWNhdGlvbi1zZXJ2ZXIiLCJwdWh1aS1zaWduLXNlcnZlci1yZXN0ZnVsIiwicHVodWktc2V0dGxlbWVudC1jbG91ZC1zZXJ2ZXIiLCJjcmVkaXQtcXVlcnkiXX0.pmCKp9XMq72z1yqKdcCHSPWilQ4FVzKqprDdNTkAX3M");
	            conn.setRequestProperty("Content-Type", "application/json");
	            // 发送POST请求必须设置如下两行
	            conn.setDoOutput(true);
	            conn.setDoInput(true);
	            // 获取URLConnection对象对应的输出流
	            out = new PrintWriter(conn.getOutputStream());
	            // 发送请求参数
	            out.print(param);
	            // flush输出流的缓冲
	            out.flush();
	            // 定义BufferedReader输入流来读取URL的响应
	            in = new BufferedReader(new InputStreamReader(conn.getInputStream()));
	            String line;
	            while ((line = in.readLine()) != null) {
	                result += line;
	                result += "\r\n";
	            }
	        } catch (Exception e) {
	            System.out.println("发送 POST 请求出现异常！"+e);
	            e.printStackTrace();
	        }
	        //使用finally块来关闭输出流、输入流
	        finally{
	            try{
	                if(out!=null){
	                    out.close();
	                }
	                if(in!=null){
	                    in.close();
	                }
	            }
	            catch(IOException ex){
	                ex.printStackTrace();
	            }
	        }
			try {
				result = new String(result.getBytes(),"utf-8");
				System.out.println(result+"结束时间："+new SimpleDateFormat("yyyy-MM-dd HH:mm:ss").format(new Date()));
			} catch (UnsupportedEncodingException e) {
				// TODO Auto-generated catch block
				e.printStackTrace();
			}
		
	}   

}
