package com.offcn.test;

import io.restassured.response.Response;

import java.sql.SQLException;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.Map.Entry;
import net.sf.json.JSONObject;
import org.testng.Assert;
import org.testng.annotations.AfterClass;
import com.offcn.TestData.offcn_api_testData;
import com.offcn.TestUnti.Log;
import com.offcn.TestUnti.MapUtil;
import com.offcn.TestUnti.Reflect_api;
import com.offcn.TestUnti.StringUtils;
import com.offcn.TestUnti.SheetUtils;
import com.offcn.TestUnti.XMLread;
import com.offcn.interfaces.API;
import com.offcn.listener.MyTestListener;
import com.offcn.listener.SkipIInvokedMethodListener;
import com.offcn.process.BasicsGM;
import com.offcn.process.TK;

import org.testng.annotations.BeforeClass;
import org.testng.annotations.Listeners;
import org.testng.annotations.Test;

//@Listeners({ SkipIInvokedMethodListener.class,MyTestListener.class})//
public class APITest_tk extends BasicsGM{
	
  @Test(dataProvider = "renmai", dataProviderClass = offcn_api_testData.class)
  public void f(HashMap<String, Object> data) {
	  System.gc();
	  Log.logInfo(data.get("serviceUrl").toString() +  data.get("Description").toString() + " is running......");
	  
	  Reflect_api Reflect=new Reflect_api();
	  Class<?> c=Reflect.ReflecClass(data);
	  Object object = Reflect.ReflecObj(c);
	  API obj = (API)object;
	  setDelSystemSql(c, object);//保存曾经操作过的系统
	  
	  BasicsGM.map=new XMLread().getSystem();
	  
	  obj.initialize(data);
	  
	  data = obj.handleInput(data);
	  
	  data=setPublicParameter(c,object,data);//静态公共参数
	  data=setDynamicParameter(c,object,data);//动态公共参数
//	 
	  String parameter = MapUtil.getValue("parameter", data);
	  Long startTime=System.currentTimeMillis();
	  Response re = obj.SendRequest(data, data.get("serviceUrl").toString(), data.get("Request").toString());
	  Long endTime=System.currentTimeMillis();
	  
	  String time=(endTime-startTime)+"毫秒";
	  String body="";
	  String codeORerrcode="";
	  String msgORerrmsy="";
	  String result = "";
	  if(re!=null){
		  body=re.asString();
		  if(body.contains("<html")){
			  body="返回html页面，状态码："+re.getStatusCode();
			  if(body.contains("<title>")){
				  int Alength="<title>".length();
				  int start=body.indexOf("<title>");
				  int end=body.indexOf("</title>")+1;
				  body="页面标题："+body.substring(start+Alength, end-1);
				  result=body;
				  if(data.get("Description").toString().contains("流程")){
					  result = obj.handleOutput(re, data);
				  }
			  }
		  }else{
			  result = obj.handleOutput(re, data);
		  }
		  codeORerrcode=getCode(re);
		  msgORerrmsy=getMsg(re);
	  }
	  
	  Log.logInfo("返回结果="+StringUtils.decodeUnicode(body));
	  System.out.println();
	  System.out.println();
	  
	  
	  //数据回写
	/*  HashMap<String, Object> ExpectResult=MapUtil.Expect(data);
	  SheetUtils sheet = new SheetUtils("DataAll.xls", "Output");
	  sheet.writeExcel(
			  		data.get("NO").toString(),
				  	data.get("TCNO").toString() + "_Step" + data.get("Step").toString(),
				  	data.get("Description").toString(),
				  	parameter.length()>1000?"内容超长。":parameter, 
					JSONObject.fromObject(ExpectResult).toString(),
					StringUtils.decodeUnicode(re.asString().length()>10000?"内容超长。状态码："+re.getStatusCode():re.asString()),
					codeORerrcode,
					msgORerrmsy,
					result,
					time
					);
	  */
	  
	  if(result.indexOf("Fail")!=-1){
		  String Expect1=data.get("code")==null?"":data.get("code").toString();
		  String Expect2=data.get("msg")==null?"":data.get("msg").toString();
		  String Expect3=data.get("custom")==null?"":data.get("custom").toString();
		  if(body.contains("HTML")){
			  body="异常页面信息";
		  }
		  Assert.assertEquals(StringUtils.decodeUnicode(body),Expect1+","+Expect2+","+Expect3);
	  }else{
		  Assert.assertTrue(true);
	  }
  }

  @AfterClass
  public void afterClass() {
	  Set<Map.Entry<Class<?>,Object>> set=Delsql.entrySet();
	  Iterator<Entry<Class<?>,Object>> it=set.iterator();
	  while(it.hasNext()){
		  Map.Entry<Class<?>,Object> me=it.next();
		  Class<?> c=me.getKey();
		  Object object=me.getValue();
		  this.cleanMysqlData(c,object);
	  }
	  this.CloseMysql();
	  Log.logInfo("========测试结束========");
	  
  }

}
