package com.offcn.api.xyzb;

import io.restassured.path.json.JsonPath;
import io.restassured.response.Response;

import java.sql.ResultSet;
import java.util.HashMap;
import java.util.Map;
import java.util.Random;

import com.offcn.TestUnti.Log;
import com.offcn.TestUnti.MapUtil;
import com.offcn.TestUnti.MyDateUtil;
import com.offcn.TestUnti.ReadProperties;
import com.offcn.TestUnti.RequestDataUtils;
import com.offcn.TestUnti.StringUtils;
import com.offcn.interfaces.API;
import com.offcn.process.BasicsGM;
import com.offcn.process.XYZB;



/**
 * 更新房间状态,休息或不休息
 * 
 * @author puhui
 *
 */
public class room_rest_status extends XYZB implements API {
	public String parameter;//参数集合
	public String Description;
	
	public String rest_status;//rest_status

	@Override
	public void initialize(HashMap<String, Object> data) {
	}

	@Override
	public HashMap<String, Object> handleInput(HashMap<String, Object> data) {
		// 获取parameter对应的内容
		parameter = MapUtil.getValue("parameter", data);
		rest_status = MapUtil.getParameter(parameter, "rest_status").trim();
		rest_status = MapUtil.killQuotes(rest_status, "\"");//去掉双引号的bankName
		
		// 替换原来的parameter
		data.put("parameter", parameter);
		return data;
	}

	@Override
	public Response SendRequest(HashMap<String, Object> data, String Url,
			String Request) {
		Map<String, Object>  jsonAsMap = new HashMap<>();
		
		jsonAsMap.put("rest_status", rest_status);
		
//		System.out.println(room_nums.get("Not_edited"));
		Response re = RequestDataUtils.Put_Token(data,Client_token, Url,jsonAsMap);
		return re;
	}

	@Override
	public String handleOutput(Response re, HashMap<String, Object> data) {
		
		JsonPath jp = re.body().jsonPath();
		boolean result = true;
		String failReason = "";

		String json = re.asString();

		if ((data.get("statusCode") != null)
				&& (!data.get("statusCode").toString()
						.equals(String.valueOf(re.getStatusCode())))) {
			result = result && false;
			failReason = failReason + "statusCode is expected "
					+ data.get("statusCode").toString() + " but actually "
					+ String.valueOf(re.getStatusCode()) + ". ";
		}

		if (json.length() != 0) {
			
			String msg=StringUtils.decodeUnicode(jp.getString("msg"));
			
			if ((data.get("code") != null )
					&& ((jp.getString("code") == null) || (!jp.getString(
							"code").equals(data.get("code").toString())))) {
				result = result && false;
				failReason = failReason + "code is expected "
						+ data.get("code").toString() + " but actually "
						+ jp.getString("code") + ".";
			}

			if ((data.get("msg") != null)
					&& ((msg == null) || (!msg.equals(data.get("msg").toString())))) {
				result = result && false;
				failReason = failReason + "msg is expected "
						+ data.get("msg").toString() + " but actually "
						+ jp.getString("msg") + ".";
			}
			
			if(data.get("custom") != null && jp.getString("data").length()>4){
				String custom=data.get("custom").toString();
				String[] ArrayString=StringUtils.getArrayString(custom,",");
				if(!StringUtils.VerificationString(jp.getString("data"),ArrayString)){
					result = result && false;
					failReason = failReason + "custom is expected "
							+ data.get("custom").toString() + " but actually "
							+ jp.getString("data") + ".";
				}
			}
			if("操作成功".equals(jp.getString("msg"))){
				
				try {
					parameter = MapUtil.getValue("parameter", data);
					
					ResultSet rs_bankcard=null;
					
					rs_bankcard = this.selectFromDB(
							" xyu_room r ",
							" r.room_num = '" + Current_room + "' ");
					rs_bankcard.last();
					
					String act_rest_status = String
							.valueOf(rs_bankcard.getString(rs_bankcard.findColumn("rest_status")));
					
					if(!rest_status.equals(act_rest_status)){
						result = result && false;
						failReason = failReason + "xyu_room  is not  find;";
					}
					
				} catch (Exception e) {
					result = result && false;
					failReason = failReason + "cannot verify xyu_room info in DB;";
					e.printStackTrace();
				}
			}
			
		}
		
		if (result){
			return "Pass";
		}else{
			return "Fail:" + failReason;
		}
	}

	
}
