package com.offcn.api.xyzb;

import io.restassured.path.json.JsonPath;
import io.restassured.response.Response;

import java.sql.ResultSet;
import java.util.HashMap;
import java.util.Map;
import java.util.Random;

import com.offcn.TestUnti.Log;
import com.offcn.TestUnti.MapUtil;
import com.offcn.TestUnti.MyDateUtil;
import com.offcn.TestUnti.ReadProperties;
import com.offcn.TestUnti.RequestDataUtils;
import com.offcn.TestUnti.StringUtils;
import com.offcn.interfaces.API;
import com.offcn.process.BasicsGM;
import com.offcn.process.XYZB;



/**
 * 更新房间信息
 * 
 * @author puhui
 *
 */
public class room_info_up extends XYZB implements API {
	public String parameter;//参数集合
	public String Description;
	
	public String room_name;//nickname

	@Override
	public void initialize(HashMap<String, Object> data) {
	}

	@Override
	public HashMap<String, Object> handleInput(HashMap<String, Object> data) {
		// 获取parameter对应的内容
		parameter = MapUtil.getValue("parameter", data);
		room_name = MapUtil.getParameter(parameter, "room_name").trim();
		
		if ((!room_name.equals("")) && room_name.equals("random")) {
			room_name="ys"+(new Random().nextInt(90000000)+ 10000000);
			parameter = parameter.replace("\"room_name\":random", "\"room_name\":\""+ room_name + "\"");
		}
		
		// 替换原来的parameter
		data.put("parameter", parameter);
		return data;
	}

	@Override
	public Response SendRequest(HashMap<String, Object> data, String Url,
			String Request) {
		Map<String, Object>  jsonAsMap = new HashMap<>();
		parameter = MapUtil.getValue("parameter", data);
		room_name = MapUtil.getParameter(parameter, "room_name").trim();
		room_name = MapUtil.killQuotes(room_name, "\"");//去掉双引号的name
		
		jsonAsMap.put("room_name", room_name);
		
//		System.out.println(room_nums.get("Not_edited"));
		Response re = RequestDataUtils.Put_Token(data,Client_token, "/api/v1/room_info",jsonAsMap);
		return re;
	}

	@Override
	public String handleOutput(Response re, HashMap<String, Object> data) {
		
		JsonPath jp = re.body().jsonPath();
		boolean result = true;
		String failReason = "";

		String json = re.asString();

		if ((data.get("statusCode") != null)
				&& (!data.get("statusCode").toString()
						.equals(String.valueOf(re.getStatusCode())))) {
			result = result && false;
			failReason = failReason + "statusCode is expected "
					+ data.get("statusCode").toString() + " but actually "
					+ String.valueOf(re.getStatusCode()) + ". ";
		}

		if (json.length() != 0) {
			
			String msg=StringUtils.decodeUnicode(jp.getString("msg"));
			
			if ((data.get("code") != null )
					&& ((jp.getString("code") == null) || (!jp.getString(
							"code").equals(data.get("code").toString())))) {
				result = result && false;
				failReason = failReason + "code is expected "
						+ data.get("code").toString() + " but actually "
						+ jp.getString("code") + ".";
			}

			if ((data.get("msg") != null)
					&& ((msg == null) || (!msg.equals(data.get("msg").toString())))) {
				result = result && false;
				failReason = failReason + "msg is expected "
						+ data.get("msg").toString() + " but actually "
						+ jp.getString("msg") + ".";
			}
			
			if(data.get("custom") != null && jp.getString("data").length()>4){
				String custom=data.get("custom").toString();
				String[] ArrayString=StringUtils.getArrayString(custom,",");
				if(!StringUtils.VerificationString(jp.getString("data"),ArrayString)){
					result = result && false;
					failReason = failReason + "custom is expected "
							+ data.get("custom").toString() + " but actually "
							+ jp.getString("data") + ".";
				}
			}
			if("操作成功".equals(jp.getString("msg"))){
				
				try {
					parameter = MapUtil.getValue("parameter", data);
					
					ResultSet rs_bankcard=null;
					
					if(!parameter.contains("role")){
						rs_bankcard = this.selectFromDB(
								" xyu_room r ",
								" r.room_name = '" + room_name + "'  ");
						rs_bankcard.last();
					System.out.println(rs_bankcard.getRow());
					}
//					System.out.println(rs_bankcard.getString("id"));
					if(rs_bankcard.getRow()==0){
						result = result && false;
						failReason = failReason + "xyu_room  is not  find;";
					}
					
				} catch (Exception e) {
					result = result && false;
					failReason = failReason + "cannot verify xyu_room info in DB;";
					e.printStackTrace();
				}
			}
			
		}
		
		if (result){
			return "Pass";
		}else{
			return "Fail:" + failReason;
		}
	}

	
}
