package com.offcn.api.xyzb;

import io.restassured.path.json.JsonPath;
import io.restassured.response.Response;

import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.HashMap;
import java.util.Random;

import org.json.simple.JSONArray;

import com.offcn.TestUnti.Log;
import com.offcn.TestUnti.MapUtil;
import com.offcn.TestUnti.MyDateUtil;
import com.offcn.TestUnti.ReadProperties;
import com.offcn.TestUnti.RequestDataUtils;
import com.offcn.TestUnti.StringUtils;
import com.offcn.interfaces.API;
import com.offcn.process.XYZB;

import net.sf.json.JSONObject;



/**
 * 提交回答
 * 
 * @author puhui
 *
 */
public class answer extends XYZB implements API {
	public String parameter;//参数集合
	
	public String id;//
	public String answer;//
	public String private_;//

	@Override
	public void initialize(HashMap<String, Object> data) {
	}

	@Override
	public HashMap<String, Object> handleInput(HashMap<String, Object> data) {
		parameter = MapUtil.getValue("parameter", data);
		id = MapUtil.getParameter(parameter, "id").trim();
		answer = MapUtil.getParameter(parameter, "answer").trim();
		private_ = MapUtil.getParameter(parameter, "private").trim();
		
		if ((!id.equals("")) && id.equals("code")) {
			id=Current_questions_id;
			parameter = parameter.replace("\"id\":code", "\"id\":\""+ Current_questions_id + "\"");
		}
		if ((!answer.equals("")) && answer.equals("random")) {
			answer="我也不会啊。。。";
			parameter = parameter.replace("\"answer\":random", "\"answer\":\""+ answer + "\"");
		}
		if (!private_.equals("")) {
			parameter = parameter.replace("\"private_\"", "\"private\"");
		}
		data.put("parameter", parameter);
		return data;
	}

	@Override
	public Response SendRequest(HashMap<String, Object> data, String Url,
			String Request) {
		Response re = RequestDataUtils.Post_token(data, Url,Client_token);
		return re;
	}

	@Override
	public String handleOutput(Response re, HashMap<String, Object> data) {
		JsonPath jp = re.body().jsonPath();
		boolean result = true;
		String failReason = "";

		String json = re.asString();

		if ((data.get("statusCode") != null)
				&& (!data.get("statusCode").toString()
						.equals(String.valueOf(re.getStatusCode())))) {
			result = result && false;
			failReason = failReason + "statusCode is expected "
					+ data.get("statusCode").toString() + " but actually "
					+ String.valueOf(re.getStatusCode()) + ". ";
		}

		if (json.length() != 0) {
			
			String msg=StringUtils.decodeUnicode(jp.getString("msg"));
			
			if ((data.get("code") != null )
					&& ((jp.getString("code") == null) || (!jp.getString(
							"code").equals(data.get("code").toString())))) {
				result = result && false;
				failReason = failReason + "code is expected "
						+ data.get("code").toString() + " but actually "
						+ jp.getString("code") + ".";
			}

			if ((data.get("msg") != null)
					&& ((msg == null) || (!msg.equals(data.get("msg").toString())))) {
				result = result && false;
				failReason = failReason + "msg is expected "
						+ data.get("msg").toString() + " but actually "
						+ jp.getString("msg") + ".";
			}
			
			if(data.get("custom") != null && jp.getString("data")!=null){
				String custom=data.get("custom").toString();
				String[] ArrayString=StringUtils.getArrayString(custom,",");
				if(!StringUtils.VerificationString(jp.getString("data"),ArrayString)){
					result = result && false;
					failReason = failReason + "custom is expected "
							+ data.get("custom").toString() + " but actually "
							+ jp.getString("data") + ".";
				}
			}
			
			if("操作成功".equals(jp.getString("msg"))){
				
				//是否是线上环境
				if (!isProduct) {
					private_ = MapUtil.killQuotes(private_, "\"");//去掉双引号的private_
					answer = MapUtil.killQuotes(answer, "\"");//去掉双引号的answer
					id = MapUtil.killQuotes(id, "\"");//去掉双引号的id
					
					try {
						ResultSet rs_bankcard = this.selectFromDB(
								" xyu_room_answer  ",
								" 1 = 1");
						rs_bankcard.last();
						
						if (rs_bankcard.getRow() < 1) {
							result = result && false;
							failReason = failReason + "xyu_room_answer info is not in DB;";
						} else {
							
							String act_id = String
									.valueOf(rs_bankcard.getString(rs_bankcard.findColumn("id")));
							String act_answer = String
									.valueOf(rs_bankcard.getString(rs_bankcard.findColumn("answer")));
							act_answer = MapUtil.killQuotes(act_answer, "\"");
							
							String act_question_id = String
									.valueOf(rs_bankcard.getString(rs_bankcard.findColumn("question_id")));
							String act_private = String
									.valueOf(rs_bankcard.getString(rs_bankcard.findColumn("private")));
							
//							System.out.println(private_);
//							System.out.println(act_private);
//							System.out.println(answer);
//							System.out.println(StringUtils.decodeUnicode(act_answer));
//							System.out.println(id);
//							System.out.println(act_question_id);
//							if ((!private_.equals(act_private))
							if ( (!answer.equals(StringUtils.decodeUnicode(act_answer)))
									|| (!id.equals(act_question_id))){
								result = result && false;
								failReason = failReason + "xyu_room_answer info in DB is wrong;";
							} 
						}
					} catch (Exception e) {
						e.printStackTrace();
						result = result && false;
						failReason = failReason + "cannot verify xyu_room_answer info in DB;";
						e.printStackTrace();
					}
				}
			}
			
			
		}
		if (result)
			return "Pass";
		else
			return "Fail:" + failReason;
	}

}
