package com.offcn.api.tk.newApp;

import io.restassured.path.json.JsonPath;
import io.restassured.response.Response;

import java.util.HashMap;

import com.offcn.TestUnti.ListUtil;
import com.offcn.TestUnti.MapUtil;
import com.offcn.TestUnti.RequestDataUtils;
import com.offcn.TestUnti.StringUtils;
import com.offcn.interfaces.API;
import com.offcn.process.TK;

public class getEstimatePaperJson extends TK implements API {
	public String parameter;//参数集合
	
	public String user_id; //用户id
	public String paper_id; //试卷id
	public String record_id; //做题记录id
	public String examine_paper_id; //估分考试下的考试科目id
	
	

	@Override
	public void initialize(HashMap<String, Object> data) {
		if (!isProduct && data.get("CleanDB").toString().contains("Y")) {
			cleanUser_FromDB();//清除注册用户根据user_id
		}
	}

	@Override
	public HashMap<String, Object> handleInput(HashMap<String, Object> data) {
		parameter = MapUtil.getValue("parameter", data);
		user_id = MapUtil.getParameter_accurate(parameter, "user_id").trim();
		paper_id = MapUtil.getParameter_accurate(parameter, "paper_id").trim();
		record_id = MapUtil.getParameter_accurate(parameter, "record_id").trim();
		examine_paper_id = MapUtil.getParameter_accurate(parameter, "examine_paper_id").trim();
		if ((!user_id.equals("")) && user_id.equals("code")) {
			user_id=ListUtil.getListValue(user_idList,0);
			parameter = parameter.replace("\"user_id\":code", "\"user_id\":\""+ user_id + "\"");
		}
		data.put("parameter", parameter);
		return data;
	}

	@Override
	public Response SendRequest(HashMap<String, Object> data, String Url,
			String Request) {
		Response re = RequestDataUtils.Post_token(data, Url, tk_token);
		return re;
	}

	@Override
	public String handleOutput(Response re, HashMap<String, Object> data) {
		JsonPath jp = re.body().jsonPath();
		boolean result = true;
		String failReason = "";

		String json = StringUtils.decodeUnicode(re.asString());

		if ((data.get("statusCode") != null)
				&& (!data.get("statusCode").toString()
						.equals(String.valueOf(re.getStatusCode())))) {
			result = result && false;
			failReason = failReason + "statusCode is expected "
					+ data.get("statusCode").toString() + " but actually "
					+ String.valueOf(re.getStatusCode()) + ". ";
		}

		if (json.length() != 0) {
			
			String msg=jp.getString("message");
			String code=jp.getString("retcode");
			
			
			if ((data.get("code") != null ) && (code != null) && (!code.equals(data.get("code").toString()))) {
				result = result && false;
				failReason = failReason + "code is expected "
						+ data.get("code").toString() + " but actually "
						+ jp.getString("code") + ".";
			}

			if ((data.get("msg") != null) && (msg != null) && (!msg.equals(data.get("msg").toString()))) {
				result = result && false;
				failReason = failReason + "msg is expected "
						+ data.get("msg").toString() + " but actually "
						+ jp.getString("msg") + ".";
			}
			
			if(data.get("custom") != null && jp.getString("data")!=null){
				String custom=data.get("custom").toString();
				String[] ArrayString=StringUtils.getArrayString(custom,",");
				if(!StringUtils.VerificationString(jp.getString("data"),ArrayString)){
					result = result && false;
					failReason = failReason + "custom is expected "
							+ data.get("custom").toString() + " but actually "
							+ jp.getString("data") + ".";
				}
			}
			
			if("接口响应成功！".equals(msg)){
			
			}
		}
		if (result)
			return "Pass";
		else
			return "Fail:" + failReason;
	}

}
