package com.offcn.api.tk.ht;

import io.restassured.path.json.JsonPath;
import io.restassured.response.Response;

import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import java.util.Random;

import org.apache.http.Header;
import org.apache.http.HttpResponse;
import org.apache.http.util.EntityUtils;
import org.json.simple.JSONArray;

import test.HttpUtils;

import com.offcn.TestUnti.Log;
import com.offcn.TestUnti.MapUtil;
import com.offcn.TestUnti.ReadProperties;
import com.offcn.TestUnti.RequestDataUtils;
import com.offcn.TestUnti.StringUtils;
import com.offcn.interfaces.API;
import com.offcn.process.HT;
import com.offcn.process.NWN;
import com.offcn.process.TK;
import com.offcn.process.XYZB;
import com.offcn.system.MyRequest;

import net.sf.json.JSONObject;



/**
 *获取PHPSESSID
 * 
 * @author puhui
 *
 */
public class newMockList extends HT implements API {
	
	@Override
	public void initialize(HashMap<String, Object> data) {
	}

	@Override
	public HashMap<String, Object> handleInput(HashMap<String, Object> data) {
		return data;
	}

	@Override
	public Response SendRequest(HashMap<String, Object> data, String Url,
			String Request) {
		
		
		MyRequest myRequest=new MyRequest();
		myRequest.setRequest(Request);
		myRequest.setUrl(Url);
		if(!"".equals(PHPSESSID)){
			Map<String, String> Cookies=new HashMap<String, String>();
			Cookies.put("PHPSESSID", PHPSESSID);
			Cookies.put("admin_login_ssid", admin_login_ssid);
//			myRequest.setHeaders(Cookies);
			myRequest.setCookies(Cookies);
		}
		
		Response re = RequestDataUtils.RestAssuredApi(data,myRequest);
		
		return re;
		
	}

	@Override
	public String handleOutput(Response re, HashMap<String, Object> data) {
		
		JsonPath jp = re.body().jsonPath();
		boolean result = true;
		String failReason = "";

		String json = StringUtils.decodeUnicode(re.asString());

		if ((data.get("statusCode") != null)
				&& (!data.get("statusCode").toString()
						.equals(String.valueOf(re.getStatusCode())))) {
			result = result && false;
			failReason = failReason + "statusCode is expected "
					+ data.get("statusCode").toString() + " but actually "
					+ String.valueOf(re.getStatusCode()) + ". ";
		}
		
		 Log.logInfo("获取PHPSESSID："+re.getCookie("PHPSESSID"));
		if(re.getCookie("PHPSESSID") !=null){
			PHPSESSID=re.getCookie("PHPSESSID");
		}
		
		if (result)
			return "Pass";
		else
			return "Fail:" + failReason;
	}

}
