package com.offcn.api.tk.ht;

import io.restassured.path.json.JsonPath;
import io.restassured.response.Response;

import java.util.HashMap;
import java.util.Map;

import com.offcn.TestUnti.MapUtil;
import com.offcn.TestUnti.RequestDataUtils;
import com.offcn.TestUnti.StringUtils;
import com.offcn.interfaces.API;
import com.offcn.process.HT;
import com.offcn.system.MyRequest;




/**
 * 83.模考管理-模考大赛列表页接口
 * 
 * @author puhui
 *
 */
public class mockList extends HT implements API {
	public String parameter;//参数集合
	
	@Override
	public void initialize(HashMap<String, Object> data) {
	}

	@Override
	public HashMap<String, Object> handleInput(HashMap<String, Object> data) {
		// 获取parameter对应的内容
		parameter = MapUtil.getValue("parameter", data);
		return data;
	}

	@Override
	public Response SendRequest(HashMap<String, Object> data, String Url,
			String Request) {
		
		MyRequest myRequest=new MyRequest();
		myRequest.setRequest(Request);
		myRequest.setUrl(Url);
		if(!"".equals(PHPSESSID)){
			Map<String, String> Cookies=new HashMap<String, String>();
			Cookies.put("PHPSESSID", PHPSESSID);
			myRequest.setCookies(Cookies);
		}
		
		Response re = RequestDataUtils.RestAssuredApi(data,myRequest);
//		Response re = RequestDataUtils.POST_houtai(data,myRequest);
		return re;
	}

	@Override
	public String handleOutput(Response re, HashMap<String, Object> data) {
//		JsonPath jp = re.body().jsonPath();
		
		boolean result = true;
		String failReason = "";

		String json = re.asString().substring(1);
		JsonPath jp = new JsonPath(json);

		if ((data.get("statusCode") != null)
				&& (!data.get("statusCode").toString()
						.equals(String.valueOf(re.getStatusCode())))) {
			result = result && false;
			failReason = failReason + "statusCode is expected "
					+ data.get("statusCode").toString() + " but actually "
					+ String.valueOf(re.getStatusCode()) + ". ";
		}

		if (json.length() != 0) {
			
			String msg=jp.getString("message");
			String code=jp.getString("retcode");
			
			if ((data.get("code") != null ) && (code != null) && (!code.equals(data.get("code").toString()))) {
				result = result && false;
				failReason = failReason + "code is expected "
						+ data.get("code").toString() + " but actually "
						+ jp.getString("code") + ".";
			}

			if ((data.get("msg") != null) && (msg != null) && (!msg.equals(data.get("msg").toString()))) {
				result = result && false;
				failReason = failReason + "msg is expected "
						+ data.get("msg").toString() + " but actually "
						+ jp.getString("msg") + ".";
			}
			
			if(data.get("custom") != null && jp.getString("data")!=null){
				String custom=data.get("custom").toString();
				String[] ArrayString=StringUtils.getArrayString(custom,",");
//				System.out.println(jp.getString("custom"));
//				System.out.println(Arrays.toString(ArrayString));
				if(!StringUtils.VerificationString(jp.getString("data"),ArrayString)){
					result = result && false;
					failReason = failReason + "custom is expected "
							+ data.get("custom").toString() + " but actually "
							+ jp.getString("data") + ".";
				}
			}
			
		}
		
		if (result)
			return "Pass";
		else
			return "Fail:" + failReason;
	}

}
