package com.offcn.api.tk.ht;

import io.restassured.http.Headers;
import io.restassured.path.json.JsonPath;
import io.restassured.response.Response;

import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;

import org.json.simple.JSONArray;

import com.offcn.TestUnti.Log;
import com.offcn.TestUnti.MapUtil;
import com.offcn.TestUnti.RequestDataUtils;
import com.offcn.TestUnti.RequestDataUtils2;
import com.offcn.TestUnti.StringUtils;
import com.offcn.interfaces.API;
import com.offcn.process.HT;
import com.offcn.process.NWN;
import com.offcn.process.TK;
import com.offcn.system.MyRequest;
import com.offcn.TestUnti.ListUtil;

import net.sf.json.JSONObject;



/**
 * nwn后台登录接口
 * 
 * @author puhui
 *
 */
public class login extends HT implements API {
	public String parameter;//参数集合
	
	public String user_name;//登录用户名
	public String password;//密码

	@Override
	public void initialize(HashMap<String, Object> data) {
	}

	@Override
	public HashMap<String, Object> handleInput(HashMap<String, Object> data) {
		parameter = MapUtil.getValue("parameter", data);
		return data;
	}

	@Override
	public Response SendRequest(HashMap<String, Object> data, String Url,
			String Request) {
		data.put("parameter", parameter);
		user_name = MapUtil.getParameter(parameter, "user_name").trim();
		user_name = MapUtil.killQuotes(user_name, "\"");
		
		password = MapUtil.getParameter(parameter, "password").trim();
		password = MapUtil.killQuotes(password, "\"");
		
		
		Map<String,String> formParameter=new HashMap<String,String>();
		formParameter.put("user_name", user_name);
		formParameter.put("password", password);
		formParameter.put("app_id", app_id);
		formParameter.put("ref", ref);
		
		MyRequest myRequest=new MyRequest();
		myRequest.setRequest(Request);
		myRequest.setUrl(Url+".html?action=login");
		myRequest.setFormParameter(formParameter);
		
		Map<String, String> Cookies=new HashMap<String, String>();
		if(!"".equals(PHPSESSID)){
			Cookies.put("PHPSESSID", PHPSESSID);
		}
		if(!"".equals(admin_login_ssid)){
			Cookies.put("admin_login_ssid", admin_login_ssid);
		}
		if(Cookies.size()>0){
			myRequest.setCookies(Cookies);
		}
		
		Response re = RequestDataUtils.RestAssuredApi(data,myRequest);
		return re;
	}

	@Override
	public String handleOutput(Response re, HashMap<String, Object> data) {
		JsonPath jp = re.body().jsonPath();
		boolean result = true;
		String failReason = "";

		String json = re.asString();

		if ((data.get("statusCode") != null)
				&& (!data.get("statusCode").toString()
						.equals(String.valueOf(re.getStatusCode())))) {
			result = result && false;
			failReason = failReason + "statusCode is expected "
					+ data.get("statusCode").toString() + " but actually "
					+ String.valueOf(re.getStatusCode()) + ". ";
		}

		admin_login_ssid=re.getCookie("admin_login_ssid");
		Log.logInfo("登录流程admin_login_ssid:"+admin_login_ssid);
		
//		url=jp.getString("url");
//		 Log.logInfo("json:"+json);
		if (result)
			return "Pass";
		else
			return "Fail:" + failReason;
	}

}
