package com.offcn.api.tk.app2;

import io.restassured.path.json.JsonPath;
import io.restassured.response.Response;

import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Random;

import org.json.simple.JSONArray;

import com.offcn.TestUnti.Log;
import com.offcn.TestUnti.MapUtil;
import com.offcn.TestUnti.MySqlUtil;
import com.offcn.TestUnti.RequestDataUtils;
import com.offcn.TestUnti.StringUtils;
import com.offcn.TestUnti.VerificationMethod;
import com.offcn.interfaces.API;
import com.offcn.process.TK;
import com.offcn.TestUnti.ListUtil;

import net.sf.json.JSONObject;



/**
 * 79. 智能批改-提交申论做题记录,(85.模考大赛-获取试卷json文件+做题记录+主观题试题的采分结构,调完85接口后才能调用79接口)
 * 
 * @author puhui
 *
 */
public class submitMockExpounding extends TK implements API {
	public String parameter;//参数集合
	
	public String parameterData;//用户id
	public String user_id;//用户id

	@Override
	public void initialize(HashMap<String, Object> data) {
		if (!isProduct && data.get("CleanDB").toString().contains("Y")) {
			cleanUser_FromDB();//清除注册用户根据user_id
		}
	}

	@Override
	public HashMap<String, Object> handleInput(HashMap<String, Object> data) {
		// 获取parameter对应的内容
		parameter = MapUtil.getValue("parameter", data);
		user_id = MapUtil.getParameter(parameter, "user_id").trim();
		parameterData = MapUtil.getParameter(parameter, "parameterData").trim();
		
		if ((!user_id.equals("")) && user_id.equals("code")) {
			user_id=ListUtil.getListValue(user_idList,0);
			parameter = parameter.replace("\"user_id\":code", "\"user_id\":\""+ user_id + "\"");
		}
		if ((!parameterData.equals("")) && parameterData.equals("code")) {
			parameterData="{\\\"channel\\\":\\\"1\\\",\\\"orgin\\\":\\\"3\\\",\\\"orgin_id\\\":\\\"4362\\\",\\\"record_id\\\":\\\"458\\\",\\\"is_final\\\":\\\"1\\\",\\\"user_id\\\":\\\"11292\\\",\\\"questions\\\":[{\\\"question_number\\\":\\\"1\\\",\\\"user_answer\\\":[{\\\"score_section_id\\\":\\\"0\\\",\\\"content\\\":\\\"作为中国城镇化推进过程中的一个实验性物种，特色小镇外溢出了不小的经济价值。\\\",\\\"content_section_id\\\":\\\"0\\\"}],\\\"is_hf\\\":\\\"1\\\",\\\"duration\\\":\\\"31\\\",\\\"question_id\\\":\\\"109015\\\",\\\"is_signed\\\":\\\"0\\\",\\\"type\\\":\\\"1\\\"},{\\\"question_number\\\":\\\"2\\\",\\\"user_answer\\\":[{\\\"score_section_id\\\":\\\"0\\\",\\\"content\\\":\\\"南有周庄，北有周窝\\\",\\\"content_section_id\\\":\\\"0\\\"}],\\\"is_hf\\\":\\\"1\\\",\\\"duration\\\":\\\"71\\\",\\\"question_id\\\":\\\"109016\\\",\\\"is_signed\\\":\\\"0\\\",\\\"type\\\":\\\"1\\\"},{\\\"question_number\\\":\\\"3\\\",\\\"user_answer\\\":[],\\\"is_hf\\\":\\\"1\\\",\\\"duration\\\":\\\"999\\\",\\\"question_id\\\":\\\"109017\\\",\\\"is_signed\\\":\\\"0\\\",\\\"type\\\":\\\"1\\\"},{\\\"question_number\\\":\\\"4\\\",\\\"user_answer\\\":[{\\\"score_section_id\\\":\\\"0\\\",\\\"content\\\":\\\"呵呵就不给机会\\\",\\\"content_section_id\\\":\\\"0\\\"}],\\\"is_hf\\\":\\\"1\\\",\\\"duration\\\":\\\"23\\\",\\\"question_id\\\":\\\"109018\\\",\\\"is_signed\\\":\\\"0\\\",\\\"type\\\":\\\"1\\\"}],\\\"exam_id\\\":\\\"51\\\"}";
			parameter = parameter.replace("\"parameterData\":code", "\"data\":\""+ parameterData+"\"" );
		}
		data.put("parameter", parameter);
		return data;
	}

	@Override
	public Response SendRequest(HashMap<String, Object> data, String Url,
			String Request) {
		Response re = RequestDataUtils.Post_token(data, Url, tk_token);
		return re;
	}

	@Override
	public String handleOutput(Response re, HashMap<String, Object> data) {
		JsonPath jp = re.body().jsonPath();
		boolean result = true;
		String failReason = "";

		String json = StringUtils.decodeUnicode(re.asString());

		if ((data.get("statusCode") != null)
				&& (!data.get("statusCode").toString()
						.equals(String.valueOf(re.getStatusCode())))) {
			result = result && false;
			failReason = failReason + "statusCode is expected "
					+ data.get("statusCode").toString() + " but actually "
					+ String.valueOf(re.getStatusCode()) + ". ";
		}

		if (json.length() != 0) {
			
			String msg=jp.getString("message");
			String code=jp.getString("retcode");
			
			
			if ((data.get("code") != null ) && (code != null) && (!code.equals(data.get("code").toString()))) {
				result = result && false;
				failReason = failReason + "code is expected "
						+ data.get("code").toString() + " but actually "
						+ jp.getString("retcode") + ".";
			}

			if ((data.get("msg") != null) && (msg != null) && (!msg.equals(data.get("msg").toString()))) {
				result = result && false;
				failReason = failReason + "msg is expected "
						+ data.get("msg").toString() + " but actually "
						+ jp.getString("retcode") + ".";
			}
			
			if(data.get("custom") != null && json!=null){
				//如果自定义结果包含多个希望结果，也就是有逗号，那么就切割，包含比较。
				if(data.get("custom").toString().contains(",")){
					String [] strCustomStrings=data.get("custom").toString().split(",");
					for(int i=0;i<strCustomStrings.length;i++){
						if(!json.contains(strCustomStrings[i])){
							result = result && false;
							failReason = failReason + "custom is expected "
									+ data.get("custom").toString() + " but actually "
									+ strCustomStrings[i] + ".";
							break;
						}
					}
				}else{//如果只有一个希望结果，就直接包含比较。
					if(!json.contains(data.get("custom").toString())){
						result = result && false;
						failReason = failReason + "custom is expected "
								+ data.get("custom").toString() + " but actually "
								+ data.get("custom").toString() + ".";
					}
				}
			}
			
			if("0".equals(code)){
				
			}
		}
		if (result)
			return "Pass";
		else
			return "Fail:" + failReason;
	}

}
