package com.offcn.api.tk.app;

import io.restassured.path.json.JsonPath;
import io.restassured.response.Response;

import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.HashMap;

import org.json.simple.JSONArray;

import com.offcn.TestUnti.Log;
import com.offcn.TestUnti.MapUtil;
import com.offcn.TestUnti.RequestDataUtils;
import com.offcn.TestUnti.StringUtils;
import com.offcn.interfaces.API;
import com.offcn.process.TK;
import com.offcn.TestUnti.ListUtil;

import net.sf.json.JSONObject;



/**
 * app登录
 * 
 * @author puhui
 *
 */
public class login extends TK implements API {
	public String parameter;//参数集合
	
	public String phone;//手机号
	public String passwd;//密码
	public String system;//手机系统信息
	public String platform;//手机平台
	public String version;//版本号
	public String device_id;//设备号

	@Override
	public void initialize(HashMap<String, Object> data) {
	}

	@Override
	public HashMap<String, Object> handleInput(HashMap<String, Object> data) {
		// 获取parameter对应的内容
		parameter = MapUtil.getValue("parameter", data);
		phone = MapUtil.getParameter(parameter, "phone").trim();
		
		if ((!phone.equals("")) && phone.equals("code")) {
			parameter = parameter.replace("\"phone\":code", "\"phone\":\""+ phoneNeb + "\"");
		}
		
		phone = MapUtil.getParameter(parameter, "phone").trim();
		
		data.put("parameter", parameter);
		return data;
	}

	@Override
	public Response SendRequest(HashMap<String, Object> data, String Url,
			String Request) {
		Response re = RequestDataUtils.Post_NOtokenNOcookie(data, Url);
		return re;
	}

	@Override
	public String handleOutput(Response re, HashMap<String, Object> data) {
		JsonPath jp = re.body().jsonPath();
		boolean result = true;
		String failReason = "";

		String json = re.asString();

		if ((data.get("statusCode") != null)
				&& (!data.get("statusCode").toString()
						.equals(String.valueOf(re.getStatusCode())))) {
			result = result && false;
			failReason = failReason + "statusCode is expected "
					+ data.get("statusCode").toString() + " but actually "
					+ String.valueOf(re.getStatusCode()) + ". ";
		}

		if (json.length() != 0) {
			
			String msg=StringUtils.decodeUnicode(getMsg(re));
			String code=getCode(re);
			
			if ((data.get("code") != null ) && (code != null) && (!code.equals(data.get("code").toString()))) {
				result = result && false;
				failReason = failReason + "code is expected "
						+ data.get("code").toString() + " but actually "
						+ jp.getString("code") + ".";
			}

			if ((data.get("msg") != null) && (msg != null) && (!msg.equals(data.get("msg").toString()))) {
				result = result && false;
				failReason = failReason + "msg is expected "
						+ data.get("msg").toString() + " but actually "
						+ jp.getString("msg") + ".";
			}
			
			if(data.get("custom") != null && jp.getString("data")!=null){
				String custom=data.get("custom").toString();
				String[] ArrayString=StringUtils.getArrayString(custom,",");
				if(!StringUtils.VerificationString(jp.getString("data"),ArrayString)){
					result = result && false;
					failReason = failReason + "custom is expected "
							+ data.get("custom").toString() + " but actually "
							+ jp.getString("data") + ".";
				}
			}
			
			if("接口响应成功！".equals(msg)){
				
				String user_id=jp.getString("data.userinfo.user_id");
				user_id = MapUtil.killQuotes(user_id, "\"");
				
				String dataPhone=jp.getString("data.userinfo.phone");
				dataPhone = MapUtil.killQuotes(dataPhone, "\"");
				
				String dataSystem=jp.getString("data.userinfo.system");
				dataSystem = MapUtil.killQuotes(dataSystem, "\"");
				
				String dataPlatform=jp.getString("data.userinfo.platform");
				dataPlatform = MapUtil.killQuotes(dataPlatform, "\"");
				
				String dataVersion=jp.getString("data.userinfo.version");
				dataVersion = MapUtil.killQuotes(dataVersion, "\"");
				
				String token=jp.getString("data.token").trim();
				tk_token = MapUtil.killQuotes(token, "\"");//保存token
				user_idList.add(user_id);//保存user_id
				
				//是否验证数据库
				if (!isProduct) {
					
					try {
						ResultSet rs_bankcard = this.selectFromDB(
								" t_user u ",
								" u.user_id = '" + user_id + "' ");
						rs_bankcard.last();
						
						if(rs_bankcard.getRow()>=1){
							phone = MapUtil.killQuotes(phone, "\"");
							phoneNeb=phone;
							
							
							parameter = MapUtil.getValue("parameter", data);
							system = MapUtil.getParameter(parameter, "system");
							system = MapUtil.killQuotes(system, "\"");
							platform = MapUtil.getParameter(parameter, "platform");
							platform = MapUtil.killQuotes(platform, "\"");
							version = MapUtil.getParameter(parameter, "version");
							version = MapUtil.killQuotes(version, "\"");
							device_id = MapUtil.getParameter(parameter, "device_id");
							device_id = MapUtil.killQuotes(device_id, "\"");
							passwd = MapUtil.getParameter(parameter, "passwd");
							passwd = MapUtil.killQuotes(passwd, "\"");
							
							String act_phone=rs_bankcard.getString("phone").equals("null ")?"null":rs_bankcard.getString("phone");
							String act_system=rs_bankcard.getString("system").equals("null ")?"null":rs_bankcard.getString("system");
							String act_platform=rs_bankcard.getString("platform").equals("null ")?"null":rs_bankcard.getString("platform");
							String act_version=rs_bankcard.getString("version").equals("null ")?"null":rs_bankcard.getString("version");
							String act_device_id=rs_bankcard.getString("device_id").equals("null ")?"null":rs_bankcard.getString("device_id");
							String act_passwd=rs_bankcard.getString("passwd").equals("null ")?"null":rs_bankcard.getString("passwd");
							
							
							
							if(!(dataPhone.equals(act_phone) || !(dataPhone.equals(phone)))){
									result = result && false;
									failReason = failReason + "t_user info phone is not in DB;";
							}
							
							if(!(dataSystem.equals(act_system) || !(dataSystem.equals(system)))){
								result = result && false;
								failReason = failReason + "t_user info system is not in DB;";
							}
							if(!(dataPlatform.equals(act_platform) || !(dataPlatform.equals(platform)))){
								result = result && false;
								failReason = failReason + "t_user info platform is not in DB;";
							}
							if(!(dataVersion.equals(act_version) || !(dataVersion.equals(version)))){
								result = result && false;
								failReason = failReason + "t_user info  version is not in DB;";
							}
							if(!(act_device_id.equals(device_id))){
								result = result && false;
								failReason = failReason + "t_user info device_id is not in DB;";
							}
							if(!(act_passwd.equals(passwd))){
								result = result && false;
								failReason = failReason + "t_user info  passwd is not in DB;";
							}
							
						}
						
					} catch (Exception e) {
						result = result && false;
						failReason = failReason + "cannot verify t_user info in DB;";
						e.printStackTrace();
					}
				}
			}
			
			
		}
		if (result)
			return "Pass";
		else
			return "Fail:" + failReason;
	}

}
