package com.offcn.api.tk.app;

import io.restassured.path.json.JsonPath;
import io.restassured.response.Response;

import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Random;

import org.json.simple.JSONArray;

import com.offcn.TestUnti.Log;
import com.offcn.TestUnti.MapUtil;
import com.offcn.TestUnti.MySqlUtil;
import com.offcn.TestUnti.RequestDataUtils;
import com.offcn.TestUnti.StringUtils;
import com.offcn.TestUnti.VerificationMethod;
import com.offcn.interfaces.API;
import com.offcn.process.TK;
import com.offcn.TestUnti.ListUtil;

import net.sf.json.JSONObject;



/**
 * .获取首页轮播图
 * 
 * @author puhui
 *
 */
public class getRecommend extends TK implements API {
	public String parameter;//参数集合
	
	public String version;//版本号
	public String platform;//平台
	public String exam_type;//公职类型
	public String exam_id;//考试分类
	public String item_id;//考试具体分类

	@Override
	public void initialize(HashMap<String, Object> data) {
	}

	@Override
	public HashMap<String, Object> handleInput(HashMap<String, Object> data) {
		return data;
	}

	@Override
	public Response SendRequest(HashMap<String, Object> data, String Url,
			String Request) {
		Response re = RequestDataUtils.Post_token(data, Url,tk_token);
		return re;
	}

	@Override
	public String handleOutput(Response re, HashMap<String, Object> data) {
		JsonPath jp = re.body().jsonPath();
		boolean result = true;
		String failReason = "";

		String json = re.asString();

		if ((data.get("statusCode") != null)
				&& (!data.get("statusCode").toString()
						.equals(String.valueOf(re.getStatusCode())))) {
			result = result && false;
			failReason = failReason + "statusCode is expected "
					+ data.get("statusCode").toString() + " but actually "
					+ String.valueOf(re.getStatusCode()) + ". ";
		}

		if (json.length() != 0) {
			
			String msg=StringUtils.decodeUnicode(getMsg(re));
			String code=getCode(re);
			
			if ((data.get("code") != null ) && (code != null) && (!code.equals(data.get("code").toString()))) {
				result = result && false;
				failReason = failReason + "code is expected "
						+ data.get("code").toString() + " but actually "
						+ jp.getString("code") + ".";
			}

			if ((data.get("msg") != null) && (msg != null) && (!msg.equals(data.get("msg").toString()))) {
				result = result && false;
				failReason = failReason + "msg is expected "
						+ data.get("msg").toString() + " but actually "
						+ jp.getString("msg") + ".";
			}
			
			if(data.get("custom") != null && jp.getString("data")!=null){
				String custom=data.get("custom").toString();
				String[] ArrayString=StringUtils.getArrayString(custom,",");
				if(!StringUtils.VerificationString(jp.getString("data"),ArrayString)){
					result = result && false;
					failReason = failReason + "custom is expected "
							+ data.get("custom").toString() + " but actually "
							+ jp.getString("data") + ".";
				}
			}
			
			if("".equals(msg)){
				
				//是否验证数据库
				if (!isProduct) {
					
				}
			}
			
		}
		if (result)
			return "Pass";
		else
			return "Fail:" + failReason;
	}

}
