package com.offcn.api.tk.app;

import io.restassured.path.json.JsonPath;
import io.restassured.response.Response;

import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Random;

import org.json.simple.JSONArray;

import com.offcn.TestUnti.Log;
import com.offcn.TestUnti.MapUtil;
import com.offcn.TestUnti.MySqlUtil;
import com.offcn.TestUnti.RequestDataUtils;
import com.offcn.TestUnti.StringUtils;
import com.offcn.TestUnti.VerificationMethod;
import com.offcn.interfaces.API;
import com.offcn.process.TK;
import com.offcn.TestUnti.ListUtil;

import net.sf.json.JSONObject;



/**
 * 47:练习册试题获取接口
 * 
 * @author puhui
 *
 */
public class getPracticequestion extends TK implements API {
	public String parameter;//参数集合
	
	public String user_id;//用户id
	public String item_id;//考试项目id
	public String record_id;//练习册类别id
	public String cate_id;//练习册类别里面的小类别
	public String submit_time;//

	@Override
	public void initialize(HashMap<String, Object> data) {
		if (!isProduct && data.get("CleanDB").toString().contains("Y")) {
			cleanUser_FromDB();//清除注册用户根据user_id
		}
	}

	@Override
	public HashMap<String, Object> handleInput(HashMap<String, Object> data) {
		// 获取parameter对应的内容
		parameter = MapUtil.getValue("parameter", data);
		user_id = MapUtil.getParameter(parameter, "user_id").trim();
		item_id = MapUtil.getParameter(parameter, "item_id").trim();
		record_id = MapUtil.getParameter(parameter, "record_id").trim();
		cate_id = MapUtil.getParameter(parameter, "cate_id").trim();
		submit_time = MapUtil.getParameter(parameter, "submit_time").trim();
		
		if ((!user_id.equals("")) && user_id.equals("code")) {
			user_id=ListUtil.getListValue(user_idList,0);
			parameter = parameter.replace("\"user_id\":code", "\"user_id\":\""+ user_id + "\"");
		}
		if ((!item_id.equals("")) && item_id.equals("code")) {
			item_id="88";
			parameter = parameter.replace("\"item_id\":code", "\"item_id\":\""+ item_id + "\"");
		}
		if ((!record_id.equals("")) && record_id.equals("code")) {
			record_id=record_id_L;
			parameter = parameter.replace("\"record_id\":code", "\"record_id\":\""+ record_id + "\"");
		}
		if ((!cate_id.equals("")) && cate_id.equals("code")) {
			cate_id=cate_id_L;
			parameter = parameter.replace("\"cate_id\":code", "\"cate_id\":\""+ cate_id + "\"");
		}
		if ((!submit_time.equals("")) && submit_time.equals("code")) {
			submit_time=cate_id_L;
			parameter = parameter.replace("\"submit_time\":code", "\"submit_time\":\""+ submit_time + "\"");
		}
		data.put("parameter", parameter);
		return data;
	}

	@Override
	public Response SendRequest(HashMap<String, Object> data, String Url,
			String Request) {
		Response re = RequestDataUtils.Post_token(data, Url, tk_token);
		return re;
	}

	@Override
	public String handleOutput(Response re, HashMap<String, Object> data) {
		JsonPath jp = re.body().jsonPath();
		boolean result = true;
		String failReason = "";

		String json = StringUtils.decodeUnicode(re.asString());

		if ((data.get("statusCode") != null)
				&& (!data.get("statusCode").toString()
						.equals(String.valueOf(re.getStatusCode())))) {
			result = result && false;
			failReason = failReason + "statusCode is expected "
					+ data.get("statusCode").toString() + " but actually "
					+ String.valueOf(re.getStatusCode()) + ". ";
		}

		if (json.length() != 0) {
			
			String msg=jp.getString("message");
			String code=jp.getString("retcode");
			
			
			if ((data.get("code") != null ) && (code != null) && (!code.equals(data.get("code").toString()))) {
				result = result && false;
				failReason = failReason + "code is expected "
						+ data.get("code").toString() + " but actually "
						+ jp.getString("code") + ".";
			}

			if ((data.get("msg") != null) && (msg != null) && (!msg.equals(data.get("msg").toString()))) {
				result = result && false;
				failReason = failReason + "msg is expected "
						+ data.get("msg").toString() + " but actually "
						+ jp.getString("msg") + ".";
			}
			
			if(data.get("custom") != null && json!=null){
				//如果自定义结果包含多个希望结果，也就是有逗号，那么就切割，包含比较。
				if(data.get("custom").toString().contains(",")){
					String [] strCustomStrings=data.get("custom").toString().split(",");
					for(int i=0;i<strCustomStrings.length;i++){
						if(!json.contains(strCustomStrings[i])){
							result = result && false;
							failReason = failReason + "custom is expected "
									+ data.get("custom").toString() + " but actually "
									+ strCustomStrings[i] + ".";
							break;
						}
					}
				}else{//如果只有一个希望结果，就直接包含比较。
					if(!json.contains(data.get("custom").toString())){
						result = result && false;
						failReason = failReason + "custom is expected "
								+ data.get("custom").toString() + " but actually "
								+ data.get("custom").toString() + ".";
					}
				}
			}
			
			if("练习册试题获取成功".equals(msg)){
				record_id = MapUtil.killQuotes(record_id, "\"");
				record_id_L=jp.getString("data.record_id");
//				String msg1=jp.getString("message");
				List<Object> examList=jp.getList("data.list");
				List<String> list=new ArrayList<String>();
				for(int i=0;i<examList.size();i++){
					list.add(jp.getString("data.list["+i+"].question_id"));
				}
//				System.out.println(list.toString());
				question_id_list=list.toString().substring(1,list.toString().length()-1).replace(" ", "");
				
				System.out.println(re.body().asString());
				
				question_id_L=jp.getString("data.list[0].question_id");
				question_number_L=jp.getString("data.list[0].question_number");
				is_hf_L=jp.getString("data.list[0].is_hf");
				type_L=jp.getString("data.list[0].type");
			}
		}
		if (result)
			return "Pass";
		else
			return "Fail:" + failReason;
	}

}
