package com.offcn.api.tk.app;

import io.restassured.path.json.JsonPath;
import io.restassured.response.Response;

import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Random;

import org.json.simple.JSONArray;

import com.offcn.TestUnti.Log;
import com.offcn.TestUnti.MapUtil;
import com.offcn.TestUnti.MySqlUtil;
import com.offcn.TestUnti.RequestDataUtils;
import com.offcn.TestUnti.StringUtils;
import com.offcn.TestUnti.VerificationMethod;
import com.offcn.interfaces.API;
import com.offcn.process.TK;
import com.offcn.TestUnti.ListUtil;

import net.sf.json.JSONObject;



/**
 * 23.App精编练习册获取分类接口
 * 
 * @author puhui
 *
 */
public class getPracticeCategory extends TK implements API {
	public String parameter;//参数集合
	
//	public String user_id;//用户id
//	public String phone;//手机

	@Override
	public void initialize(HashMap<String, Object> data) {
		if (!isProduct && data.get("CleanDB").toString().contains("Y")) {
			cleanUser_FromDB();//清除注册用户根据user_id
		}
	}

	@Override
	public HashMap<String, Object> handleInput(HashMap<String, Object> data) {
		return data;
	}

	@Override
	public Response SendRequest(HashMap<String, Object> data, String Url,
			String Request) {
		Response re = RequestDataUtils.Post_token(data, Url, tk_token);
		return re;
	}

	@Override
	public String handleOutput(Response re, HashMap<String, Object> data) {
		JsonPath jp = re.body().jsonPath();
		boolean result = true;
		String failReason = "";

		String json = re.asString();

		if ((data.get("statusCode") != null)
				&& (!data.get("statusCode").toString()
						.equals(String.valueOf(re.getStatusCode())))) {
			result = result && false;
			failReason = failReason + "statusCode is expected "
					+ data.get("statusCode").toString() + " but actually "
					+ String.valueOf(re.getStatusCode()) + ". ";
		}

		if (json.length() != 0) {
			
			String msg=jp.getString("message");
			String code=jp.getString("retcode");
			
			
			if ((data.get("code") != null ) && (code != null) && (!code.equals(data.get("code").toString()))) {
				result = result && false;
				failReason = failReason + "code is expected "
						+ data.get("code").toString() + " but actually "
						+ jp.getString("code") + ".";
			}

			if ((data.get("msg") != null) && (msg != null) && (!msg.equals(data.get("msg").toString()))) {
				result = result && false;
				failReason = failReason + "msg is expected "
						+ data.get("msg").toString() + " but actually "
						+ jp.getString("msg") + ".";
			}
			
			if(data.get("custom") != null && jp.getString("data")!=null){
				String custom=data.get("custom").toString();
				String[] ArrayString=StringUtils.getArrayString(custom,",");
				if(!StringUtils.VerificationString(jp.getString("data"),ArrayString)){
					result = result && false;
					failReason = failReason + "custom is expected "
							+ data.get("custom").toString() + " but actually "
							+ jp.getString("data") + ".";
				}
			}
			
			if("接口响应成功！".equals(msg)){
			
				List<Object> examList=jp.getList("data");
				
				//是否验证数据库
				if (!isProduct) {
					
					try {
						String sql="select * from t_exam_subtype; ";
						
						ResultSet rs_bankcard = this.sqlFromDB(sql);
						
						while(rs_bankcard.next()){
							String subtype_id = rs_bankcard.getString(1);
					        String desc = rs_bankcard.getString(4);
					        String tiny_title = rs_bankcard.getString(5);
					        System.out.println("id:"+desc+" 姓名："+subtype_id+" 性别："+tiny_title);
					        //{tiny_title=言语, subtype_id=1, desc=言语理解}
					        String su="{tiny_title="+tiny_title+", subtype_id="+subtype_id+", desc="+desc+"}";
					        if(!examList.toString().contains(su)){
					        	result = result && false;
								failReason = failReason + su + " is not in DB;";
					        }
					    }
						
					} catch (Exception e) {
						result = result && false;
						failReason = failReason + "cannot verify t_exam_subtype info in DB;";
						e.printStackTrace();
					}
				}
			}
		}
		if (result)
			return "Pass";
		else
			return "Fail:" + failReason;
	}

}
