package com.offcn.api.tk.app;

import io.restassured.path.json.JsonPath;
import io.restassured.response.Response;

import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Random;

import org.json.simple.JSONArray;

import com.offcn.TestUnti.Log;
import com.offcn.TestUnti.MapUtil;
import com.offcn.TestUnti.MySqlUtil;
import com.offcn.TestUnti.RequestDataUtils;
import com.offcn.TestUnti.StringUtils;
import com.offcn.TestUnti.VerificationMethod;
import com.offcn.interfaces.API;
import com.offcn.process.TK;
import com.offcn.TestUnti.ListUtil;

import net.sf.json.JSONObject;



/**
 * 108.APP获取考试下试卷tab下试卷列表接口
 * 
 * @author puhui
 *
 */
public class getExamNavPaperList extends TK implements API {
	public String parameter;//参数集合
	
	public String user_id;//用户id
	public String exam_id;//考试项目id
	public String tab_id;//练习册类别id

	@Override
	public void initialize(HashMap<String, Object> data) {
		if (!isProduct && data.get("CleanDB").toString().contains("Y")) {
			cleanUser_FromDB();//清除注册用户根据user_id
		}
	}

	@Override
	public HashMap<String, Object> handleInput(HashMap<String, Object> data) {
		// 获取parameter对应的内容
		parameter = MapUtil.getValue("parameter", data);
		user_id = MapUtil.getParameter(parameter, "user_id").trim();
		exam_id = MapUtil.getParameter(parameter, "exam_id").trim();
		tab_id = MapUtil.getParameter(parameter, "tab_id").trim();
		
		if ((!user_id.equals("")) && user_id.equals("code")) {
			user_id=ListUtil.getListValue(user_idList,0);
			parameter = parameter.replace("\"user_id\":code", "\"user_id\":\""+ user_id + "\"");
		}
		if ((!exam_id.equals("")) && exam_id.equals("code")) {
			exam_id="88";
			parameter = parameter.replace("\"exam_id\":code", "\"exam_id\":\""+ exam_id + "\"");
		}
		if ((!tab_id.equals("")) && tab_id.equals("code")) {
			tab_id="1";
			parameter = parameter.replace("\"tab_id\":code", "\"tab_id\":\""+ tab_id + "\"");
		}
		data.put("parameter", parameter);
		return data;
	}

	@Override
	public Response SendRequest(HashMap<String, Object> data, String Url,
			String Request) {
		parameter = MapUtil.getValue("parameter", data);
		String sign = MapUtil.getParameter(parameter, "sign").trim();
		exam_id = MapUtil.killQuotes(exam_id, "\"");//去掉双引号的education
		user_id = MapUtil.killQuotes(user_id, "\"");//去掉双引号的education
		tab_id = MapUtil.killQuotes(tab_id, "\"");//去掉双引号的education
		
		Map<String,String> m=new HashMap<String,String>();
		m.put("exam_id", exam_id);
		m.put("user_id", user_id);
		m.put("tab_id", tab_id);
		m.put("appid","tiku");
		m.put("sign", sign);
		
		Response re = RequestDataUtils.post_form_data(data,tk_token, Url,m);
//		Response re = RequestDataUtils.Post_token(data, Url, tk_token);
		return re;
	}

	@Override
	public String handleOutput(Response re, HashMap<String, Object> data) {
		JsonPath jp = re.body().jsonPath();
		boolean result = true;
		String failReason = "";

		String json = StringUtils.decodeUnicode(re.asString());

		if ((data.get("statusCode") != null)
				&& (!data.get("statusCode").toString()
						.equals(String.valueOf(re.getStatusCode())))) {
			result = result && false;
			failReason = failReason + "statusCode is expected "
					+ data.get("statusCode").toString() + " but actually "
					+ String.valueOf(re.getStatusCode()) + ". ";
		}

		if (json.length() != 0) {
			
			String msg=jp.getString("message");
			String code=jp.getString("retcode");
			
			
			if ((data.get("code") != null ) && (code != null) && (!code.equals(data.get("code").toString()))) {
				result = result && false;
				failReason = failReason + "code is expected "
						+ data.get("code").toString() + " but actually "
						+ jp.getString("code") + ".";
			}

			if ((data.get("msg") != null) && (msg != null) && (!msg.equals(data.get("msg").toString()))) {
				result = result && false;
				failReason = failReason + "msg is expected "
						+ data.get("msg").toString() + " but actually "
						+ jp.getString("msg") + ".";
			}
			
			if(data.get("custom") != null && json!=null){
				//如果自定义结果包含多个希望结果，也就是有逗号，那么就切割，包含比较。
				if(data.get("custom").toString().contains(",")){
					String [] strCustomStrings=data.get("custom").toString().split(",");
					for(int i=0;i<strCustomStrings.length;i++){
						if(!json.contains(strCustomStrings[i])){
							result = result && false;
							failReason = failReason + "custom is expected "
									+ data.get("custom").toString() + " but actually "
									+ strCustomStrings[i] + ".";
							break;
						}
					}
				}else{//如果只有一个希望结果，就直接包含比较。
					if(!json.contains(data.get("custom").toString())){
						result = result && false;
						failReason = failReason + "custom is expected "
								+ data.get("custom").toString() + " but actually "
								+ data.get("custom").toString() + ".";
					}
				}
			}
			
			if("接口响应成功！".equals(msg)){
			
			}
		}
		if (result)
			return "Pass";
		else
			return "Fail:" + failReason;
	}

}
