package com.offcn.api.tk.app;

import io.restassured.path.json.JsonPath;
import io.restassured.response.Response;

import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Random;

import org.json.simple.JSONArray;

import com.offcn.TestUnti.Log;
import com.offcn.TestUnti.MapUtil;
import com.offcn.TestUnti.MyDateUtil;
import com.offcn.TestUnti.MySqlUtil;
import com.offcn.TestUnti.RequestDataUtils;
import com.offcn.TestUnti.StringUtils;
import com.offcn.TestUnti.VerificationMethod;
import com.offcn.interfaces.API;
import com.offcn.process.BasicsGM;
import com.offcn.process.TK;
import com.offcn.TestUnti.ListUtil;

import net.sf.json.JSONObject;



/**
 * 110.申论真题获取试卷模块信息的接口
 * 
 * 返回 recordId
 *
 */
public class getEstimatePaperBlocks extends TK implements API {
	public String parameter;//参数集合
	
	public String user_id;//用户id
	public String examine_id;//考试项目id
	public String examine_paper_id;//练习册类别id
	public String item_id;//练习册类别id

	@Override
	public void initialize(HashMap<String, Object> data) {
		if (!isProduct && data.get("CleanDB").toString().contains("Y")) {
			cleanUser_FromDB();//清除注册用户根据user_id
		}
		
	}

	@Override
	public HashMap<String, Object> handleInput(HashMap<String, Object> data) {
		// 获取parameter对应的内容
		parameter = MapUtil.getValue("parameter", data);
		user_id = MapUtil.getParameter(parameter, "user_id").trim();
		item_id = MapUtil.getParameter(parameter, "item_id").trim();
		examine_id = MapUtil.getParameter(parameter, "examine_id").trim();
		examine_paper_id = MapUtil.getParameter(parameter, "examine_paper_id").trim();
		
		
		
		if ((!user_id.equals("")) && user_id.equals("code")) {
			user_id=ListUtil.getListValue(user_idList,0);
			parameter = parameter.replace("\"user_id\":code", "\"user_id\":\""+ user_id + "\"");
		}
		if ((!item_id.equals("")) && item_id.equals("code")) {
			item_id="88";
			parameter = parameter.replace("\"item_id\":code", "\"item_id\":\""+ item_id + "\"");
		}
		if ((!examine_id.equals("")) && examine_id.equals("code")) {
			examine_id=3+"";//查询t_examine表，examine_id列主键
			parameter = parameter.replace("\"examine_id\":code", "\"examine_id\":\""+ examine_id + "\"");
		}
		if ((!examine_paper_id.equals("")) && examine_paper_id.equals("code")) {
			examine_paper_id=3+"";//查询examine_paper表，examine_paper_id列，并且examine_id列存在
			parameter = parameter.replace("\"examine_paper_id\":code", "\"examine_paper_id\":\""+ examine_paper_id + "\"");
		}
		
		// 获取Description对应的内容
		String Description = MapUtil.getValue("Description", data);
		if(Description.contains("正向")){
			BasicsGM.updateOrderStatus("t_examine","end="+MyDateUtil.getTime_php(2,0,0), "examine_id="+examine_id);
		}
		
		data.put("parameter", parameter);
		return data;
	}

	@Override
	public Response SendRequest(HashMap<String, Object> data, String Url,
			String Request) {
		Response re = RequestDataUtils.Post_token(data, Url, tk_token);
		return re;
	}

	@Override
	public String handleOutput(Response re, HashMap<String, Object> data) {
		JsonPath jp = re.body().jsonPath();
		boolean result = true;
		String failReason = "";

		String json = StringUtils.decodeUnicode(re.asString());

		if ((data.get("statusCode") != null)
				&& (!data.get("statusCode").toString()
						.equals(String.valueOf(re.getStatusCode())))) {
			result = result && false;
			failReason = failReason + "statusCode is expected "
					+ data.get("statusCode").toString() + " but actually "
					+ String.valueOf(re.getStatusCode()) + ". ";
		}

		if (json.length() != 0) {
			
			String msg=jp.getString("message");
			String code=jp.getString("retcode");
			
			
			if ((data.get("code") != null ) && (code != null) && (!code.equals(data.get("code").toString()))) {
				result = result && false;
				failReason = failReason + "code is expected "
						+ data.get("code").toString() + " but actually "
						+ jp.getString("code") + ".";
			}

			if ((data.get("msg") != null) && (msg != null) && (!msg.equals(data.get("msg").toString()))) {
				result = result && false;
				failReason = failReason + "msg is expected "
						+ data.get("msg").toString() + " but actually "
						+ jp.getString("msg") + ".";
			}
			
			if(data.get("custom") != null && json!=null){
				//如果自定义结果包含多个希望结果，也就是有逗号，那么就切割，包含比较。
				if(data.get("custom").toString().contains(",")){
					String [] strCustomStrings=data.get("custom").toString().split(",");
					for(int i=0;i<strCustomStrings.length;i++){
						if(!json.contains(strCustomStrings[i])){
							result = result && false;
							failReason = failReason + "custom is expected "
									+ data.get("custom").toString() + " but actually "
									+ strCustomStrings[i] + ".";
							break;
						}
					}
				}else{//如果只有一个希望结果，就直接包含比较。
					if(!json.contains(data.get("custom").toString())){
						result = result && false;
						failReason = failReason + "custom is expected "
								+ data.get("custom").toString() + " but actually "
								+ data.get("custom").toString() + ".";
					}
				}
			}
			
			if("试卷信息查询成功".equals(msg)){
				record_id_L=jp.getString("data.recordId");
				
				examine_paper_id = MapUtil.killQuotes(examine_paper_id, "\"");//去掉双引号的parameter
				examine_id = MapUtil.killQuotes(examine_id, "\"");//去掉双引号的parameter
				try {
					String sql="SELECT * FROM t_examine_paper WHERE examine_paper_id = '"+examine_paper_id+"'";
					
					ResultSet rs_bankcard = this.sqlFromDB(sql);
					rs_bankcard.last();
					if (rs_bankcard.getRow() < 1) {
						result = result && false;
						failReason = failReason + "t_examine_paper info is not in DB;";
					}else{
						paper_id_L = rs_bankcard.getString("paper_id");
						examine_paper_id_L=examine_paper_id;
						examine_id_L=examine_id;
					}
				} catch (Exception e) {
					result = result && false;
					failReason = failReason + "cannot verify t_examine_paper info in DB;";
					e.printStackTrace();
				}
			}
		}
		if (result)
			return "Pass";
		else
			return "Fail:" + failReason;
	}

}
