package com.offcn.api.tk.app;

import io.restassured.path.json.JsonPath;
import io.restassured.response.Response;

import java.sql.ResultSet;
import java.util.HashMap;

import com.offcn.TestUnti.ListUtil;
import com.offcn.TestUnti.MapUtil;
import com.offcn.TestUnti.RequestDataUtils;
import com.offcn.TestUnti.StringUtils;
import com.offcn.interfaces.API;
import com.offcn.process.TK;

/**
 * 
 * @author wufeifei
 * 修改用户名称
 *
 */
public class editUserName extends TK implements API {
	
	public String parameter;//参数集合
	public String user_id;//用户id
	public String nickname;//用户名
	
	
	@Override
	public void initialize(HashMap<String, Object> data) {
		// TODO Auto-generated method stub
	}

	@Override
	public HashMap<String, Object> handleInput(HashMap<String, Object> data) {
		// TODO Auto-generated method stub
		// 获取parameter对应的内容
		parameter = MapUtil.getValue("parameter", data);
		user_id = MapUtil.getParameter(parameter, "user_id").trim();
		nickname = MapUtil.getParameter(parameter, "nickname").trim();
		nickname = MapUtil.killQuotes(nickname, "\"");
		
		if ((!user_id.equals("")) && user_id.equals("code")) {
			user_id = ListUtil.getListValue(user_idList,0);
			parameter = parameter.replace("\"user_id\":code", "\"user_id\":\""+ user_id + "\"");
		}
		
		data.put("parameter", parameter);
		return data;
	}

	@Override
	public Response SendRequest(HashMap<String, Object> data, String Url,
			String Request) {
		// TODO Auto-generated method stub
		Response re = RequestDataUtils.Post_token(data, Url, tk_token);
//		System.out.println(re.asString());
		return re;
	}

	@Override
	public String handleOutput(Response re, HashMap<String, Object> data) {
		// TODO Auto-generated method stub
		
		JsonPath jp = re.body().jsonPath();
		boolean result = true;
		String failReason = "";

		String json = re.asString();

		if ((data.get("statusCode") != null)
				&& (!data.get("statusCode").toString()
						.equals(String.valueOf(re.getStatusCode())))) {
			result = result && false;
			failReason = failReason + "statusCode is expected "
					+ data.get("statusCode").toString() + " but actually "
					+ String.valueOf(re.getStatusCode()) + ". ";
		}

		if (json.length() != 0) {
			
			String msg=StringUtils.decodeUnicode(getMsg(re));
			String code=getCode(re);
			
			if ((data.get("code") != null ) && (code != null) && (!code.equals(data.get("code").toString()))) {
				result = result && false;
				failReason = failReason + "code is expected "
						+ data.get("code").toString() + " but actually "
						+ jp.getString("code") + ".";
			}

			if ((data.get("msg") != null) && (msg != null) && (!msg.equals(data.get("msg").toString()))) {
				result = result && false;
				failReason = failReason + "msg is expected "
						+ data.get("msg").toString() + " but actually "
						+ jp.getString("msg") + ".";
			}
			
			if(data.get("custom") != null && jp.getString("data")!=null){
				String custom=data.get("custom").toString();
				String[] ArrayString=StringUtils.getArrayString(custom,",");
				if(!StringUtils.VerificationString(jp.getString("data"),ArrayString)){
					result = result && false;
					failReason = failReason + "custom is expected "
							+ data.get("custom").toString() + " but actually "
							+ jp.getString("data") + ".";
				}
			}
			
			if("接口响应成功！".equals(msg)){
				
				//是否验证数据库
				if(!isProduct){
					try {
						
						String sql="SELECT nickname FROM t_user where user_id ='"+user_id+"'";
						
						ResultSet rs_bankcard = this.sqlFromDB(sql);
						rs_bankcard.last();
						
						if(rs_bankcard.getRow()>=1){
							
							
							String act_nickname=rs_bankcard.getString("nickname").equals("null ")?"null":rs_bankcard.getString("nickname");
							String date_nicknameString = jp.getString("data.nickname");
							
							
							if(!(date_nicknameString.equals(act_nickname) && date_nicknameString.equals(nickname))){
									result = result && false;
									failReason = failReason + "nickname is not in DB;";
							}
							
						}
						
					} catch (Exception e) {
						result = result && false;
						failReason = failReason + "cannot verify t_user info in DB;";
						e.printStackTrace();
					}
				}
			}
		}
		if (result)
			return "Pass";
		else
			return "Fail:" + failReason;
	}

}
	
	
