package com.offcn.api.nwn.process;

import io.restassured.path.json.JsonPath;
import io.restassured.response.Response;

import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;

import org.json.simple.JSONArray;

import com.offcn.TestUnti.Log;
import com.offcn.TestUnti.MapUtil;
import com.offcn.TestUnti.RequestDataUtils;
import com.offcn.TestUnti.StringUtils;
import com.offcn.interfaces.API;
import com.offcn.process.NWN;
import com.offcn.process.TK;
import com.offcn.TestUnti.ListUtil;

import net.sf.json.JSONObject;



/**
 * nwn后台登录接口
 * 
 * @author puhui
 *
 */
public class login extends NWN implements API {
	public String parameter;//参数集合
	
	public String user_name;//登录用户名
	public String password;//密码

	@Override
	public void initialize(HashMap<String, Object> data) {
	}

	@Override
	public HashMap<String, Object> handleInput(HashMap<String, Object> data) {
		return data;
	}

	@Override
	public Response SendRequest(HashMap<String, Object> data, String Url,
			String Request) {
		parameter = MapUtil.getValue("parameter", data);
		user_name = MapUtil.getParameter(parameter, "user_name").trim();
		user_name = MapUtil.killQuotes(user_name, "\"");
		
		password = MapUtil.getParameter(parameter, "password").trim();
		password = MapUtil.killQuotes(password, "\"");
		
		
		Map<String,String> m=new HashMap<String,String>();
		m.put("user_name", user_name);
		m.put("password", password);
		m.put("code", nwn_sign);
		
		Response re = RequestDataUtils.post_form_data(data,"", Url+".html?action=login",m);
		return re;
	}

	@Override
	public String handleOutput(Response re, HashMap<String, Object> data) {
		JsonPath jp = re.body().jsonPath();
		boolean result = true;
		String failReason = "";

		String json = re.asString();

		if ((data.get("statusCode") != null)
				&& (!data.get("statusCode").toString()
						.equals(String.valueOf(re.getStatusCode())))) {
			result = result && false;
			failReason = failReason + "statusCode is expected "
					+ data.get("statusCode").toString() + " but actually "
					+ String.valueOf(re.getStatusCode()) + ". ";
		}

		if (json.length() != 0) {
			
			String msg=StringUtils.decodeUnicode(getMsg(re));
			String code=getCode(re);
			
			if ((data.get("code") != null ) && (code != null) && (!code.equals(data.get("code").toString()))) {
				result = result && false;
				failReason = failReason + "code is expected "
						+ data.get("code").toString() + " but actually "
						+ jp.getString("code") + ".";
			}

			if ((data.get("msg") != null) && (msg != null) && (!msg.equals(data.get("msg").toString()))) {
				result = result && false;
				failReason = failReason + "msg is expected "
						+ data.get("msg").toString() + " but actually "
						+ jp.getString("msg") + ".";
			}
			
			String url=jp.getString("url");
			if(data.get("custom") != null && url!=null){
				if(!(json.contains(data.get("custom").toString()))){
					result = result && false;
					failReason = failReason + "custom is expected "
							+ data.get("custom").toString() + " but actually "
							+ url + ".";
				}
			}
			
			if("登录成功".equals(msg)){
				
				admin_login_ssid=re.getCookie("admin_login_ssid");
				
			}
			
			
		}
		if (result)
			return "Pass";
		else
			return "Fail:" + failReason;
	}

}
