package com.offcn.api.nwn;

import io.restassured.path.json.JsonPath;
import io.restassured.response.Response;

import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Random;

import org.json.simple.JSONArray;

import com.offcn.TestUnti.ListUtil;
import com.offcn.TestUnti.Log;
import com.offcn.TestUnti.MapUtil;
import com.offcn.TestUnti.ReadProperties;
import com.offcn.TestUnti.RequestDataUtils;
import com.offcn.TestUnti.StringUtils;
import com.offcn.interfaces.API;
import com.offcn.process.NWN;
import com.offcn.process.XYZB;

import net.sf.json.JSONObject;



/**
 *获取单个学习包简介详情
 * 
 * @author puhui
 *
 */
public class getPackageInfo extends NWN implements API {
	public String parameter;//参数集合
	
	public String package_id;//电话
	
	public String pack_name;//
	public String for_year;//
	public String product;//
	public String cover;//
	public String intro;//
	public String created_at;//
	
	
	
	
	@Override
	public void initialize(HashMap<String, Object> data) {
	}

	@Override
	public HashMap<String, Object> handleInput(HashMap<String, Object> data) {
		// 获取parameter对应的内容
		parameter = MapUtil.getValue("parameter", data);
		package_id = MapUtil.getParameter_get(parameter, "package_id").trim();
		
		if ((!package_id.equals("")) && package_id.equals("code")) {
			package_id=ListUtil.getListValue(n_package_idList, 0);
			parameter = parameter.replace("package_id=code", "package_id="+ package_id );
		}
		
		data.put("parameter", parameter);
		return data;
	}

	@Override
	public Response SendRequest(HashMap<String, Object> data, String Url,
			String Request) {
		
		Response re = RequestDataUtils.Get_token(data, Url, "");
		return re;
	}

	@Override
	public String handleOutput(Response re, HashMap<String, Object> data) {
//		System.out.println(re.asString());
//		System.out.println(StringUtils.decodeUnicode(re.asString()));
		
		JsonPath jp = re.body().jsonPath();
		boolean result = true;
		String failReason = "";

		String json = re.asString();

//		System.out.println(json);
		if ((data.get("statusCode") != null)
				&& (!data.get("statusCode").toString()
						.equals(String.valueOf(re.getStatusCode())))) {
			result = result && false;
			failReason = failReason + "statusCode is expected "
					+ data.get("statusCode").toString() + " but actually "
					+ String.valueOf(re.getStatusCode()) + ". ";
		}

		if (json.length() != 0) {
			
			String msg=jp.getString("message");
			String code=jp.getString("retcode");
			
			if ((data.get("code") != null ) && (code != null) && (!code.equals(data.get("code").toString()))) {
				result = result && false;
				failReason = failReason + "code is expected "
						+ data.get("code").toString() + " but actually "
						+ jp.getString("code") + ".";
			}

			if ((data.get("msg") != null) && (msg != null) && (!msg.equals(data.get("msg").toString()))) {
				result = result && false;
				failReason = failReason + "msg is expected "
						+ data.get("msg").toString() + " but actually "
						+ jp.getString("msg") + ".";
			}
			
			if(data.get("custom") != null && jp.getString("data")!=null){
				String custom=data.get("custom").toString();
				String[] ArrayString=StringUtils.getArrayString(custom,",");
//				System.out.println(jp.getString("custom"));
//				System.out.println(Arrays.toString(ArrayString));
				if(!StringUtils.VerificationString(jp.getString("data"),ArrayString)){
					result = result && false;
					failReason = failReason + "custom is expected "
							+ data.get("custom").toString() + " but actually "
							+ jp.getString("data") + ".";
				}
			}
			
			if("获取成功!".equals(msg)){
				parameter = MapUtil.getValue("parameter", data);
				package_id = MapUtil.getParameter(parameter, "package_id").trim();
				package_id = MapUtil.killQuotes(package_id, "\"");
//				
				//是否验证数据库
				if (!isProduct) {
					
					try {
						String sql="select * from n_package where id ='"+package_id+"'";
						
						ResultSet rs_bankcard = this.sqlFromDB(sql);
						rs_bankcard.last();
						
						if(rs_bankcard.getRow()>=1){
							
							String act_pack_name=rs_bankcard.getString("pack_name").equals("null ")?"null":rs_bankcard.getString("pack_name");
							String act_for_year=rs_bankcard.getString("for_year").equals("null ")?"null":rs_bankcard.getString("for_year");
							String act_product=rs_bankcard.getString("product").equals("null ")?"null":rs_bankcard.getString("product");
							String act_cover=rs_bankcard.getString("cover").equals("null ")?"null":rs_bankcard.getString("cover");
							String act_intro=rs_bankcard.getString("intro").equals("null ")?"null":rs_bankcard.getString("intro");
							String act_created_at=rs_bankcard.getString("created_at").equals("null ")?"null":rs_bankcard.getString("created_at");
							
							pack_name=jp.getString("data.pack_name");
							pack_name = MapUtil.killQuotes(pack_name, "\"");
							pack_name=pack_name.equals("null ")?"null":pack_name;
							
							for_year=jp.getString("data.for_year");
							for_year = MapUtil.killQuotes(for_year, "\"");
							for_year=for_year.equals("null ")?"null":for_year;
							
							product=jp.getString("data.product");
							product = MapUtil.killQuotes(product, "\"");
							product=product.equals("null ")?"null":product;
							
							cover=jp.getString("data.cover");
							cover = MapUtil.killQuotes(cover, "\"");
							cover=cover.equals("null ")?"null":cover;
							
							intro=jp.getString("data.intro");
							intro = MapUtil.killQuotes(intro, "\"");
							intro=intro.equals("null ")?"null":intro;
							
							created_at=jp.getString("data.created_at");
							created_at = MapUtil.killQuotes(created_at, "\"");
							created_at=created_at.equals("null ")?"null":created_at;
							
							if(pack_name.length()<60){
								if(!(pack_name.equals(act_pack_name))){
									result = result && false;
									failReason = failReason + "n_package info pack_name is not in DB;";
								}
							}
							
							if(for_year.length()<60){
								if(!(for_year.equals(act_for_year))){
									result = result && false;
									failReason = failReason + "n_package info for_year is not in DB;";
								}
							}
							
							if(product.length()<60){
								if(!(product.equals(act_product))){
									result = result && false;
									failReason = failReason + "n_package info product is not in DB;";
								}
							}
							
							if(cover.length()<60){
								if(!(cover.equals(act_cover))){
									result = result && false;
									failReason = failReason + "n_package info cover is not in DB;";
								}
							}
							
							if(intro.length()<60){
								if(!(intro.equals(act_intro))){
									result = result && false;
									failReason = failReason + "n_package info intro is not in DB;";
								}
							}
							
							if(created_at.length()<60){
								if(!(created_at.equals(act_created_at))){
									result = result && false;
									failReason = failReason + "n_package info created_at is not in DB;";
								}
							}
						}
						
					} catch (Exception e) {
						result = result && false;
						failReason = failReason + "cannot verify n_package info in DB;";
						e.printStackTrace();
					}
				}
			}
			
			
		}
		
		if (result)
			return "Pass";
		else
			return "Fail:" + failReason;
	}

}
