package com.offcn.api.nwn;

import io.restassured.path.json.JsonPath;
import io.restassured.response.Response;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Random;

import org.json.simple.JSONArray;

import com.offcn.TestUnti.ListUtil;
import com.offcn.TestUnti.Log;
import com.offcn.TestUnti.MapUtil;
import com.offcn.TestUnti.MySqlUtil;
import com.offcn.TestUnti.ReadProperties;
import com.offcn.TestUnti.RequestDataUtils;
import com.offcn.TestUnti.StringUtils;
import com.offcn.TestUnti.aliOCR;
import com.offcn.interfaces.API;
import com.offcn.process.NWN;
import com.offcn.process.XYZB;

import net.sf.json.JSONObject;



/**
 * 生成二维码接口
 * 
 * @author puhui
 *
 */
public class createQrcode extends NWN implements API {
	public String parameter;//参数集合
	
	public String content;//内容
	public String size;//二维码尺寸 单位px
	public String margin_size;//外边距
	public String logo_path;//二维码logo 地址，如果不要logo 不用传
	public String logo_proportion;//logo 占比  3：30%
	public String output;//0：不直接输出，返回二维码连接地址，1 直接输出二维码，
	
	@Override
	public void initialize(HashMap<String, Object> data) {
	}

	@Override
	public HashMap<String, Object> handleInput(HashMap<String, Object> data) {
		// 获取parameter对应的内容
		parameter = MapUtil.getValue("parameter", data);
		content = MapUtil.getParameter_get(parameter, "content").trim();
		size = MapUtil.getParameter_get(parameter, "size").trim();
		margin_size = MapUtil.getParameter_get(parameter, "margin_size").trim();
		logo_path = MapUtil.getParameter_get(parameter, "logo_path").trim();
		logo_proportion = MapUtil.getParameter_get(parameter, "logo_proportion").trim();
		output = MapUtil.getParameter_get(parameter, "output").trim();
		
		if ((!content.equals("")) && content.equals("random")) {
			content="ys测试"+(new Random().nextInt(9000000)+ 1000000);
			parameter = parameter.replace("content=random", "content="+ content );
		}
		
		data.put("parameter", parameter);
		return data;
	}

	@Override
	public Response SendRequest(HashMap<String, Object> data, String Url,
			String Request) {
		
		Response re = RequestDataUtils.Get_token(data, Url, "");
		return re;
	}

	@Override
	public String handleOutput(Response re, HashMap<String, Object> data) {
		
		JsonPath jp = re.body().jsonPath();
		boolean result = true;
		String failReason = "";

		String json = re.asString();
		
		if(!json.contains("retcode")){
			
			if(data.get("custom") != null){
				String custom=data.get("custom").toString();
//				if(aliOCR.getPNG("out/nwn2wm.png", re.asInputStream())){
//					Log.logInfo("========保存二维码成功========");
//				}
				if(json.contains(custom)){
					return "Pass";
				}else{
					return "Fail:" + custom+" not find";
				}
			}
			return "Pass";
		}
		
		if ((data.get("statusCode") != null)
				&& (!data.get("statusCode").toString()
						.equals(String.valueOf(re.getStatusCode())))) {
			result = result && false;
			failReason = failReason + "statusCode is expected "
					+ data.get("statusCode").toString() + " but actually "
					+ String.valueOf(re.getStatusCode()) + ". ";
		}

		if (json.length() != 0) {
			
			String msg=jp.getString("message");
			String code=jp.getString("retcode");
			
			if ((data.get("code") != null ) && (code != null) && (!code.equals(data.get("code").toString()))) {
				result = result && false;
				failReason = failReason + "code is expected "
						+ data.get("code").toString() + " but actually "
						+ jp.getString("code") + ".";
			}

			if ((data.get("msg") != null) && (msg != null) && (!msg.equals(data.get("msg").toString()))) {
				result = result && false;
				failReason = failReason + "msg is expected "
						+ data.get("msg").toString() + " but actually "
						+ jp.getString("msg") + ".";
			}
			
			if(data.get("custom") != null && jp.getString("data")!=null){
				String custom=data.get("custom").toString();
				String[] ArrayString=StringUtils.getArrayString(custom,",");
//				System.out.println(jp.getString("custom"));
//				System.out.println(Arrays.toString(ArrayString));
				if(!StringUtils.VerificationString(jp.getString("data"),ArrayString)){
					result = result && false;
					failReason = failReason + "custom is expected "
							+ data.get("custom").toString() + " but actually "
							+ jp.getString("data") + ".";
				}
			}
			
			if("success".equals(msg)){
				
				//是否验证数据库
				if (!isProduct) {
					
				}
			}
		}
			
		
		if (result)
			return "Pass";
		else
			return "Fail:" + failReason;
	}

}
