package com.offcn.api.nwn;

import io.restassured.path.json.JsonPath;
import io.restassured.response.Response;

import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.HashMap;
import java.util.Random;

import org.json.simple.JSONArray;

import com.offcn.TestUnti.Log;
import com.offcn.TestUnti.MapUtil;
import com.offcn.TestUnti.RequestDataUtils;
import com.offcn.TestUnti.StringUtils;
import com.offcn.interfaces.API;
import com.offcn.process.NWN;
import com.offcn.process.TK;
import com.offcn.TestUnti.ListUtil;

import net.sf.json.JSONObject;



/**
 * 添加用户
 * 
 * @author puhui
 *
 */
public class addAccount extends NWN implements API {
	public String parameter;//参数集合
	
	public String card_no;//sso正常用户
	public String username;//昵称
	public String phone;//电话

	@Override
	public void initialize(HashMap<String, Object> data) {
		if (!isProduct && data.get("CleanDB").toString().contains("Y")) {
			this.cleann_n_admin_card_no_List_FromDB();
		}
	}

	@Override
	public HashMap<String, Object> handleInput(HashMap<String, Object> data) {
		// 获取parameter对应的内容
		parameter = MapUtil.getValue("parameter", data);
		card_no = MapUtil.getParameter(parameter, "card_no").trim();
//		phone = MapUtil.getParameter(parameter, "phone").trim();
		
		if ((!card_no.equals("")) && card_no.equals("code")) {
			card_no="lgd58408";//从sso数据库中查询的已激活账户，作为备用账户使用
			parameter = parameter.replace("\"card_no\":code", "\"card_no\":\""+ card_no + "\"");
		}
		
		
		data.put("parameter", parameter);
		return data;
	}

	@Override
	public Response SendRequest(HashMap<String, Object> data, String Url,
			String Request) {
		Response re = RequestDataUtils.Post_cooike(data, Url,"PHPSESSID",PHPSESSID);
		return re;
	}

	@Override
	public String handleOutput(Response re, HashMap<String, Object> data) {
		JsonPath jp = re.body().jsonPath();
		boolean result = true;
		String failReason = "";

		String json = re.asString();

		if ((data.get("statusCode") != null)
				&& (!data.get("statusCode").toString()
						.equals(String.valueOf(re.getStatusCode())))) {
			result = result && false;
			failReason = failReason + "statusCode is expected "
					+ data.get("statusCode").toString() + " but actually "
					+ String.valueOf(re.getStatusCode()) + ". ";
		}

		if (json.length() != 0) {
			
			String msg=StringUtils.decodeUnicode(getMsg(re));
			String code=getCode(re);
			
			if ((data.get("code") != null ) && (code != null) && (!code.equals(data.get("code").toString()))) {
				result = result && false;
				failReason = failReason + "code is expected "
						+ data.get("code").toString() + " but actually "
						+ jp.getString("code") + ".";
			}

			if ((data.get("msg") != null) && (msg != null) && (!msg.equals(data.get("msg").toString()))) {
				result = result && false;
				failReason = failReason + "msg is expected "
						+ data.get("msg").toString() + " but actually "
						+ jp.getString("msg") + ".";
			}
			
			if(data.get("custom") != null && jp.getString("data")!=null){
				String custom=data.get("custom").toString();
				String[] ArrayString=StringUtils.getArrayString(custom,",");
				if(!StringUtils.VerificationString(jp.getString("data"),ArrayString)){
					result = result && false;
					failReason = failReason + "custom is expected "
							+ data.get("custom").toString() + " but actually "
							+ jp.getString("data") + ".";
				}
			}
			
			if("添加成功!".equals(msg)){
				
				//是否验证数据库
				if (!isProduct) {
					
					parameter = MapUtil.getValue("parameter", data);
					card_no = MapUtil.getParameter(parameter, "card_no").trim();
					card_no = MapUtil.killQuotes(card_no, "\"");
					
					username = MapUtil.getParameter(parameter, "username").trim();
					username = MapUtil.killQuotes(username, "\"");
					
					phone = MapUtil.getParameter(parameter, "phone").trim();
					phone = MapUtil.killQuotes(phone, "\"");
					
					n_admin_card_no_List.add(card_no);
					
					try {
						
						String sql="select * from n_admin where card_no='"+card_no+"'";
						
						ResultSet rs_bankcard = this.sqlFromDB(sql);
						rs_bankcard.last();
						
						if(rs_bankcard.getRow()>=1){
							
							
							String act_username=rs_bankcard.getString("username").equals("null ")?"null":rs_bankcard.getString("username");
							String act_phone=rs_bankcard.getString("phone").equals("null ")?"null":rs_bankcard.getString("phone");
							String act_id=rs_bankcard.getString("id").equals("null ")?"null":rs_bankcard.getString("id");
							
							n_admin_id_List.add(act_id);//保存地区，以后需要删除的必须参数
							n_admin_phone_List.add(act_phone);
							n_admin_username_List.add(act_username);
							
							
							if(!(username.equals(act_username))){
									result = result && false;
									failReason = failReason + "n_admin info username is not in DB;";
							}
							if(!(phone.equals(act_phone))){
								result = result && false;
								failReason = failReason + "n_admin info phone is not in DB;";
							}
						}
						
					} catch (Exception e) {
						result = result && false;
						failReason = failReason + "cannot verify n_admin info in DB;";
						e.printStackTrace();
					}
				}
			}
			
			
		}
		if (result)
			return "Pass";
		else
			return "Fail:" + failReason;
	}

}
