/*
 * Decompiled with CFR 0.152.
 */
package org.dbunit.dataset.filter;

import java.util.ArrayList;
import org.dbunit.database.AmbiguousTableNameException;
import org.dbunit.dataset.DataSetException;
import org.dbunit.dataset.DataSetUtils;
import org.dbunit.dataset.IDataSet;
import org.dbunit.dataset.ITableIterator;
import org.dbunit.dataset.ITableMetaData;
import org.dbunit.dataset.NoSuchTableException;
import org.dbunit.dataset.OrderedTableNameMap;
import org.dbunit.dataset.filter.ITableFilter;
import org.dbunit.dataset.filter.SequenceTableIterator;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SequenceTableFilter
implements ITableFilter {
    private static final Logger logger = LoggerFactory.getLogger(SequenceTableFilter.class);
    private final OrderedTableNameMap _tableNameMap;

    public SequenceTableFilter(String[] tableNames) throws AmbiguousTableNameException {
        this(tableNames, false);
    }

    public SequenceTableFilter(String[] tableNames, boolean caseSensitiveTableNames) throws AmbiguousTableNameException {
        this._tableNameMap = new OrderedTableNameMap(caseSensitiveTableNames);
        for (int i = 0; i < tableNames.length; ++i) {
            this._tableNameMap.add(tableNames[i], null);
        }
    }

    public boolean accept(String tableName) throws DataSetException {
        logger.debug("accept(tableName={}) - start", (Object)tableName);
        return this._tableNameMap.containsTable(tableName);
    }

    public String[] getTableNames(IDataSet dataSet) throws DataSetException {
        logger.debug("getTableNames(dataSet={}) - start", (Object)dataSet);
        ArrayList<String> nameList = new ArrayList<String>();
        String[] tableNames = this._tableNameMap.getTableNames();
        for (int i = 0; i < tableNames.length; ++i) {
            try {
                ITableMetaData metaData = dataSet.getTableMetaData(tableNames[i]);
                nameList.add(metaData.getTableName());
                continue;
            }
            catch (NoSuchTableException e) {
                logger.debug("Table '{}' not found in filtered dataset {}", (Object)tableNames[i], (Object)dataSet);
            }
        }
        return nameList.toArray(new String[0]);
    }

    public ITableIterator iterator(IDataSet dataSet, boolean reversed) throws DataSetException {
        if (logger.isDebugEnabled()) {
            logger.debug("iterator(dataSet={}, reversed={}) - start", (Object)dataSet, (Object)String.valueOf(reversed));
        }
        String[] tableNames = this.getTableNames(dataSet);
        return new SequenceTableIterator(reversed ? DataSetUtils.reverseStringArray(tableNames) : tableNames, dataSet);
    }

    public String toString() {
        StringBuffer sb = new StringBuffer();
        sb.append(this.getClass().getName()).append("[");
        sb.append("_tableNameMap=").append(this._tableNameMap);
        sb.append("]");
        return sb.toString();
    }
}

