/*
 * Decompiled with CFR 0.152.
 */
package org.dbunit.database.statement;

import java.sql.Connection;
import java.sql.SQLException;
import org.dbunit.database.statement.AbstractPreparedBatchStatement;
import org.dbunit.dataset.ITable;
import org.dbunit.dataset.datatype.DataType;
import org.dbunit.dataset.datatype.TypeCastException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PreparedBatchStatement
extends AbstractPreparedBatchStatement {
    private static final Logger logger = LoggerFactory.getLogger(PreparedBatchStatement.class);
    private int _index = 0;

    PreparedBatchStatement(String sql, Connection connection) throws SQLException {
        super(sql, connection);
    }

    public void addValue(Object value, DataType dataType) throws TypeCastException, SQLException {
        logger.debug("addValue(value={}, dataType={}) - start", value, (Object)dataType);
        if (value == null || value == ITable.NO_VALUE) {
            this._statement.setNull(++this._index, dataType.getSqlType(), dataType.getSqlTypeName());
            return;
        }
        dataType.setSqlValue(value, ++this._index, this._statement);
    }

    public void addBatch() throws SQLException {
        logger.debug("addBatch() - start");
        this._statement.addBatch();
        this._index = 0;
    }

    public int executeBatch() throws SQLException {
        logger.debug("executeBatch() - start");
        int[] results = this._statement.executeBatch();
        int result = 0;
        for (int i = 0; i < results.length; ++i) {
            result += results[i];
        }
        return result;
    }

    public void clearBatch() throws SQLException {
        logger.debug("clearBatch() - start");
        this._statement.clearBatch();
    }
}

