/*
 * Decompiled with CFR 0.152.
 */
package org.dbunit.database;

import java.sql.Connection;
import java.sql.SQLException;
import javax.naming.InitialContext;
import javax.naming.NamingException;
import javax.sql.DataSource;
import org.dbunit.database.AbstractDatabaseConnection;
import org.dbunit.database.IDatabaseConnection;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DatabaseDataSourceConnection
extends AbstractDatabaseConnection
implements IDatabaseConnection {
    private static final Logger logger = LoggerFactory.getLogger(DatabaseDataSourceConnection.class);
    private final String _schema;
    private final DataSource _dataSource;
    private final String _user;
    private final String _password;
    private Connection _connection;

    public DatabaseDataSourceConnection(InitialContext context, String jndiName, String schema) throws NamingException, SQLException {
        this((DataSource)context.lookup(jndiName), schema, null, null);
    }

    public DatabaseDataSourceConnection(InitialContext context, String jndiName, String schema, String user, String password) throws NamingException, SQLException {
        this((DataSource)context.lookup(jndiName), schema, user, password);
    }

    public DatabaseDataSourceConnection(InitialContext context, String jndiName) throws NamingException, SQLException {
        this(context, jndiName, null);
    }

    public DatabaseDataSourceConnection(InitialContext context, String jndiName, String user, String password) throws NamingException, SQLException {
        this(context, jndiName, null, user, password);
    }

    public DatabaseDataSourceConnection(DataSource dataSource) throws SQLException {
        this(dataSource, null, null, null);
    }

    public DatabaseDataSourceConnection(DataSource dataSource, String user, String password) throws SQLException {
        this(dataSource, null, user, password);
    }

    public DatabaseDataSourceConnection(DataSource dataSource, String schema) throws SQLException {
        this(dataSource, schema, null, null);
    }

    public DatabaseDataSourceConnection(DataSource dataSource, String schema, String user, String password) throws SQLException {
        this._dataSource = dataSource;
        this._schema = schema;
        this._user = user;
        this._password = password;
    }

    public Connection getConnection() throws SQLException {
        logger.debug("getConnection() - start");
        if (this._connection == null) {
            try {
                this._connection = this._user != null ? this._dataSource.getConnection(this._user, this._password) : this._dataSource.getConnection();
            }
            catch (SQLException e) {
                logger.error("getConnection(): ", (Throwable)e);
                throw e;
            }
        }
        return this._connection;
    }

    public String getSchema() {
        return this._schema;
    }

    public void close() throws SQLException {
        logger.debug("close() - start");
        if (this._connection != null) {
            this._connection.close();
            this._connection = null;
        }
    }
}

