/*
 * Decompiled with CFR 0.152.
 */
package com.puhui.aes;

import com.puhui.aes.AesEnum;
import java.io.UnsupportedEncodingException;
import java.security.Key;
import javax.crypto.Cipher;
import javax.crypto.spec.IvParameterSpec;
import javax.crypto.spec.SecretKeySpec;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AesEncryptionUtil {
    private static Logger log = LoggerFactory.getLogger(AesEncryptionUtil.class);
    private static final String CIPHER_MODE = AesEnum.valueOf("FIRST").getCipherMode();
    private static final String KEY = AesEnum.valueOf("FIRST").getKey();
    private static final String IV = AesEnum.valueOf("FIRST").getIv();
    private static final String DATE = AesEnum.valueOf("FIRST").getDate();
    private static final String ENCODEING = "UTF-8";

    private AesEncryptionUtil() {
    }

    private static SecretKeySpec createKey(String key) {
        byte[] data = null;
        if (key == null) {
            key = "";
        }
        StringBuilder sb = new StringBuilder(16);
        sb.append(key);
        while (sb.length() < 16) {
            sb.append("0");
        }
        if (sb.length() > 16) {
            sb.setLength(16);
        }
        try {
            data = sb.toString().getBytes(ENCODEING);
        }
        catch (UnsupportedEncodingException e) {
            log.error(e.getMessage(), (Throwable)e);
        }
        return new SecretKeySpec(data, "AES");
    }

    private static IvParameterSpec createIV(String password) {
        byte[] data = null;
        if (password == null) {
            password = "";
        }
        StringBuilder sb = new StringBuilder(16);
        sb.append(password);
        while (sb.length() < 16) {
            sb.append("0");
        }
        if (sb.length() > 16) {
            sb.setLength(16);
        }
        try {
            data = sb.toString().getBytes(ENCODEING);
        }
        catch (UnsupportedEncodingException e) {
            log.error(e.getMessage(), (Throwable)e);
        }
        return new IvParameterSpec(data);
    }

    private static byte[] encrypt(byte[] content) {
        try {
            SecretKeySpec key = AesEncryptionUtil.createKey(KEY);
            Cipher cipher = Cipher.getInstance(CIPHER_MODE);
            cipher.init(1, (Key)key, AesEncryptionUtil.createIV(IV));
            return cipher.doFinal(content);
        }
        catch (Exception e) {
            log.error(e.getMessage(), (Throwable)e);
            return new byte[0];
        }
    }

    public static String encrypt(String content) {
        String data;
        try {
            if (content.startsWith("xy")) {
                return null;
            }
            data = AesEncryptionUtil.byteToHexString(AesEncryptionUtil.encrypt(content.getBytes(ENCODEING)));
        }
        catch (Exception e) {
            log.error(e.getMessage(), (Throwable)e);
            return null;
        }
        return "xy" + data + DATE;
    }

    private static byte[] decrypt(byte[] content) {
        try {
            SecretKeySpec key = AesEncryptionUtil.createKey(KEY);
            Cipher cipher = Cipher.getInstance(CIPHER_MODE);
            cipher.init(2, (Key)key, AesEncryptionUtil.createIV(IV));
            return cipher.doFinal(content);
        }
        catch (Exception e) {
            log.error(e.getMessage(), (Throwable)e);
            return new byte[0];
        }
    }

    public static String decrypt(String content) {
        String result = null;
        try {
            if (!content.startsWith("xy")) {
                return content;
            }
            content = content.substring(2);
            byte[] data = AesEncryptionUtil.decrypt(AesEncryptionUtil.hexStringToByte(content = content.substring(0, content.length() - 8)));
            if (data == null) {
                return result;
            }
            result = new String(data, ENCODEING);
        }
        catch (Exception e) {
            log.error(e.getMessage(), (Throwable)e);
        }
        return result;
    }

    private static String byteToHexString(byte[] bytes) {
        StringBuilder sb = new StringBuilder();
        for (byte b : bytes) {
            String strHex = Integer.toHexString(b);
            if (strHex.length() > 3) {
                sb.append(strHex.substring(6));
                continue;
            }
            if (strHex.length() < 2) {
                sb.append("0").append(strHex);
                continue;
            }
            sb.append(strHex);
        }
        return sb.toString();
    }

    private static byte[] hexStringToByte(String s) {
        byte[] baKeyword = new byte[s.length() / 2];
        for (int i = 0; i < baKeyword.length; ++i) {
            try {
                baKeyword[i] = (byte)(0xFF & Integer.parseInt(s.substring(i * 2, i * 2 + 2), 16));
                continue;
            }
            catch (Exception e) {
                log.error(e.getMessage(), (Throwable)e);
            }
        }
        return baKeyword;
    }
}

