package com.offcn.api.xyzb;

import io.restassured.path.json.JsonPath;
import io.restassured.response.Response;

import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.HashMap;

import org.json.simple.JSONArray;

import com.offcn.TestUnti.MapUtil;
import com.offcn.TestUnti.RequestDataUtils;
import com.offcn.TestUnti.StringUtils;
import com.offcn.interfaces.API;
import com.offcn.process.XYZB;

import net.sf.json.JSONObject;



/**
 * 拉流
 * 
 * @author puhui
 *
 */
public class pull extends XYZB implements API {

	public String Description;//参数集合
	
	@Override
	public void initialize(HashMap<String, Object> data) {
	}

	@Override
	public HashMap<String, Object> handleInput(HashMap<String, Object> data) {
		return data;
	}

	@Override
	public Response SendRequest(HashMap<String, Object> data, String Url,
			String Request) {
		// 获取parameter对应的内容
		Description = MapUtil.getValue("Description", data);
		if(Description.contains("错误token")){
			Response re = RequestDataUtils.Get_Errtoken(data, Url, Client_token);
			return re;
		}else if(Description.contains("超长token")){
			Response re = RequestDataUtils.Get_Longtoken(data, Url, Client_token);
			return re;
		}else if(Description.contains("无token")){
			Response re = RequestDataUtils.Get_Notoken(data, Url);
			return re;
		}
		Response re = RequestDataUtils.Get_token(data, Url,Client_token);
		return re;
	}

	@Override
	public String handleOutput(Response re, HashMap<String, Object> data) {
		JsonPath jp = re.body().jsonPath();
		boolean result = true;
		String failReason = "";

		String json = re.asString();

		if ((data.get("statusCode") != null)
				&& (!data.get("statusCode").toString()
						.equals(String.valueOf(re.getStatusCode())))) {
			result = result && false;
			failReason = failReason + "statusCode is expected "
					+ data.get("statusCode").toString() + " but actually "
					+ String.valueOf(re.getStatusCode()) + ". ";
		}

		if (json.length() != 0) {
			
			String msg=StringUtils.decodeUnicode(jp.getString("msg"));
			
			if ((data.get("code") != null )
					&& ((jp.getString("code") == null) || (!jp.getString(
							"code").equals(data.get("code").toString())))) {
				result = result && false;
				failReason = failReason + "code is expected "
						+ data.get("code").toString() + " but actually "
						+ jp.getString("code") + ".";
			}

			if ((data.get("msg") != null)
					&& ((msg == null) || (!msg.equals(data.get("msg").toString())))) {
				result = result && false;
				failReason = failReason + "msg is expected "
						+ data.get("msg").toString() + " but actually "
						+ jp.getString("msg") + ".";
			}
				
			if((data.get("custom") != null) && jp.getString("data").length()>4){
				String custom=data.get("custom").toString();
				String[] ArrayString=StringUtils.getArrayString(custom,",");
				if(!StringUtils.VerificationString(jp.getString("data"),ArrayString)){
					result = result && false;
					failReason = failReason + "custom is expected "
							+ data.get("custom").toString() + " but actually "
							+ jp.getString("data") + ".";
				}
			}
			
			if (jp.getString("data") != null){
				//获取data数组里面的第一个参数的值,存放在小雨直播业务流程数据组中
				String rtmp=jp.getString("data.rtmp");
				pull_xyzb.put("rtmp", rtmp);
				String hls=jp.getString("data.hls");
				pull_xyzb.put("hls", hls);
				String hdl=jp.getString("data.hdl");
				pull_xyzb.put("hdl", hdl);
			}
		}
		
		if (result)
			return "Pass";
		else
			return "Fail:" + failReason;
	}

}
