package com.offcn.api.xyzb.process;

import io.restassured.path.json.JsonPath;
import io.restassured.response.Response;

import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.HashMap;
import java.util.Random;

import org.json.simple.JSONArray;

import com.offcn.TestUnti.Log;
import com.offcn.TestUnti.MapUtil;
import com.offcn.TestUnti.MyDateUtil;
import com.offcn.TestUnti.PhoneNoGeneratorUtil;
import com.offcn.TestUnti.ReadProperties;
import com.offcn.TestUnti.RequestDataUtils;
import com.offcn.TestUnti.StringUtils;
import com.offcn.TestUnti.randomUtil;
import com.offcn.interfaces.API;
import com.offcn.process.XYZB;

import net.sf.json.JSONObject;

/**
 * 流程--添加企业用户
 * 
 * @author puhui
 *
 */
public class member extends XYZB implements API {
	public String parameter;//参数集合
	public String Description;//用例名称
	
	public String _token;//token
	public String name;//姓名
	public String password;//密码
	public String email;//邮箱
	public String mobile;//电话
	public String role_id;//角色
	public String repass;//重复密码
	
	public static String temporary_name;//临时用户名
	public static String temporary_pwd;//临时密码
	
	@Override
	public void initialize(HashMap<String, Object> data) {
	}

	@Override
	public HashMap<String, Object> handleInput(HashMap<String, Object> data) {
		// 获取parameter对应的内容
		parameter = MapUtil.getValue("parameter", data);
		_token = MapUtil.getParameter(parameter, "_token").trim();
		name = MapUtil.getParameter(parameter, "name").trim();
		password = MapUtil.getParameter(parameter, "password").trim();
		email = MapUtil.getParameter(parameter, "email").trim();
		mobile = MapUtil.getParameter(parameter, "mobile").trim();
		role_id = MapUtil.getParameter(parameter, "role_id").trim();
		repass = MapUtil.getParameter(parameter, "repass").trim();
		
		if ((!_token.equals("")) && _token.equals("code")) {
			parameter = parameter.replace("\"_token\":code", "\"_token\":\""+ Page_token + "\"");
		}
		
		
		
		if ((!name.equals("")) && name.equals("random")) {
			SimpleDateFormat dateformat = new SimpleDateFormat("yyyyMMddHHmmss");
			String dateStr = dateformat.format(new Date());
//			temporary_name="ys"+(new Random().nextInt(9000)+ 1000);
			temporary_name="ys"+(new Random().nextInt(9000)+ 1000)+dateStr;
			parameter = parameter.replace("\"name\":random", "\"name\":\""+ temporary_name + "\"");
		}
		if ((!name.equals("")) && name.equals("Enterprise_users")) {
			parameter = parameter.replace("\"name\":Enterprise_users", "\"name\":\""+ Enterprise_users.get("name") + "\"");
		}
		if ((!name.equals("")) && name.equals("Business_Administrator")) {
			parameter = parameter.replace("\"name\":Business_Administrator", "\"name\":\""+ Business_Administrator.get("name") + "\"");
		}
		
		
		
		
		if ((!email.equals("")) && email.equals("random")) {
			parameter = parameter.replace("\"email\":random", "\"email\":\""+ temporary_name + "@qq.com\"");
		}
		if ((!mobile.equals("")) && mobile.equals("random")) {
			parameter = parameter.replace("\"mobile\":random", "\"mobile\":\""+ PhoneNoGeneratorUtil.getPhoneNo() + "\"");
		}
		temporary_pwd=password;
		// 替换原来的parameter
		data.put("parameter", parameter);
		
		return data;
	}

	@Override
	public Response SendRequest(HashMap<String, Object> data, String Url,
			String Request) {
		Response re = RequestDataUtils.Post_NOToken(data, Url);
		return re;
	}

	@Override
	public String handleOutput(Response re, HashMap<String, Object> data) {
		JsonPath jp = re.body().jsonPath();
		boolean result = true;
		String failReason = "";

		String json = re.asString();

		if ((data.get("statusCode") != null)
				&& (!data.get("statusCode").toString()
						.equals(String.valueOf(re.getStatusCode())))) {
			result = result && false;
			failReason = failReason + "statusCode is expected "
					+ data.get("statusCode").toString() + " but actually "
					+ String.valueOf(re.getStatusCode()) + ". ";
		}

		if (json.length() != 0) {
			
			String msg=StringUtils.decodeUnicode(jp.getString("msg"));
			
			if ((data.get("code") != null )
					&& ((jp.getString("code") == null) || (!jp.getString(
							"code").equals(data.get("code").toString())))) {
				result = result && false;
				failReason = failReason + "code is expected "
						+ data.get("code").toString() + " but actually "
						+ jp.getString("code") + ".";
			}

			if ((data.get("msg") != null)
					&& ((msg == null) || (!msg.equals(data.get("msg").toString())))) {
				result = result && false;
				failReason = failReason + "msg is expected "
						+ data.get("msg").toString() + " but actually "
						+ jp.getString("msg") + ".";
			}
			
			if(data.get("custom") != null && !re.asString().contains("</html>")){
				String custom=data.get("custom").toString();
				String[] ArrayString=StringUtils.getArrayString(custom,",");
				if(!StringUtils.VerificationString(jp.getString("data"),ArrayString)){
					result = result && false;
					failReason = failReason + "custom is expected "
							+ data.get("custom").toString() + " but actually "
							+ jp.getString("data") + ".";
				}
			}
			
			if("2".equals(role_id)){
				Enterprise_users.put("name", temporary_name);
				Enterprise_users.put("pwd", temporary_pwd);
				ReadProperties.updateProperty("Enterprise_users", Enterprise_users.get("name").toString());
			}
			if("3".equals(role_id)){
				Business_Administrator.put("name", temporary_name);
				Business_Administrator.put("pwd", temporary_pwd);
				ReadProperties.updateProperty("Business_Administrator", Business_Administrator.get("name").toString());
			}
			
			//是否是线上数据库
			if (!isProduct) {
					name = MapUtil.getParameter(parameter, "name").trim();
					email = MapUtil.getParameter(parameter, "email").trim();
					mobile = MapUtil.getParameter(parameter, "mobile").trim();
					
					name = MapUtil.killQuotes(name, "\"");//去掉双引号的bankNo
					email = MapUtil.killQuotes(email, "\"");//去掉双引号的bankName
					mobile = MapUtil.killQuotes(mobile, "\"");//去掉双引号的bankCode
					
					try {
						ResultSet rs_bankcard = this.selectFromDB(
								" xyu_users x ",
								" x.name = '" + name + "' ");
						rs_bankcard.last();
						
						if (rs_bankcard.getRow() < 1) {
							result = result && false;
							failReason = failReason + "xyu_users info is not in DB;";
						} else {
							String exp_email = (email != null)
									? String.valueOf(email).trim() : "";
							String exp_mobile = (mobile != null)
									? String.valueOf(mobile).trim() : "";

							String act_email = String
									.valueOf(rs_bankcard.getString(rs_bankcard.findColumn("email")));
							String act_mobile = String
									.valueOf(rs_bankcard.getString(rs_bankcard.findColumn("mobile")));
							
							if ((!exp_email.equals(act_email)) || (!exp_mobile.equals(act_mobile))) {
								result = result && false;
								failReason = failReason + "xyu_users info in DB is wrong;";
							} else {
								 Log.logInfo("xyu_users info in DB is correct;");
							}
						}
					} catch (Exception e) {
						result = result && false;
						failReason = failReason + "cannot verify bankcard info in DB;";
						e.printStackTrace();
					}
				}
			
		}
		if (result)
			return "Pass";
		else
			return "Fail:" + failReason;
	}

}
