package com.offcn.api.xyzb;

import io.restassured.path.json.JsonPath;
import io.restassured.response.Response;

import java.sql.ResultSet;
import java.util.HashMap;
import java.util.Map;
import java.util.Random;

import com.offcn.TestUnti.Log;
import com.offcn.TestUnti.MapUtil;
import com.offcn.TestUnti.MyDateUtil;
import com.offcn.TestUnti.ReadProperties;
import com.offcn.TestUnti.RequestDataUtils;
import com.offcn.TestUnti.StringUtils;
import com.offcn.interfaces.API;
import com.offcn.process.BasicsGM;
import com.offcn.process.XYZB;



/**
 * 更新运营信息
 * 
 * @author puhui
 *
 */
public class operation_info_up extends XYZB implements API {
	public String parameter;//参数集合
	public String Description;
	
	public String weixintitle;//
	public String weixinlink;//
	public String weibotitle;//
	public String weibolink;//
	public String qqgrouptitle;//
	public String qqgrouplink;//

	@Override
	public void initialize(HashMap<String, Object> data) {
	}

	@Override
	public HashMap<String, Object> handleInput(HashMap<String, Object> data) {
		// 获取parameter对应的内容
		parameter = MapUtil.getValue("parameter", data);
		weixintitle = MapUtil.getParameter(parameter, "weixintitle").trim();
		weixinlink = MapUtil.getParameter(parameter, "weixinlink").trim();
		weibotitle = MapUtil.getParameter(parameter, "weibotitle").trim();
		weibolink = MapUtil.getParameter(parameter, "weibolink").trim();
		qqgrouptitle = MapUtil.getParameter(parameter, "qqgrouptitle").trim();
		qqgrouplink = MapUtil.getParameter(parameter, "qqgrouplink").trim();
		
		if ((!weixintitle.equals("")) && weixintitle.equals("random")) {
			weixintitle="ys"+(new Random().nextInt(90000000)+ 10000000);
			parameter = parameter.replace("\"weixintitle\":random", "\"weixintitle\":\""+ weixintitle + "\"");
		}
		
		// 替换原来的parameter
		data.put("parameter", parameter);
		return data;
	}

	@Override
	public Response SendRequest(HashMap<String, Object> data, String Url,
			String Request) {
		Map<String, Object>  jsonAsMap = new HashMap<>();
		
		jsonAsMap.put("weixintitle", weixintitle);
		jsonAsMap.put("weixinlink", weixinlink);
		jsonAsMap.put("weibotitle", weibotitle);
		jsonAsMap.put("weibolink", weibolink);
		jsonAsMap.put("qqgrouptitle", qqgrouptitle);
		jsonAsMap.put("qqgrouplink", qqgrouplink);
		
//		System.out.println(room_nums.get("Not_edited"));
		Response re = RequestDataUtils.Put_Token(data,Client_token, "/api/v1/operation_info",jsonAsMap);
		return re;
	}

	@Override
	public String handleOutput(Response re, HashMap<String, Object> data) {
		
		JsonPath jp = re.body().jsonPath();
		boolean result = true;
		String failReason = "";

		String json = re.asString();

		if ((data.get("statusCode") != null)
				&& (!data.get("statusCode").toString()
						.equals(String.valueOf(re.getStatusCode())))) {
			result = result && false;
			failReason = failReason + "statusCode is expected "
					+ data.get("statusCode").toString() + " but actually "
					+ String.valueOf(re.getStatusCode()) + ". ";
		}

		if (json.length() != 0) {
			
			String msg=StringUtils.decodeUnicode(jp.getString("msg"));
			
			if ((data.get("code") != null )
					&& ((jp.getString("code") == null) || (!jp.getString(
							"code").equals(data.get("code").toString())))) {
				result = result && false;
				failReason = failReason + "code is expected "
						+ data.get("code").toString() + " but actually "
						+ jp.getString("code") + ".";
			}

			if ((data.get("msg") != null)
					&& ((msg == null) || (!msg.equals(data.get("msg").toString())))) {
				result = result && false;
				failReason = failReason + "msg is expected "
						+ data.get("msg").toString() + " but actually "
						+ jp.getString("msg") + ".";
			}
			
			if(data.get("custom") != null && jp.getString("data").length()>4){
				String custom=data.get("custom").toString();
				String[] ArrayString=StringUtils.getArrayString(custom,",");
				if(!StringUtils.VerificationString(jp.getString("data"),ArrayString)){
					result = result && false;
					failReason = failReason + "custom is expected "
							+ data.get("custom").toString() + " but actually "
							+ jp.getString("data") + ".";
				}
			}
			
			if("操作成功".equals(jp.getString("msg"))){
				
				//是否是线上环境
				if (!isProduct) {
//					String weixintitle=jp.getString("data.weixintitle");
//					String weixinlink=jp.getString("data.weixinlink");
//					String weibotitle=jp.getString("data.weibotitle");
//					String weibolink=jp.getString("data.weibolink");
//					String qqgrouptitle=jp.getString("data.qqgrouptitle");
//					String qqgrouplink=jp.getString("data.qqgrouplink");
//					String updateTime=jp.getString("data.updateTime");
//					if(updateTime!=null){
//						updateTime=updateTime.substring(0,updateTime.length()-2);
//					}
					
					try {
						ResultSet xyu_room = this.selectFromDB(
								" xyu_room  r ",
								" r.room_num = '" + Current_room + "' ");
						xyu_room.last();
						
						String su=StringUtils.decodeUnicode((xyu_room.getString("operation_info")));
						
						if (!su.contains(weixintitle)){
							result = result && false;
							failReason = failReason + "xyu_room info in DB is wrong;";
						} 
						if (!su.contains(weixinlink)){
							result = result && false;
							failReason = failReason + "xyu_room info in DB is wrong;";
						} 
						if (!su.contains(weibotitle)){
							result = result && false;
							failReason = failReason + "xyu_room info in DB is wrong;";
						} 
						if (!su.contains(weibolink)){
							result = result && false;
							failReason = failReason + "xyu_room info in DB is wrong;";
						} 
						if (!su.contains(qqgrouptitle)){
							result = result && false;
							failReason = failReason + "xyu_room info in DB is wrong;";
						} 
						if (!su.contains(qqgrouplink)){
							result = result && false;
							failReason = failReason + "xyu_room info in DB is wrong;";
						} 
//						if (!su.contains(updateTime)){
//							result = result && false;
//							failReason = failReason + "xyu_room info in DB is wrong;";
//						} 
						else {
							Log.logInfo("xyu_room info in DB is correct;");
						}
						
					} catch (Exception e) {
						result = result && false;
						failReason = failReason + "cannot verify xyu_room info in DB;";
						e.printStackTrace();
					}
				}
			}
			
			
		}
		
		if (result){
			return "Pass";
		}else{
			return "Fail:" + failReason;
		}
	}

	
}
