package com.offcn.api.xyzb;

import io.restassured.path.json.JsonPath;
import io.restassured.response.Response;

import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.HashMap;

import org.json.simple.JSONArray;

import com.offcn.TestUnti.MapUtil;
import com.offcn.TestUnti.RequestDataUtils;
import com.offcn.TestUnti.StringUtils;
import com.offcn.interfaces.API;
import com.offcn.process.XYZB;

import net.sf.json.JSONObject;

/**
 * 业务员管理员登陆
 * 
 * @author puhui
 *
 */
public class login extends XYZB implements API {
	public String parameter;//参数集合
	public String Description;//用例名称
	public String username;//姓名
	
	@Override
	public void initialize(HashMap<String, Object> data) {
		
	}

	@Override
	public HashMap<String, Object> handleInput(HashMap<String, Object> data) {
		
		parameter = MapUtil.getValue("parameter", data);
		username = MapUtil.getParameter(parameter, "username").trim();
		
		if ((!username.equals("")) && username.equals("Enterprise_users")) {
			parameter = parameter.replace("\"username\":Enterprise_users", "\"username\":\""+ Enterprise_users.get("name") + "\"");
		}
		if ((!username.equals("")) && username.equals("Business_Administrator")) {
			parameter = parameter.replace("\"username\":Business_Administrator", "\"username\":\""+ Business_Administrator.get("name") + "\"");
		}
		// 替换原来的parameter
		data.put("parameter", parameter);
		
		return data;
	}

	@Override
	public Response SendRequest(HashMap<String, Object> data, String Url,
			String Request) {
		Response re = RequestDataUtils.Post_NOtokenNOcookie(data,Url );
		return re;
	}

	@Override
	public String handleOutput(Response re, HashMap<String, Object> data) {
		JsonPath jp = re.body().jsonPath();
		boolean result = true;
		String failReason = "";

		String json = re.asString();

		if ((data.get("statusCode") != null)
				&& (!data.get("statusCode").toString()
						.equals(String.valueOf(re.getStatusCode())))) {
			result = result && false;
			failReason = failReason + "statusCode is expected "
					+ data.get("statusCode").toString() + " but actually "
					+ String.valueOf(re.getStatusCode()) + ". ";
		}

		if (json.length() != 0) {
			
			String msg=StringUtils.decodeUnicode(jp.getString("msg"));
			
			if ((data.get("code") != null )
					&& ((jp.getString("code") == null) || (!jp.getString(
							"code").equals(data.get("code").toString())))) {
				result = result && false;
				failReason = failReason + "code is expected "
						+ data.get("code").toString() + " but actually "
						+ jp.getString("code") + ".";
			}

			if ((data.get("msg") != null)
					&& ((msg == null) || (!msg.equals(data.get("msg").toString())))) {
				result = result && false;
				failReason = failReason + "msg is expected "
						+ data.get("msg").toString() + " but actually "
						+ jp.getString("msg") + ".";
			}
			
			if(data.get("custom") != null && jp.getString("data")!=null && jp.getString("data").length()>4){
				String custom=data.get("custom").toString();
				String[] ArrayString=StringUtils.getArrayString(custom,",");
				if(!StringUtils.VerificationString(jp.getString("data"),ArrayString)){
					result = result && false;
					failReason = failReason + "custom is expected "
							+ data.get("custom").toString() + " but actually "
							+ jp.getString("data") + ".";
				}
			}

			if (jp.getString("data") != null){
				String token_data=jp.getString("data.access_token");
//				String[] token_arr=token_data.split(",");
//				String[] token_value=token_arr[0].split(":");
//				Salesman_token=token_value[1];
				Salesman_token=token_data;
			}	
			
		}
		if (result)
			return "Pass";
		else
			return "Fail:" + failReason;
	}

}
