package com.offcn.api.xyzb;

import io.restassured.path.json.JsonPath;
import io.restassured.response.Response;

import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.HashMap;

import org.json.simple.JSONArray;

import com.offcn.TestUnti.Log;
import com.offcn.TestUnti.MapUtil;
import com.offcn.TestUnti.ReadProperties;
import com.offcn.TestUnti.RequestDataUtils;
import com.offcn.TestUnti.StringUtils;
import com.offcn.interfaces.API;
import com.offcn.process.XYZB;

import net.sf.json.JSONObject;



/**
 * 获取房间用户信息
 * 
 * @author puhui
 *
 */
public class getRooms extends XYZB implements API {
	public String parameter;//参数集合
	public String Description;
	public String password;//姓名
	public String room_num;
	
	public String current_page;
	public String first_page_url;
	public String last_page;
	public String last_page_url;
	public String next_page_url;
	public String path;
	public String per_page;
	public String prev_page_url;
	public String to;
	public String total;
	
	@Override
	public void initialize(HashMap<String, Object> data) {
	}

	@Override
	public HashMap<String, Object> handleInput(HashMap<String, Object> data) {
		parameter = MapUtil.getValue("parameter", data);
		password = MapUtil.getParameter(parameter, "password").trim();
		
		return data;
	}

	@Override
	public Response SendRequest(HashMap<String, Object> data, String Url,
			String Request) {
		// 获取parameter对应的内容
		Description = MapUtil.getValue("Description", data);
		
		if(Description.contains("错误token")){
			Response re = RequestDataUtils.Get_Errtoken(data, "/api/v1/users", Client_token);
			return re;
		}else if(Description.contains("超长token")){
			Response re = RequestDataUtils.Get_Longtoken(data, "/api/v1/users", Client_token);
			return re;
		}else if(Description.contains("无token")){
			Response re = RequestDataUtils.Get_Notoken(data, "/api/v1/users");
			return re;
		}
		Response re = RequestDataUtils.Get_token(data, "/api/v1/users",Client_token);
		return re;
	}

	@Override
	public String handleOutput(Response re, HashMap<String, Object> data) {
		JsonPath jp = re.body().jsonPath();
		boolean result = true;
		String failReason = "";

		String json = re.asString();

		System.out.println(json);
		if ((data.get("statusCode") != null)
				&& (!data.get("statusCode").toString()
						.equals(String.valueOf(re.getStatusCode())))) {
			result = result && false;
			failReason = failReason + "statusCode is expected "
					+ data.get("statusCode").toString() + " but actually "
					+ String.valueOf(re.getStatusCode()) + ". ";
		}

		if (json.length() != 0) {
			
			String msg=StringUtils.decodeUnicode(jp.getString("msg"));
			
			if ((data.get("code") != null )
					&& ((jp.getString("code") == null) || (!jp.getString(
							"code").equals(data.get("code").toString())))) {
				result = result && false;
				failReason = failReason + "code is expected "
						+ data.get("code").toString() + " but actually "
						+ jp.getString("code") + ".";
			}

			if ((data.get("msg") != null)
					&& ((msg == null) || (!msg.equals(data.get("msg").toString())))) {
				result = result && false;
				failReason = failReason + "msg is expected "
						+ data.get("msg").toString() + " but actually "
						+ jp.getString("msg") + ".";
			}
				
			if((data.get("custom") != null) && jp.getString("data")!=null){
				String custom=data.get("custom").toString();
				String[] ArrayString=StringUtils.getArrayString(custom,",");
				if(!StringUtils.VerificationString(jp.getString("data"),ArrayString)){
					result = result && false;
					failReason = failReason + "custom is expected "
							+ data.get("custom").toString() + " but actually "
							+ jp.getString("data") + ".";
				}
			}
			
			
			//如果请求地址接口是studentinfo接口5
			if (jp.getString("data") != null) {
				parameter = MapUtil.getValue("parameter", data);
				
				first_page_url=jp.getString("data.first_page_url");
				last_page_url=jp.getString("data.last_page_url");
				next_page_url=jp.getString("data.next_page_url");
				prev_page_url=jp.getString("data.prev_page_url");
				total=jp.getString("data.total");
				
				String role="";
				if(parameter.contains("&")){
					String arr[]=parameter.split("&");
					role=arr[0].split("=")[1];
				}
				
				
				try {
					ResultSet rs_bankcard=null;
					if(!parameter.contains("role")){
						rs_bankcard = this.selectFromDB(
								" xyu_room_users r ",
								" r.room_num = '" + Current_room + "' ");
						rs_bankcard.last();
//						System.out.println(rs_bankcard.getString("count(*)"));
					}else{
						rs_bankcard = this.selectFromDB(
								" xyu_room_users r ",
								" r.room_num = '" + Current_room + "'  and online = '1' and role  = '"+role+"'");
						rs_bankcard.last();
//						System.out.println(rs_bankcard.getString("count(*)"));
					}
					
					
//					System.out.println(rs_bankcard.getRow());
					if (!(rs_bankcard.getRow()+"").equals(total)) {
						result = result && false;
						failReason = failReason + "total  is not  find;";
					} 
					if(!first_page_url.contains(parameter.substring(1, parameter.length()-2))){
						result = result && false;
						failReason = failReason + "first_page_url  is not  find;";
					}
					if(!last_page_url.contains(parameter.substring(1, parameter.length()-2))){
						result = result && false;
						failReason = failReason + "last_page_url  is not  find;";
					}
					if(next_page_url!=null && !next_page_url.contains(parameter.substring(1, parameter.length()-2))){
						result = result && false;
						failReason = failReason + "next_page_url  is not  find;";
					}
					if(prev_page_url!=null && !prev_page_url.contains(parameter.substring(1, parameter.length()-2))){
						result = result && false;
						failReason = failReason + "prev_page_url  is not  find;";
					}
					
				} catch (Exception e) {
					result = result && false;
					failReason = failReason + "cannot verify xyu_room info in DB;";
					e.printStackTrace();
				}
			}
		}
		
		if (result)
			return "Pass";
		else
			return "Fail:" + failReason;
	}

}
