package com.offcn.api.xyzb;

import io.restassured.path.json.JsonPath;
import io.restassured.response.Response;

import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.HashMap;
import java.util.Random;

import org.json.simple.JSONArray;

import com.offcn.TestUnti.Log;
import com.offcn.TestUnti.MapUtil;
import com.offcn.TestUnti.MyDateUtil;
import com.offcn.TestUnti.ReadProperties;
import com.offcn.TestUnti.RequestDataUtils;
import com.offcn.TestUnti.StringUtils;
import com.offcn.interfaces.API;
import com.offcn.process.BasicsGM;
import com.offcn.process.XYZB;

import net.sf.json.JSONObject;



/**
 * 添加公告
 * 
 * @author puhui
 *
 */
public class announce extends XYZB implements API {
	public String parameter;//参数集合
	
	public String uuid;
	public String nickname;
	public String create_time;
	public String token_room_num;
	public String content;//公告内容
	public String id;

	@Override
	public void initialize(HashMap<String, Object> data) {
	}

	@Override
	public HashMap<String, Object> handleInput(HashMap<String, Object> data) {
		return data;
	}

	@Override
	public Response SendRequest(HashMap<String, Object> data, String Url,
			String Request) {
		Response re = RequestDataUtils.Post_token(data, Url,Client_token);
		return re;
	}

	@Override
	public String handleOutput(Response re, HashMap<String, Object> data) {
		JsonPath jp = re.body().jsonPath();
		boolean result = true;
		String failReason = "";

		String json = re.asString();

		if ((data.get("statusCode") != null)
				&& (!data.get("statusCode").toString()
						.equals(String.valueOf(re.getStatusCode())))) {
			result = result && false;
			failReason = failReason + "statusCode is expected "
					+ data.get("statusCode").toString() + " but actually "
					+ String.valueOf(re.getStatusCode()) + ". ";
		}

		if (json.length() != 0) {
			
			String msg=StringUtils.decodeUnicode(jp.getString("msg"));
			
			if ((data.get("code") != null )
					&& ((jp.getString("code") == null) || (!jp.getString(
							"code").equals(data.get("code").toString())))) {
				result = result && false;
				failReason = failReason + "code is expected "
						+ data.get("code").toString() + " but actually "
						+ jp.getString("code") + ".";
			}

			if ((data.get("msg") != null)
					&& ((msg == null) || (!msg.equals(data.get("msg").toString())))) {
				result = result && false;
				failReason = failReason + "msg is expected "
						+ data.get("msg").toString() + " but actually "
						+ jp.getString("msg") + ".";
			}
			
			if(data.get("custom") != null && jp.getString("data")!=null){
				String custom=data.get("custom").toString();
				String[] ArrayString=StringUtils.getArrayString(custom,",");
				if(!StringUtils.VerificationString(jp.getString("data"),ArrayString)){
					result = result && false;
					failReason = failReason + "custom is expected "
							+ data.get("custom").toString() + " but actually "
							+ jp.getString("data") + ".";
				}
			}
			
			if("操作成功".equals(jp.getString("msg"))){
				
				//是否是线上环境
				if (!isProduct) {
					
					try {
						ResultSet rs_bankcard = this.selectFromDB(
								" xyu_announcement  a",
								" a.uuid = '" + Current_uuid + "' ");
						rs_bankcard.last();
						
						if (rs_bankcard.getRow() < 1) {
							result = result && false;
							failReason = failReason + "xyu_announcement info is not in DB;";
						} else {
							String act_uuid = String
									.valueOf(rs_bankcard.getString(rs_bankcard.findColumn("uuid")));
							String act_nickname = String
									.valueOf(rs_bankcard.getString(rs_bankcard.findColumn("nickname")));
							String act_create_time = String
									.valueOf(rs_bankcard.getString(rs_bankcard.findColumn("create_time")));
							String act_token_room_num = String
									.valueOf(rs_bankcard.getString(rs_bankcard.findColumn("token_room_num")));
							String act_content = String
									.valueOf(rs_bankcard.getString(rs_bankcard.findColumn("content")));
							Current_announcement_id=String.
									valueOf(rs_bankcard.getString(rs_bankcard.findColumn("id")));

							uuid = MapUtil.killQuotes(jp.getString("data.uuid"), "\"");//去掉双引号的uuid
							nickname = MapUtil.killQuotes(jp.getString("data.nickname"), "\"");//去掉双引号的uuid
							create_time = MapUtil.killQuotes(jp.getString("data.create_time"), "\"");//去掉双引号的uuid
							token_room_num = MapUtil.killQuotes(jp.getString("data.token_room_num"), "\"");//去掉双引号的uuid
							content = MapUtil.killQuotes(jp.getString("data.content"), "\"");//去掉双引号的uuid
							id = MapUtil.killQuotes(jp.getString("data.id"), "\"");//去掉双引号的uuid
							
							
							if ((!act_uuid.equals(uuid))
									|| (!act_nickname.equals(StringUtils.decodeUnicode(nickname)))
									|| (!act_create_time.contains(create_time))
									|| (!act_token_room_num.equals(token_room_num))
									|| (!act_content.contains(content))){
								result = result && false;
								failReason = failReason + "xyu_announcement info in DB is wrong;";
							} 
						}
					} catch (Exception e) {
						result = result && false;
						failReason = failReason + "cannot verify xyu_announcement info in DB;";
						e.printStackTrace();
					}
				}
			}
			
			
		}
		if (result)
			return "Pass";
		else
			return "Fail:" + failReason;
	}

}
