package com.offcn.api.tk;

import io.restassured.path.json.JsonPath;
import io.restassured.response.Response;

import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

import org.json.simple.JSONArray;

import com.offcn.TestUnti.Log;
import com.offcn.TestUnti.MapUtil;
import com.offcn.TestUnti.MySqlUtil;
import com.offcn.TestUnti.RequestDataUtils;
import com.offcn.TestUnti.StringUtils;
import com.offcn.interfaces.API;
import com.offcn.process.TK;
import com.offcn.TestUnti.ListUtil;

import net.sf.json.JSONObject;



/**
 * 用户地区操作
 * 
 * @author puhui
 *
 */
public class getUserArea extends TK implements API {
	public String parameter;//参数集合
	
	public String user_id;//用户id

	@Override
	public void initialize(HashMap<String, Object> data) {
	}

	@Override
	public HashMap<String, Object> handleInput(HashMap<String, Object> data) {
		// 获取parameter对应的内容
		parameter = MapUtil.getValue("parameter", data);
		user_id = MapUtil.getParameter(parameter, "user_id").trim();

		
		if ((!user_id.equals("")) && user_id.equals("code")) {
			user_id=ListUtil.getListValue(user_idList,0);
			parameter = parameter.replace("\"user_id\":code", "\"user_id\":\""+ user_id + "\"");
		}
		
		data.put("parameter", parameter);
		return data;
	}

	@Override
	public Response SendRequest(HashMap<String, Object> data, String Url,
			String Request) {
		Response re = RequestDataUtils.Post_token(data, Url,tk_token);
		return re;
	}

	@Override
	public String handleOutput(Response re, HashMap<String, Object> data) {
		JsonPath jp = re.body().jsonPath();
		boolean result = true;
		String failReason = "";

		String json = re.asString();

		if ((data.get("statusCode") != null)
				&& (!data.get("statusCode").toString()
						.equals(String.valueOf(re.getStatusCode())))) {
			result = result && false;
			failReason = failReason + "statusCode is expected "
					+ data.get("statusCode").toString() + " but actually "
					+ String.valueOf(re.getStatusCode()) + ". ";
		}

		if (json.length() != 0) {
			
			String msg=StringUtils.decodeUnicode(getMsg(re));
			String code=getCode(re);
			
			if ((data.get("code") != null ) && (code != null) && (!code.equals(data.get("code").toString()))) {
				result = result && false;
				failReason = failReason + "code is expected "
						+ data.get("code").toString() + " but actually "
						+ jp.getString("code") + ".";
			}

			if ((data.get("msg") != null) && (msg != null) && (!msg.equals(data.get("msg").toString()))) {
				result = result && false;
				failReason = failReason + "msg is expected "
						+ data.get("msg").toString() + " but actually "
						+ jp.getString("msg") + ".";
			}
			
			if(data.get("custom") != null && jp.getString("data")!=null){
				String custom=data.get("custom").toString();
				String[] ArrayString=StringUtils.getArrayString(custom,",");
				if(!StringUtils.VerificationString(jp.getString("data"),ArrayString)){
					result = result && false;
					failReason = failReason + "custom is expected "
							+ data.get("custom").toString() + " but actually "
							+ jp.getString("data") + ".";
				}
			}
			
			if("接口响应成功！".equals(msg)){
				

				List<Object> examList=jp.getList("data.exam");
				
				//是否验证数据库
				if (!isProduct) {
					
					try {
						String sql="select t.name as name , e.id as id, e.item_id  as item_id, "
								+ "e.exam_id as exam_id, e.province_id as province_id, e.if_default as if_default"
								+ " from t_exam  t, ( select  *  from t_exam_area  where user_id='"+user_id+"'  ) e "
								+ "where e.exam_id=t.id ";
						
						ResultSet rs_bankcard = this.sqlFromDB(sql);
						
						List<Map<String, Object>> list=MySqlUtil.ResultSetToList(rs_bankcard);
						
						String [] str={"id","name","item_id","exam_id","province_id","if_default"};
						
						List<Object> ListObject= MapUtil.getStringList(list,str);
						
						for(int i=0;i<ListObject.size();i++){
							
							String rse=ListObject.get(i).toString();
							
//							System.out.println(examList.toString().contains((rse.equals("false")?"0":"1")));
							
							if(!(examList.toString().contains((rse.equals("false")?"0":"1")))){
								result = result && false;
								failReason = failReason + "t_exam_area info system is not in DB;";
							}
							
						}
						
					} catch (Exception e) {
						result = result && false;
						failReason = failReason + "cannot verify t_exam_area info in DB;";
						e.printStackTrace();
					}
				}
			}
			
			
		}
		if (result)
			return "Pass";
		else
			return "Fail:" + failReason;
	}

}
