package com.offcn.api.tk;

import io.restassured.path.json.JsonPath;
import io.restassured.response.Response;

import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Random;

import org.json.simple.JSONArray;

import com.offcn.TestUnti.Log;
import com.offcn.TestUnti.MapUtil;
import com.offcn.TestUnti.MySqlUtil;
import com.offcn.TestUnti.RequestDataUtils;
import com.offcn.TestUnti.StringUtils;
import com.offcn.TestUnti.VerificationMethod;
import com.offcn.interfaces.API;
import com.offcn.process.TK;
import com.offcn.TestUnti.ListUtil;

import net.sf.json.JSONObject;



/**
 * .第三方登录接口绑定手机号
 * 
 * @author puhui
 *
 */
public class bindUserByPhone extends TK implements API {
	public String parameter;//参数集合
	
	public String user_id;//用户id
	public String phone;//用户手机号
	public String code;//手机验证码
	public String login_type;//第三方登录方式

	@Override
	public void initialize(HashMap<String, Object> data) {
	}

	@Override
	public HashMap<String, Object> handleInput(HashMap<String, Object> data) {
		// 获取parameter对应的内容
		parameter = MapUtil.getValue("parameter", data);
		phone = MapUtil.getParameter(parameter, "phone").trim();
		code = MapUtil.getParameter(parameter, "code").trim();
		user_id = MapUtil.getParameter(parameter, "user_id").trim();

		if ((!user_id.equals("")) && user_id.equals("code")) {
			user_id=ListUtil.getListValue(user_idList,0);
			parameter = parameter.replace("\"user_id\":code", "\"user_id\":\""+ user_id + "\"");
		}
		
		if ((!phone.equals("")) && phone.equals("code")) {
			phone=phoneNeb;
			parameter = parameter.replace("\"phone\":code", "\"phone\":\""+ phone + "\"");
		}
		
		if ((!code.equals("")) && code.equals("code")) {
			code=phone_code;
			parameter = parameter.replace("\"code\":code", "\"code\":\""+ code + "\"");
		}
		
		data.put("parameter", parameter);
		return data;
	}

	@Override
	public Response SendRequest(HashMap<String, Object> data, String Url,
			String Request) {
		Response re = RequestDataUtils.Post_token(data, Url,tk_token);
		return re;
	}

	@Override
	public String handleOutput(Response re, HashMap<String, Object> data) {
		JsonPath jp = re.body().jsonPath();
		boolean result = true;
		String failReason = "";

		String json = re.asString();

		if ((data.get("statusCode") != null)
				&& (!data.get("statusCode").toString()
						.equals(String.valueOf(re.getStatusCode())))) {
			result = result && false;
			failReason = failReason + "statusCode is expected "
					+ data.get("statusCode").toString() + " but actually "
					+ String.valueOf(re.getStatusCode()) + ". ";
		}

		if (json.length() != 0) {
			
			String msg=StringUtils.decodeUnicode(getMsg(re));
			String code=getCode(re);
			
			if ((data.get("code") != null ) && (code != null) && (!code.equals(data.get("code").toString()))) {
				result = result && false;
				failReason = failReason + "code is expected "
						+ data.get("code").toString() + " but actually "
						+ jp.getString("code") + ".";
			}

			if ((data.get("msg") != null) && (msg != null) && (!msg.equals(data.get("msg").toString()))) {
				result = result && false;
				failReason = failReason + "msg is expected "
						+ data.get("msg").toString() + " but actually "
						+ jp.getString("msg") + ".";
			}
			
			if(data.get("custom") != null && jp.getString("data")!=null){
				String custom=data.get("custom").toString();
				String[] ArrayString=StringUtils.getArrayString(custom,",");
				if(!StringUtils.VerificationString(jp.getString("data"),ArrayString)){
					result = result && false;
					failReason = failReason + "custom is expected "
							+ data.get("custom").toString() + " but actually "
							+ jp.getString("data") + ".";
				}
			}
			
			if("绑定成功".equals(msg)){
				
				String dataPhone=jp.getString("data.phone");
				dataPhone = MapUtil.killQuotes(dataPhone, "\"");
				
				String datalogin_type=jp.getString("data.login_type");
				datalogin_type = MapUtil.killQuotes(datalogin_type, "\"");
				
				String token=jp.getString("data.token");
				tk_token = MapUtil.killQuotes(token, "\"");//保存token
				
				//是否验证数据库
				if (!isProduct) {
					
					try {
						ResultSet rs_bankcard = this.selectFromDB(
								" t_user u ",
								" u.user_id = '" + user_id + "' ");
						rs_bankcard.last();
						
						if(rs_bankcard.getRow()>=1){
							phone = MapUtil.killQuotes(phone, "\"");
							phoneNeb=phone;
							
							String act_phone=rs_bankcard.getString("phone").equals("null ")?"null":rs_bankcard.getString("phone");
							String act_login_type=rs_bankcard.getString("login_type").equals("null ")?"null":rs_bankcard.getString("login_type");
							
							if(phone.length()<60){
								if(!(dataPhone.equals(act_phone) && (dataPhone.equals(phone)))){
									result = result && false;
									failReason = failReason + "t_user info phone is not in DB;";
								}
							}
							
							if(login_type.length()<60){
								if(!(datalogin_type.equals(act_login_type) && (datalogin_type.equals(login_type)))){
									result = result && false;
									failReason = failReason + "t_user info system is not in DB;";
								}
							}
						}
						
					} catch (Exception e) {
						result = result && false;
						failReason = failReason + "cannot verify t_user info in DB;";
						e.printStackTrace();
					}
				}
			}
			
		}
		if (result)
			return "Pass";
		else
			return "Fail:" + failReason;
	}

}
