package com.offcn.api.tk;

import io.restassured.path.json.JsonPath;
import io.restassured.response.Response;

import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.HashMap;

import org.json.simple.JSONArray;

import com.offcn.TestUnti.Log;
import com.offcn.TestUnti.MapUtil;
import com.offcn.TestUnti.RequestDataUtils;
import com.offcn.TestUnti.StringUtils;
import com.offcn.TestUnti.VerificationMethod;
import com.offcn.interfaces.API;
import com.offcn.process.TK;
import com.offcn.TestUnti.ListUtil;

import net.sf.json.JSONObject;



/**
 * 个人中心绑定第三方账号接口
 * 
 * @author puhui
 *
 */
public class bindThirdLoginByUserId extends TK implements API {
	public String parameter;//参数集合
	
	public String open_id;//第三方登录openId
	public String nickname;//昵称
	public String avatar;//第三方登录用户头像
	public String union_id;//微信登录的unionId(仅在微信登录时必填)
	public String login_type;//第三方登录类型（当前登录方式:phone手机登录;weibo微博登录;weixin微信登录;qq腾讯登录）
	public String user_id;//用户id

	@Override
	public void initialize(HashMap<String, Object> data) {
		if (!isProduct && data.get("CleanDB").toString().contains("Y")) {
			cleanUser_FromDB();//清除注册用户根据user_id
		}
	}

	@Override
	public HashMap<String, Object> handleInput(HashMap<String, Object> data) {
		// 获取parameter对应的内容
		parameter = MapUtil.getValue("parameter", data);
		union_id = MapUtil.getParameter(parameter, "union_id").trim();
		open_id = MapUtil.getParameter(parameter, "open_id").trim();
		user_id = MapUtil.getParameter(parameter, "user_id").trim();
		
		if ((!user_id.equals("")) && user_id.equals("code")) {
			user_id=ListUtil.getListValue(user_idList,0);
			parameter = parameter.replace("\"user_id\":code", "\"user_id\":\""+ user_id + "\"");
		}
		
		if ((!union_id.equals("")) && union_id.equals("code")) {
			union_id=union_id_str;
			parameter = parameter.replace("\"union_id\":code", "\"union_id\":\""+ union_id + "\"");
		}
		
		if ((!open_id.equals("")) && open_id.equals("code")) {
			open_id=open_id_str;
			parameter = parameter.replace("\"open_id\":code", "\"open_id\":\""+ open_id + "\"");
		}
		
		data.put("parameter", parameter);
		return data;
	}

	@Override
	public Response SendRequest(HashMap<String, Object> data, String Url,
			String Request) {
		Response re = RequestDataUtils.Post_NOtokenNOcookie(data, Url);
		return re;
	}

	@Override
	public String handleOutput(Response re, HashMap<String, Object> data) {
		JsonPath jp = re.body().jsonPath();
		boolean result = true;
		String failReason = "";

		String json = re.asString();

		if ((data.get("statusCode") != null)
				&& (!data.get("statusCode").toString()
						.equals(String.valueOf(re.getStatusCode())))) {
			result = result && false;
			failReason = failReason + "statusCode is expected "
					+ data.get("statusCode").toString() + " but actually "
					+ String.valueOf(re.getStatusCode()) + ". ";
		}

		if (json.length() != 0) {
			
//			System.out.println(jp.getString("message"));
//			String msg=StringUtils.decodeUnicode(getMsg(re));
			String msg=jp.getString("message");
			String code=jp.getString("retcode");
			
			
			if ((data.get("code") != null ) && (code != null) && (!code.equals(data.get("code").toString()))) {
				result = result && false;
				failReason = failReason + "code is expected "
						+ data.get("code").toString() + " but actually "
						+ jp.getString("code") + ".";
			}

			if ((data.get("msg") != null) && (msg != null) && (!msg.equals(data.get("msg").toString()))) {
				result = result && false;
				failReason = failReason + "msg is expected "
						+ data.get("msg").toString() + " but actually "
						+ jp.getString("msg") + ".";
			}
			
			if(data.get("custom") != null && jp.getString("data")!=null){
				String custom=data.get("custom").toString();
				String[] ArrayString=StringUtils.getArrayString(custom,",");
				if(!StringUtils.VerificationString(jp.getString("data"),ArrayString)){
					result = result && false;
					failReason = failReason + "custom is expected "
							+ data.get("custom").toString() + " but actually "
							+ jp.getString("data") + ".";
				}
			}
			
			if("注册成功".equals(msg) || "登录成功".equals(msg)){
				
				String user_id=jp.getString("data.userinfo.user_id");
				user_id = MapUtil.killQuotes(user_id, "\"");
				user_idList.add(user_id);
				
				String data_login_type=jp.getString("data.userinfo.login_type");
				data_login_type = MapUtil.killQuotes(data_login_type, "\"");
				data_login_type=data_login_type.equals("null ")?"null":data_login_type;
				
				String data_nickname=jp.getString("data.userinfo."+data_login_type+"_nickname");
				data_nickname = MapUtil.killQuotes(data_nickname, "\"");
				data_nickname=data_nickname.equals("null ")?"null":data_nickname;
				
				String data_avatar=jp.getString("data.userinfo.avatar");
				data_avatar = MapUtil.killQuotes(data_avatar, "\"");
				data_avatar=data_avatar.equals("null ")?"null":data_avatar;
				
				
				//这里~！！！
				
				
				
				//是否验证数据库
				if (!isProduct) {
					
					try {
						ResultSet rs_bankcard = this.selectFromDB(
								" t_user u ",
								" u.user_id = '" + user_id + "' ");
						rs_bankcard.last();
						
						if(rs_bankcard.getRow()>=1){
							
							String act_union_id=rs_bankcard.getString("union_id").equals("null ")?"null":rs_bankcard.getString("union_id");
							String act_weibo_nickname=rs_bankcard.getString("weibo_nickname").equals("null ")?"null":rs_bankcard.getString("weibo_nickname");
							String act_qq_nickname=rs_bankcard.getString("qq_nickname").equals("null ")?"null":rs_bankcard.getString("qq_nickname");
							String act_weixin_nickname=rs_bankcard.getString("weixin_nickname").equals("null ")?"null":rs_bankcard.getString("weixin_nickname");
							
							
							
							String act_login_type=rs_bankcard.getString("login_type").equals("null ")?"null":rs_bankcard.getString("login_type");
							String act_avatar=rs_bankcard.getString("avatar").equals("null ")?"null":rs_bankcard.getString("avatar");
							String act_qq_id=rs_bankcard.getString("qq_id").equals("null ")?"null":rs_bankcard.getString("qq_id");
							String act_weixin_id=rs_bankcard.getString("weixin_id").equals("null ")?"null":rs_bankcard.getString("weixin_id");
							String act_weibo_id=rs_bankcard.getString("weibo_id").equals("null ")?"null":rs_bankcard.getString("weibo_id");
							
							String act_open_id="";
							String act_nickname="";
							if("qq".equals(act_login_type)){
								act_open_id=act_qq_id;
								act_nickname=act_qq_nickname;
							}else if("weibo".equals(act_login_type)){
								act_open_id=act_weibo_id;
								act_nickname=act_weibo_nickname;
							}else if("weixin".equals(act_login_type)){
								act_open_id=act_weixin_id;
								act_nickname=act_weixin_nickname;
							}
							
//							System.out.println((dataPhone.equals(act_phone)));
//							System.out.println((dataPhone.equals(phone)));
							parameter = MapUtil.getValue("parameter", data);
							union_id = MapUtil.getParameter(parameter, "union_id").trim();
							union_id = MapUtil.killQuotes(union_id, "\"");
							
							open_id = MapUtil.getParameter(parameter, "open_id").trim();
							open_id = MapUtil.killQuotes(open_id, "\"");
							
							nickname = MapUtil.getParameter(parameter, "nickname").trim();
							nickname = MapUtil.killQuotes(nickname, "\"");
							
							login_type = MapUtil.getParameter(parameter, "login_type").trim();
							login_type = MapUtil.killQuotes(login_type, "\"");
							
							avatar = MapUtil.getParameter(parameter, "avatar").trim();
							avatar = MapUtil.killQuotes(avatar, "\"");
							
							if(union_id.length()<60){
								if(!(union_id.equals(act_union_id))){
									result = result && false;
									failReason = failReason + "t_user info  union_id is not in DB;";
								}
							}
							
							if(nickname.length()<60){
								if(!(data_nickname.equals(act_nickname) && (data_nickname.equals(nickname)))){
									result = result && false;
									failReason = failReason + "t_user info  nickname is not in DB;";
								}
							}
							
							if(login_type.length()<60){
								if(!(data_login_type.equals(act_login_type) && (data_login_type.equals(login_type)))){
									result = result && false;
									failReason = failReason + "t_user info  login_type is not in DB;";
								}
							}
							
							if(avatar.length()<60){
								if(!(data_avatar.equals(act_avatar) && (data_avatar.equals(avatar)))){
									result = result && false;
									failReason = failReason + "t_user info  avatar is not in DB;";
								}
							}
							
							if(open_id.length()<60){
								if(!(open_id.equals(act_open_id))){
									result = result && false;
									failReason = failReason + "t_user info  open_id is not in DB;";
								}
							}
						}
						
					} catch (Exception e) {
						result = result && false;
						failReason = failReason + "cannot verify t_user info in DB;";
						e.printStackTrace();
					}
				}
			}
		}
		if (result)
			return "Pass";
		else
			return "Fail:" + failReason;
	}

}
