package com.offcn.api.nwn;

import io.restassured.path.json.JsonPath;
import io.restassured.response.Response;

import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.HashMap;
import java.util.Random;

import org.json.simple.JSONArray;

import com.offcn.TestUnti.Log;
import com.offcn.TestUnti.MapUtil;
import com.offcn.TestUnti.RequestDataUtils;
import com.offcn.TestUnti.StringUtils;
import com.offcn.interfaces.API;
import com.offcn.process.NWN;
import com.offcn.process.TK;
import com.offcn.TestUnti.ListUtil;

import net.sf.json.JSONObject;



/**
 * 学员管理-学员列表-删除学员（批量&单个）
 * 
 * @author puhui
 *
 */
public class delStudent extends NWN implements API {
	public String parameter;//参数集合
	
	public String user_id_str;//用户id ,英文逗号
	public String package_id;//package_id

	@Override
	public void initialize(HashMap<String, Object> data) {
	}

	@Override
	public HashMap<String, Object> handleInput(HashMap<String, Object> data) {
		// 获取parameter对应的内容
		parameter = MapUtil.getValue("parameter", data);
		package_id = MapUtil.getParameter(parameter, "package_id").trim();
		user_id_str = MapUtil.getParameter(parameter, "user_id_str").trim();
		
		if ((!package_id.equals("")) && package_id.equals("code")) {
			package_id=ListUtil.getListValue(n_package_idList, 0);
			parameter = parameter.replace("\"package_id\":code", "\"package_id\":\""+ package_id + "\"" );
		}
		if ((!user_id_str.equals("")) && user_id_str.equals("code")) {
			user_id_str=ListUtil.getListValue(user_id_List, 0);
			parameter = parameter.replace("\"user_id_str\":code", "\"user_id_str\":\""+ user_id_str + "\"");
		}
		
		data.put("parameter", parameter);
		return data;
	}

	@Override
	public Response SendRequest(HashMap<String, Object> data, String Url,
			String Request) {
		Response re = RequestDataUtils.Post_cooike(data, Url,"PHPSESSID",PHPSESSID);
		return re;
	}

	@Override
	public String handleOutput(Response re, HashMap<String, Object> data) {
		JsonPath jp = re.body().jsonPath();
		boolean result = true;
		String failReason = "";

		String json = re.asString();

		if ((data.get("statusCode") != null)
				&& (!data.get("statusCode").toString()
						.equals(String.valueOf(re.getStatusCode())))) {
			result = result && false;
			failReason = failReason + "statusCode is expected "
					+ data.get("statusCode").toString() + " but actually "
					+ String.valueOf(re.getStatusCode()) + ". ";
		}

		if (json.length() != 0) {
			
			String msg=StringUtils.decodeUnicode(getMsg(re));
			String code=getCode(re);
			
			if ((data.get("code") != null ) && (code != null) && (!code.equals(data.get("code").toString()))) {
				result = result && false;
				failReason = failReason + "code is expected "
						+ data.get("code").toString() + " but actually "
						+ jp.getString("code") + ".";
			}

			if ((data.get("msg") != null) && (msg != null) && (!msg.equals(data.get("msg").toString()))) {
				result = result && false;
				failReason = failReason + "msg is expected "
						+ data.get("msg").toString() + " but actually "
						+ jp.getString("msg") + ".";
			}
			
			if(data.get("custom") != null && jp.getString("data")!=null){
				String custom=data.get("custom").toString();
				String[] ArrayString=StringUtils.getArrayString(custom,",");
				if(!StringUtils.VerificationString(jp.getString("data"),ArrayString)){
					result = result && false;
					failReason = failReason + "custom is expected "
							+ data.get("custom").toString() + " but actually "
							+ jp.getString("data") + ".";
				}
			}
			
			if("删除成功".equals(msg)){
				
				//是否验证数据库
				if (!isProduct) {
					user_id_List=ListUtil.cleann_no_List(user_id_List);
				}
			}
			
			
		}
		if (result)
			return "Pass";
		else
			return "Fail:" + failReason;
	}

}
