package com.offcn.api.nwn;

import io.restassured.path.json.JsonPath;
import io.restassured.response.Response;

import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.HashMap;
import java.util.Random;

import org.json.simple.JSONArray;

import com.offcn.TestUnti.Log;
import com.offcn.TestUnti.MapUtil;
import com.offcn.TestUnti.RequestDataUtils;
import com.offcn.TestUnti.StringUtils;
import com.offcn.interfaces.API;
import com.offcn.process.NWN;
import com.offcn.process.TK;
import com.offcn.TestUnti.ListUtil;

import net.sf.json.JSONObject;



/**
 * 账号管理-启用/停用账号
 * 
 * @author puhui
 *
 */
public class changeStatus extends NWN implements API {
	public String parameter;//参数集合
	
	public String id;//sso正常用户
	public String status;//昵称

	@Override
	public void initialize(HashMap<String, Object> data) {
	}

	@Override
	public HashMap<String, Object> handleInput(HashMap<String, Object> data) {
		// 获取parameter对应的内容
		parameter = MapUtil.getValue("parameter", data);
		id = MapUtil.getParameter(parameter, "id").trim();
		System.out.println(id);
		if ((!id.equals("")) && id.equals("code")) {
			id=ListUtil.getListValue(n_admin_id_List, 0);
			parameter = parameter.replace("\"id\":code", "\"id\":\""+ id + "\"");
		}
		
		data.put("parameter", parameter);
		return data;
	}

	@Override
	public Response SendRequest(HashMap<String, Object> data, String Url,
			String Request) {
		Response re = RequestDataUtils.Post_cooike(data, Url,"PHPSESSID",PHPSESSID);
		return re;
	}

	@Override
	public String handleOutput(Response re, HashMap<String, Object> data) {
		JsonPath jp = re.body().jsonPath();
		boolean result = true;
		String failReason = "";

		String json = re.asString();

		if ((data.get("statusCode") != null)
				&& (!data.get("statusCode").toString()
						.equals(String.valueOf(re.getStatusCode())))) {
			result = result && false;
			failReason = failReason + "statusCode is expected "
					+ data.get("statusCode").toString() + " but actually "
					+ String.valueOf(re.getStatusCode()) + ". ";
		}

		if (json.length() != 0) {
			
			String msg=StringUtils.decodeUnicode(getMsg(re));
			String code=getCode(re);
			
			if ((data.get("code") != null ) && (code != null) && (!code.equals(data.get("code").toString()))) {
				result = result && false;
				failReason = failReason + "code is expected "
						+ data.get("code").toString() + " but actually "
						+ jp.getString("code") + ".";
			}

			if ((data.get("msg") != null) && (msg != null) && (!msg.equals(data.get("msg").toString()))) {
				result = result && false;
				failReason = failReason + "msg is expected "
						+ data.get("msg").toString() + " but actually "
						+ jp.getString("msg") + ".";
			}
			
			if(data.get("custom") != null && jp.getString("data")!=null){
				String custom=data.get("custom").toString();
				String[] ArrayString=StringUtils.getArrayString(custom,",");
				if(!StringUtils.VerificationString(jp.getString("data"),ArrayString)){
					result = result && false;
					failReason = failReason + "custom is expected "
							+ data.get("custom").toString() + " but actually "
							+ jp.getString("data") + ".";
				}
			}
			
			if("状态修改成功!".equals(msg)){
				
				//是否验证数据库
				if (!isProduct) {
					
					parameter = MapUtil.getValue("parameter", data);
					id = MapUtil.getParameter(parameter, "id").trim();
					id = MapUtil.killQuotes(id, "\"");
					
					status = MapUtil.getParameter(parameter, "status").trim();
					status = MapUtil.killQuotes(status, "\"");
					
					try {
						
						String sql="select * from n_admin where id='"+id+"'";
						
						ResultSet rs_bankcard = this.sqlFromDB(sql);
						rs_bankcard.last();
						
						if(rs_bankcard.getRow()>=1){
							
							
							String act_status=rs_bankcard.getString("status").equals("null ")?"null":rs_bankcard.getString("status");
							
							if(!(status.equals(act_status))){
									result = result && false;
									failReason = failReason + "n_admin info status is not in DB;";
							}
						}
						
					} catch (Exception e) {
						result = result && false;
						failReason = failReason + "cannot verify n_admin info in DB;";
						e.printStackTrace();
					}
				}
			}
			
			
		}
		if (result)
			return "Pass";
		else
			return "Fail:" + failReason;
	}

}
