package com.offcn.api.nwn;

import io.restassured.path.json.JsonPath;
import io.restassured.response.Response;

import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Random;

import org.json.simple.JSONArray;

import com.offcn.TestUnti.ListUtil;
import com.offcn.TestUnti.Log;
import com.offcn.TestUnti.MapUtil;
import com.offcn.TestUnti.MySqlUtil;
import com.offcn.TestUnti.ReadProperties;
import com.offcn.TestUnti.RequestDataUtils;
import com.offcn.TestUnti.StringUtils;
import com.offcn.interfaces.API;
import com.offcn.process.NWN;
import com.offcn.process.XYZB;

import net.sf.json.JSONObject;



/**
 * 课程大纲列表-添加组件-视频
 * 
 * @author puhui
 *
 */
public class addChildModuleMovie_template extends NWN implements API {
	public String parameter;//参数集合
	
	public String template_id_1;//学习包id
	public String movie_name;//视频名称
	public String parent_id;//父级id ,第一级为 0， 子级为 上级的id
	public String movie_id;//视频idmda-gjvkfu3jwwjxz84e\mda-gjvk3kgfbhmdvcmb\mda-gjvkrnzry73rd2hi\mda-gjvk6pncebf5whzx
	
	@Override
	public void initialize(HashMap<String, Object> data) {
		try {
			String sql="SELECT  DISTINCT(video_id)   FROM  n_video  ";
			//SELECT  id FROM  n_template ORDER BY id DESC LIMIT 1
			ResultSet rs_bankcard = this.sqlFromDB(sql);
			rs_bankcard.last();
			
			movie_id_list.add(rs_bankcard.getString("video_id"));
					
			System.out.println("movie_id_list====" + movie_id_list);
		} catch (Exception e) {
			
			e.printStackTrace();
		}
	}
	

	@Override
	public HashMap<String, Object> handleInput(HashMap<String, Object> data) {
		// 获取parameter对应的内容
	
		parameter = MapUtil.getValue("parameter", data);
		
		template_id_1 = MapUtil.getParameter_get(parameter, "template_id").trim();
		movie_id = MapUtil.getParameter_get(parameter, "movie_id").trim();
		
		if ((!template_id_1.equals("")) && template_id_1.equals("template_id")) {
			template_id_1=template_id;
			System.out.println("template_id_1==="+ template_id_1);
			parameter = parameter.replace("template_id=template_id", "template_id="+ template_id_1 );
		}
		
		if ((!movie_id.equals("")) && movie_id.equals("movie_id")) {
			movie_id=ListUtil.getListValue(movie_id_list, 0);
			System.out.println("movie_id==="+ movie_id);
			parameter = parameter.replace("movie_id=movie_id", "movie_id="+ movie_id );
		}
		data.put("parameter", parameter);
		return data;
	}

	@Override
	public Response SendRequest(HashMap<String, Object> data, String Url,
			String Request) {
		
		Response re = RequestDataUtils.Get_one_cookie_pre(data, Url, "PHPSESSID",PHPSESSID);
		return re;
	}

	@Override
	public String handleOutput(Response re, HashMap<String, Object> data) {
		JsonPath jp = re.body().jsonPath();
		boolean result = true;
		String failReason = "";

		String json = re.asString();

		if ((data.get("statusCode") != null)
				&& (!data.get("statusCode").toString()
						.equals(String.valueOf(re.getStatusCode())))) {
			result = result && false;
			failReason = failReason + "statusCode is expected "
					+ data.get("statusCode").toString() + " but actually "
					+ String.valueOf(re.getStatusCode()) + ". ";
		}

		if (json.length() != 0) {
			
			String msg=jp.getString("message");
			String code=jp.getString("retcode");
			
			if ((data.get("code") != null ) && (code != null) && (!code.equals(data.get("code").toString()))) {
				result = result && false;
				failReason = failReason + "code is expected "
						+ data.get("code").toString() + " but actually "
						+ jp.getString("code") + ".";
			}

			if ((data.get("msg") != null) && (msg != null) && (!msg.equals(data.get("msg").toString()))) {
				result = result && false;
				failReason = failReason + "msg is expected "
						+ data.get("msg").toString() + " but actually "
						+ jp.getString("msg") + ".";
			}
			
			if(data.get("custom") != null && jp.getString("data")!=null){
				String custom=data.get("custom").toString();
				String[] ArrayString=StringUtils.getArrayString(custom,",");
//				System.out.println(jp.getString("custom"));
//				System.out.println(Arrays.toString(ArrayString));
				if(!StringUtils.VerificationString(jp.getString("data"),ArrayString)){
					result = result && false;
					failReason = failReason + "custom is expected "
							+ data.get("custom").toString() + " but actually "
							+ jp.getString("data") + ".";
				}
			}
			
			
			if("0".equals(jp.getString("retcode"))){
				
				
				
				//是否验证数据库
				if (!isProduct) {
					
				}
			}
			
			
		}
		
		if (result)
			return "Pass";
		else
			return "Fail:" + failReason;
	}

}
