/*
 * Decompiled with CFR 0.152.
 */
package org.uncommons.reportng;

import org.testng.annotations.Test;
import org.uncommons.reportng.ReportNGUtils;

public class ReportNGUtilsTest {
    private final ReportNGUtils utils = new ReportNGUtils();

    @Test
    public void testEscapeTags() {
        String originalString = "</ns1:ErrorCode>";
        String escapedString = this.utils.escapeString("</ns1:ErrorCode>");
        assert (escapedString.equals("&lt;/ns1:ErrorCode&gt;")) : "Wrong escaping: " + escapedString;
    }

    @Test
    public void testEscapeQuotes() {
        String originalString = "\"Hello'";
        String escapedString = this.utils.escapeString("\"Hello'");
        assert (escapedString.equals("&quot;Hello&apos;")) : "Wrong escaping: " + escapedString;
    }

    @Test
    public void testEscapeAmpersands() {
        String originalString = "&&";
        String escapedString = this.utils.escapeString("&&");
        assert (escapedString.equals("&amp;&amp;")) : "Wrong escaping: " + escapedString;
    }

    @Test
    public void testEscapeSpaces() {
        String originalString = "    ";
        String escapedString = this.utils.escapeString("    ");
        assert (escapedString.equals("    ")) : "Wrong escaping: " + escapedString;
        escapedString = this.utils.escapeHTMLString("    ");
        assert (escapedString.equals("&nbsp;&nbsp;&nbsp; ")) : "Wrong escaping: " + escapedString;
    }

    @Test
    public void testFormatIntegerPercentage() {
        String percentage = this.utils.formatPercentage(10, 100);
        assert ("10.00%".equals(percentage)) : "Wrongly formatted percentage: " + percentage;
    }

    @Test
    public void testFormatFractionalPercentage() {
        String percentage = this.utils.formatPercentage(2, 3);
        assert ("66.67%".equals(percentage)) : "Wrongly formatted percentage: " + percentage;
    }
}

