/*
 * Decompiled with CFR 0.152.
 */
package io.appium.java_client;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import io.appium.java_client.MobileDriver;
import org.openqa.selenium.WebElement;
import org.openqa.selenium.remote.RemoteWebElement;

public class TouchAction {
    private MobileDriver driver;
    ImmutableList.Builder parameterBuilder;

    public TouchAction(MobileDriver driver) {
        this.driver = driver;
        this.parameterBuilder = ImmutableList.builder();
    }

    public TouchAction press(WebElement el) {
        ActionParameter action = new ActionParameter("press", (RemoteWebElement)el);
        this.parameterBuilder.add((Object)action);
        return this;
    }

    public TouchAction press(int x, int y) {
        ActionParameter action = new ActionParameter("press");
        action.addParameter("x", x);
        action.addParameter("y", y);
        this.parameterBuilder.add((Object)action);
        return this;
    }

    public TouchAction press(WebElement el, int x, int y) {
        ActionParameter action = new ActionParameter("press", (RemoteWebElement)el);
        action.addParameter("x", x);
        action.addParameter("y", y);
        this.parameterBuilder.add((Object)action);
        return this;
    }

    public TouchAction release() {
        ActionParameter action = new ActionParameter("release");
        this.parameterBuilder.add((Object)action);
        return this;
    }

    public TouchAction moveTo(WebElement el) {
        ActionParameter action = new ActionParameter("moveTo", (RemoteWebElement)el);
        this.parameterBuilder.add((Object)action);
        return this;
    }

    public TouchAction moveTo(int x, int y) {
        ActionParameter action = new ActionParameter("moveTo");
        action.addParameter("x", x);
        action.addParameter("y", y);
        this.parameterBuilder.add((Object)action);
        return this;
    }

    public TouchAction moveTo(WebElement el, int x, int y) {
        ActionParameter action = new ActionParameter("moveTo", (RemoteWebElement)el);
        action.addParameter("x", x);
        action.addParameter("y", y);
        this.parameterBuilder.add((Object)action);
        return this;
    }

    public TouchAction tap(WebElement el) {
        ActionParameter action = new ActionParameter("tap", (RemoteWebElement)el);
        this.parameterBuilder.add((Object)action);
        return this;
    }

    public TouchAction tap(int x, int y) {
        ActionParameter action = new ActionParameter("tap");
        action.addParameter("x", x);
        action.addParameter("y", y);
        this.parameterBuilder.add((Object)action);
        return this;
    }

    public TouchAction tap(WebElement el, int x, int y) {
        ActionParameter action = new ActionParameter("tap", (RemoteWebElement)el);
        action.addParameter("x", x);
        action.addParameter("y", y);
        this.parameterBuilder.add((Object)action);
        return this;
    }

    public TouchAction waitAction() {
        ActionParameter action = new ActionParameter("wait");
        this.parameterBuilder.add((Object)action);
        return this;
    }

    public TouchAction waitAction(int ms) {
        ActionParameter action = new ActionParameter("wait");
        action.addParameter("ms", ms);
        this.parameterBuilder.add((Object)action);
        return this;
    }

    public TouchAction longPress(WebElement el) {
        ActionParameter action = new ActionParameter("longPress", (RemoteWebElement)el);
        this.parameterBuilder.add((Object)action);
        return this;
    }

    public TouchAction longPress(int x, int y) {
        ActionParameter action = new ActionParameter("longPress");
        action.addParameter("x", x);
        action.addParameter("y", y);
        this.parameterBuilder.add((Object)action);
        return this;
    }

    public TouchAction longPress(WebElement el, int x, int y) {
        ActionParameter action = new ActionParameter("longPress", (RemoteWebElement)el);
        action.addParameter("x", x);
        action.addParameter("y", y);
        this.parameterBuilder.add((Object)action);
        return this;
    }

    public void cancel() {
        ActionParameter action = new ActionParameter("wait");
        this.parameterBuilder.add((Object)action);
        this.perform();
    }

    public TouchAction perform() {
        this.driver.performTouchAction(this);
        return this;
    }

    protected ImmutableMap<String, ImmutableList> getParameters() {
        ImmutableList.Builder parameters = ImmutableList.builder();
        ImmutableList actionList = this.parameterBuilder.build();
        for (ActionParameter action : actionList) {
            parameters.add(action.getParameterMap());
        }
        return ImmutableMap.of((Object)"actions", (Object)parameters.build());
    }

    protected void clearParameters() {
        this.parameterBuilder = ImmutableList.builder();
    }

    private class ActionParameter {
        private String actionName;
        private ImmutableMap.Builder optionsBuilder;

        public ActionParameter(String actionName) {
            this.actionName = actionName;
            this.optionsBuilder = ImmutableMap.builder();
        }

        public ActionParameter(String actionName, RemoteWebElement el) {
            this.actionName = actionName;
            this.optionsBuilder = ImmutableMap.builder();
            this.addParameter("element", el.getId());
        }

        public ImmutableMap<String, Object> getParameterMap() {
            ImmutableMap.Builder builder = ImmutableMap.builder();
            builder.put((Object)"action", (Object)this.actionName).put((Object)"options", (Object)this.optionsBuilder.build());
            return builder.build();
        }

        public void addParameter(String name, Object value) {
            this.optionsBuilder.put((Object)name, value);
        }
    }
}

