package com.offcn.test;
import io.restassured.response.Response;

import java.sql.SQLException;
import java.util.HashMap;

import net.sf.json.JSONObject;

import org.testng.Assert;
import org.testng.annotations.AfterClass;

import com.offcn.TestData.offcn_api_testData;
import com.offcn.TestUnti.Log;
import com.offcn.TestUnti.Mail;
import com.offcn.TestUnti.MapUtil;
import com.offcn.TestUnti.OAuthTokenUnti;
import com.offcn.TestUnti.ReadProperties;
import com.offcn.TestUnti.Reflect_api;
import com.offcn.TestUnti.SheetUtils;
import com.offcn.TestUnti.StringUtils;
import com.offcn.TestUnti.XMLread;
import com.offcn.api.nwn.md5.nwngetsign;
import com.offcn.interfaces.API;
import com.offcn.listener.ProcessTestng;
import com.offcn.listener.ResultTestng;
import com.offcn.process.BasicsGM;
import com.offcn.process.NWN;
import com.offcn.process.TK;
import com.offcn.process.XYZB;

import org.testng.annotations.BeforeClass;
import org.testng.annotations.Listeners;
import org.testng.annotations.Test;

@Listeners({ ProcessTestng.class ,ResultTestng.class })
public class APITest_nwn extends NWN{

	@BeforeClass
	  public void beforeClass() {
			//测试开始删除测试所用的数据
		  if (!isClearMysql) {
			  System.out.println("start   del **************");
			  this.cleann_n_admin_card_no_List_FromDB_beforeTest();
			  System.out.println("end     del **************");
			  
		  }
		  Log.logInfo("========测试开始========");
		  
	  }
  @Test(dataProvider = "renmai", dataProviderClass = offcn_api_testData.class)
  public void f(HashMap<String, Object> data) {
	  
	  Log.logInfo(data.get("TCNO").toString() + " Step " + data.get("Description").toString() + " is running......");
	  
	  API obj = new Reflect_api().Reflections(data);
	  BasicsGM.map=new XMLread().getSystem();
	  
	  obj.initialize(data);
	  
	  data = obj.handleInput(data);
	  
	  //静态和动态参数自动添加
	  data = setPublicParameter(data);
	  data = setDynamicParameter(data);
	  String parameter = MapUtil.getValue("parameter", data);
     System.out.println("parameter=====" + parameter);
//	  System.out.println(!data.get("Request").toString().contains("get"));
//	  System.out.println(data.get("system").toString().equals("nwn_service"));
	  if(data.get("system").toString().equals("nwn_service")  ){
		  String serviceUrl = MapUtil.getValue("serviceUrl", data);
		  //url后面获取sign值 
		  serviceUrl = serviceUrl + "/sign/" + nwngetsign.nwnGetSign(parameter);
		  data.put("serviceUrl", serviceUrl);
	  }

	  
	  Long startTime=System.currentTimeMillis();
	  Response re = obj.SendRequest(data, data.get("serviceUrl").toString(), data.get("Request").toString());
	  Long endTime=System.currentTimeMillis();
	  
	  String time=(endTime-startTime)+"毫秒";
	  
	  String codeORerrcode="";
	  String msgORerrmsy="";
	  String result = "";
	  String body = "";
	  
	  if(re!=null){
		  
		  body=re.asString();
		  if(body.contains("<title>")){
			  int Alength="<title>".length();
			  int start=body.indexOf("<title>");
			  int end=body.indexOf("</title>")+1;
			  body="页面标题："+body.substring(start+Alength, end-1);
			  result=body;
			  if(data.get("Description").toString().contains("流程")){
				  result = obj.handleOutput(re, data);
			  }
		  }else if(body.contains("<html>")){
			  body="返回html页面，状态码："+re.getStatusCode();
			  if(data.get("Description").toString().contains("流程")){
				  result = obj.handleOutput(re, data);
			  }
		  }

		  
	  } 
	  result = obj.handleOutput(re, data);
	  
	  codeORerrcode=getCode(re);
	  msgORerrmsy=getMsg(re);
	  
	  Log.logInfo("返回结果="+StringUtils.decodeUnicode(body));
	  System.out.println();
	  
	  
	  //数据回写
	/* // HashMap<String, Object> ExpectResult=MapUtil.Expect(data);
	  SheetUtils sheet = new SheetUtils("DataAll.xls", "Output");
	  sheet.writeExcel(
			  		data.get("NO").toString(),
				  	data.get("TCNO").toString() + "_Step" + data.get("Step").toString(),
				  	data.get("Description").toString(),
				  	parameter, 
//					JSONObject.fromObject(ExpectResult).toString(),
				  	re.getStatusCode()+"",
//					StringUtils.decodeUnicode(re==null?"":re.asString()),
					StringUtils.decodeUnicode(body),
					codeORerrcode,
					msgORerrmsy,
					result,
					time
					);*/
	  
	  if(result.indexOf("Fail")!=-1){
		  String Expect1=data.get("code")==null?"":data.get("code").toString();
		  String Expect2=data.get("msg")==null?"":data.get("msg").toString();
		  String Expect3=data.get("custom")==null?"":data.get("custom").toString();
		  if(body.contains("HTML")){
			  body="异常页面信息";
		  }
		  Assert.assertEquals(StringUtils.decodeUnicode(body),Expect1+","+Expect2+","+Expect3);
	  }else{
		  Assert.assertTrue(true);
	  }
  }

  @AfterClass
  public void afterClass() {
		//测试结束删除测试所用的数据
	  if (!isClearMysql) {
		  this.cleann_n_admin_card_no_List_FromDB();
		  this.cleann_n_package_List_FromDB();
		  this.cleann_user_id_List_FromDB();
		  this.cleann_getcode_id_List_FromDB();
		  this.cleann_template_FromDB();
		  try { 
				if(stmt!=null){
					stmt.close();
				}
				if (conn != null){
					conn.close();
				}
			} catch (SQLException e) {
				e.printStackTrace();
			}
		  try { 
				if(stmt1!=null){
					stmt1.close();
				}
				if (conn1 != null){
					conn1.close();
				}
			} catch (SQLException e) {
				e.printStackTrace();
			}
	  }
	  Log.logInfo("========测试结束========");
	  
  }

}
