package com.offcn.api.xyzb;

import io.restassured.path.json.JsonPath;
import io.restassured.response.Response;

import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.Random;

import org.json.simple.JSONArray;

import com.offcn.TestUnti.Log;
import com.offcn.TestUnti.MapUtil;
import com.offcn.TestUnti.MyDateUtil;
import com.offcn.TestUnti.ReadProperties;
import com.offcn.TestUnti.RequestDataUtils;
import com.offcn.TestUnti.StringUtils;
import com.offcn.interfaces.API;
import com.offcn.process.XYZB;

import net.sf.json.JSONObject;



/**
 * 获取文件信息
 * 
 * @author puhui
 *
 */
public class room_files_get extends XYZB implements API {
	public String Description;//参数集合
	public int id;//房间id
	
	
	
	@Override
	public void initialize(HashMap<String, Object> data) {
	}

	@Override
	public HashMap<String, Object> handleInput(HashMap<String, Object> data) {
		return data;
	}

	@Override
	public Response SendRequest(HashMap<String, Object> data, String Url,
			String Request) {
		// 获取parameter对应的内容
		Description = MapUtil.getValue("Description", data);
		if(Description.contains("错误token")){
			Response re = RequestDataUtils.Get_Errtoken(data, "/api/v1/room_files", Client_token);
			return re;
		}else if(Description.contains("超长token")){
			Response re = RequestDataUtils.Get_Longtoken(data, "/api/v1/room_files", Client_token);
			return re;
		}else if(Description.contains("无token")){
			Response re = RequestDataUtils.Get_Notoken_NoCookie(data, "/api/v1/room_files");
			return re;
		}
		Response re = RequestDataUtils.Get_Noparameter(data, "/api/v1/room_files",Client_token);
		return re;
	}

	@Override
	public String handleOutput(Response re, HashMap<String, Object> data) {
		JsonPath jp = re.body().jsonPath();
		boolean result = true;
		String failReason = "";

		String json = re.asString();

		if ((data.get("statusCode") != null)
				&& (!data.get("statusCode").toString()
						.equals(String.valueOf(re.getStatusCode())))) {
			result = result && false;
			failReason = failReason + "statusCode is expected "
					+ data.get("statusCode").toString() + " but actually "
					+ String.valueOf(re.getStatusCode()) + ". ";
		}

		if (json.length() != 0) {
			
			String msg=StringUtils.decodeUnicode(jp.getString("msg"));
			
			if ((data.get("code") != null )
					&& ((jp.getString("code") == null) || (!jp.getString(
							"code").equals(data.get("code").toString())))) {
				result = result && false;
				failReason = failReason + "code is expected "
						+ data.get("code").toString() + " but actually "
						+ jp.getString("code") + ".";
			}

			if ((data.get("msg") != null)
					&& ((msg == null) || (!msg.equals(data.get("msg").toString())))) {
				result = result && false;
				failReason = failReason + "msg is expected "
						+ data.get("msg").toString() + " but actually "
						+ jp.getString("msg") + ".";
			}
			
			if(data.get("custom") != null && jp.getString("data")!=null){
				String custom=data.get("custom").toString();
				String[] ArrayString=StringUtils.getArrayString(custom,",");
				if(!StringUtils.VerificationString(jp.getString("data"),ArrayString)){
					result = result && false;
					failReason = failReason + "custom is expected "
							+ data.get("custom").toString() + " but actually "
							+ jp.getString("data") + ".";
				}
			}
			
			if("操作成功".equals(jp.getString("msg"))){
				
				//是否是线上环境
				if (!isProduct) {
					ArrayList<Object> list=(ArrayList<Object>) re.body().jsonPath().getList("data");
//					System.out.println(jp.getString("data.room_id").substring(1,jp.getString("data.room_id").length()-1));
//					System.out.println(!"".equals(jp.getString("data.room_id").substring(1,jp.getString("data.room_id").length()-1)));
					String idarr=jp.getString("data.room_id").substring(1,jp.getString("data.room_id").length()-1);
					if(!"".equals(idarr)){
						String arr[]=idarr.split(",");
						id=arr.length;
					}else{
						id=0;
					}
					
					//					String arr[]=.split(",");
//					id=arr.length;
//					System.out.println(list.size());
//					System.out.println(id);
					
					try {
						ResultSet rs_bankcard = this.selectFromDB(
								" xyu_room_files f ",
								" f.id = '" + id + "' ");
						rs_bankcard.last();
						
						
						if (list.size()!=id){
							result = result && false;
							failReason = failReason + "xyu_room_files info in DB is wrong;";
						} else {
							Log.logInfo("xyu_room_files info in DB is correct;");
						}
						
					} catch (Exception e) {
						result = result && false;
						failReason = failReason + "cannot verify xyu_room_files info in DB;";
						e.printStackTrace();
					}
				}
			}
			
			
		}
		if (result)
			return "Pass";
		else
			return "Fail:" + failReason;
	}

}
