package com.offcn.api.xyzb;

import io.restassured.path.json.JsonPath;
import io.restassured.response.Response;

import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.HashMap;
import java.util.Random;

import org.json.simple.JSONArray;

import com.offcn.TestUnti.Log;
import com.offcn.TestUnti.MapUtil;
import com.offcn.TestUnti.MyDateUtil;
import com.offcn.TestUnti.ReadProperties;
import com.offcn.TestUnti.RequestDataUtils;
import com.offcn.TestUnti.StringUtils;
import com.offcn.interfaces.API;
import com.offcn.process.XYZB;

import net.sf.json.JSONObject;



/**
 * 创建文件信息
 * 
 * @author puhui
 *
 */
public class room_files extends XYZB implements API {
	public String parameter;//参数集合
	
	public String name;//房间名称
	public String id;//房间名称
	public String room_id;//房间名称
	public String link;
	public String type;
	public String private_;
	public String files_size;
	public String is_courseware;
	public String hash;
	public String doc_type;
	public String path;

	@Override
	public void initialize(HashMap<String, Object> data) {
	}

	@Override
	public HashMap<String, Object> handleInput(HashMap<String, Object> data) {
		// 获取parameter对应的内容
		parameter = MapUtil.getValue("parameter", data);
		name = MapUtil.getParameter(parameter, "name").trim();
		link = MapUtil.getParameter(parameter, "link").trim();
		type = MapUtil.getParameter(parameter, "type").trim();
		private_ = MapUtil.getParameter(parameter, "private").trim();
		
		if (!private_.equals("")) {
			parameter = parameter.replace("\"private_\"", "\"private\"");
		}
		
		
		files_size = MapUtil.getParameter(parameter, "files_size").trim();
		is_courseware = MapUtil.getParameter(parameter, "is_courseware").trim();
		hash = MapUtil.getParameter(parameter, "hash").trim();
		doc_type = MapUtil.getParameter(parameter, "doc_type").trim();
		path = MapUtil.getParameter(parameter, "path").trim();
		
		data.put("parameter", parameter);
		return data;
	}

	@Override
	public Response SendRequest(HashMap<String, Object> data, String Url,
			String Request) {
		Response re = RequestDataUtils.Post_token(data, Url,Client_token);
		return re;
	}

	@Override
	public String handleOutput(Response re, HashMap<String, Object> data) {
		JsonPath jp = re.body().jsonPath();
		boolean result = true;
		String failReason = "";

		String json = re.asString();

		if ((data.get("statusCode") != null)
				&& (!data.get("statusCode").toString()
						.equals(String.valueOf(re.getStatusCode())))) {
			result = result && false;
			failReason = failReason + "statusCode is expected "
					+ data.get("statusCode").toString() + " but actually "
					+ String.valueOf(re.getStatusCode()) + ". ";
		}

		if (json.length() != 0) {
			
			String msg=StringUtils.decodeUnicode(jp.getString("msg"));
			
			if ((data.get("code") != null )
					&& ((jp.getString("code") == null) || (!jp.getString(
							"code").equals(data.get("code").toString())))) {
				result = result && false;
				failReason = failReason + "code is expected "
						+ data.get("code").toString() + " but actually "
						+ jp.getString("code") + ".";
			}

			if ((data.get("msg") != null)
					&& ((msg == null) || (!msg.equals(data.get("msg").toString())))) {
				result = result && false;
				failReason = failReason + "msg is expected "
						+ data.get("msg").toString() + " but actually "
						+ jp.getString("msg") + ".";
			}
			
			if(data.get("custom") != null && jp.getString("data")!=null){
				String custom=data.get("custom").toString();
				String[] ArrayString=StringUtils.getArrayString(custom,",");
				if(!StringUtils.VerificationString(jp.getString("data"),ArrayString)){
					result = result && false;
					failReason = failReason + "custom is expected "
							+ data.get("custom").toString() + " but actually "
							+ jp.getString("data") + ".";
				}
			}
			
			if("操作成功".equals(jp.getString("msg"))){
				
				//是否是线上环境
				if (!isProduct) {
					name=jp.getString("data.name").substring(1,jp.getString("data.name").length()-1);
					id=jp.getString("data.id").substring(1,jp.getString("data.id").length()-1);
					room_id=jp.getString("data.room_id").substring(1,jp.getString("data.room_id").length()-1);
					link=jp.getString("data.link").substring(1,jp.getString("data.link").length()-1);
					type=jp.getString("data.type").substring(1,jp.getString("data.type").length()-1);
					private_=jp.getString("data.private").substring(1,jp.getString("data.private").length()-1);
					files_size=jp.getString("data.files_size").substring(1,jp.getString("data.files_size").length()-1);
					is_courseware=jp.getString("data.is_courseware").substring(1,jp.getString("data.is_courseware").length()-1);
					hash=jp.getString("data.hash").substring(1,jp.getString("data.hash").length()-1);
					doc_type=jp.getString("data.doc_type").substring(1,jp.getString("data.doc_type").length()-1);
					path=jp.getString("data.path").substring(1,jp.getString("data.path").length()-1);
					
					
					name = MapUtil.killQuotes(name, "\"");//去掉双引号的bankNo
					id = MapUtil.killQuotes(id, "\"");//去掉双引号的bankNo
					room_id = MapUtil.killQuotes(room_id, "\"");//去掉双引号的bankNo
					link = MapUtil.killQuotes(link, "\"");//去掉双引号的bankNo
					type = MapUtil.killQuotes(type, "\"");//去掉双引号的bankName
					private_ = MapUtil.killQuotes(private_, "\"");//去掉双引号的bankName
					files_size = MapUtil.killQuotes(files_size, "\"");//去掉双引号的bankName
					is_courseware = MapUtil.killQuotes(is_courseware, "\"");//去掉双引号的bankName
					hash = MapUtil.killQuotes(hash, "\"");//去掉双引号的bankName
					doc_type = MapUtil.killQuotes(doc_type, "\"");//去掉双引号的bankName
					path = MapUtil.killQuotes(path, "\"");//去掉双引号的bankName
					
					try {
						ResultSet rs_bankcard = this.selectFromDB(
								" xyu_room_files f ",
								" f.id = '" + id + "' ");
						rs_bankcard.last();
						
						if (rs_bankcard.getRow() < 1) {
							result = result && false;
							failReason = failReason + "xyu_room_files info is not in DB;";
						} else {
							name = (name != null)? String.valueOf(name).trim() : "";
							id = (id != null)? String.valueOf(id).trim() : "";
							room_id = (room_id != null)? String.valueOf(room_id).trim() : "";
							link = (link != null)? String.valueOf(link).trim() : "";
							type = (type != null)? String.valueOf(type).trim() : "";
							private_ = (private_ != null)? String.valueOf(private_).trim() : "";
							files_size = (files_size != null)? String.valueOf(files_size).trim() : "";
							is_courseware = (is_courseware != null)? String.valueOf(is_courseware).trim() : "";
							hash = (hash != null)? String.valueOf(hash).trim() : "";
							doc_type = (doc_type != null)? String.valueOf(doc_type).trim() : "";
							path = (path != null)? String.valueOf(path).trim() : "";
							
							String act_name = String
									.valueOf(rs_bankcard.getString(rs_bankcard.findColumn("name")));
							String act_id = String
									.valueOf(rs_bankcard.getString(rs_bankcard.findColumn("id")));
							String act_room_id = String
									.valueOf(rs_bankcard.getString(rs_bankcard.findColumn("room_id")));
							String act_link = String
									.valueOf(rs_bankcard.getString(rs_bankcard.findColumn("link")));
							String act_type = String
									.valueOf(rs_bankcard.getString(rs_bankcard.findColumn("type")));
							String act_private = String
									.valueOf(rs_bankcard.getString(rs_bankcard.findColumn("private")));
							String act_files_size = String
									.valueOf(rs_bankcard.getString(rs_bankcard.findColumn("files_size")));
							String act_is_courseware = String
									.valueOf(rs_bankcard.getString(rs_bankcard.findColumn("is_courseware")));
							String act_hash = String
									.valueOf(rs_bankcard.getString(rs_bankcard.findColumn("hash")));
							String act_doc_type = String
									.valueOf(rs_bankcard.getString(rs_bankcard.findColumn("doc_type")));
							String act_path = String
									.valueOf(rs_bankcard.getString(rs_bankcard.findColumn("path")));
							
							if ((!name.equals(act_name)) 
									|| (!id.equals(act_id))
									|| (!room_id.equals(act_room_id))
									|| (!link.equals(act_link))
									|| (!type.equals(act_type))
									|| (!private_.equals(act_private))
									|| (!files_size.equals(act_files_size))
									|| (!is_courseware.equals(act_is_courseware))
									|| (!hash.equals(act_hash))
									|| (!doc_type.equals(act_doc_type))
									|| (!path.equals(act_path))){
								result = result && false;
								failReason = failReason + "xyu_room_files info in DB is wrong;";
							} else {
								Current_id=id;
								Log.logInfo("xyu_room_files info in DB is correct;");
							}
						}
					} catch (Exception e) {
						result = result && false;
						failReason = failReason + "cannot verify xyu_room_files info in DB;";
						e.printStackTrace();
					}
				}
			}
			
			
		}
		if (result)
			return "Pass";
		else
			return "Fail:" + failReason;
	}

}
