package com.offcn.api.xyzb.process;

import io.restassured.http.Headers;
import io.restassured.path.json.JsonPath;
import io.restassured.response.Response;

import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.HashMap;

import org.json.simple.JSONArray;

import com.offcn.TestUnti.MapUtil;
import com.offcn.TestUnti.RequestDataUtils;
import com.offcn.TestUnti.StringUtils;
import com.offcn.interfaces.API;
import com.offcn.process.XYZB;

import net.sf.json.JSONObject;

/**
 * 流程-页面登录
 * 
 * @author puhui
 *
 */
public class weblogin extends XYZB implements API {

	public String parameter;//参数集合
	public String Description;//用例名称
	
	public String name;//姓名
	public String password;//密码
//	public String _token;//token
	
	@Override
	public void initialize(HashMap<String, Object> data) {
	}

	@Override
	public HashMap<String, Object> handleInput(HashMap<String, Object> data) {
		// 获取parameter对应的内容
		parameter = MapUtil.getValue("parameter", data);
//		_token = MapUtil.getParameter(parameter, "_token").trim();
		name = MapUtil.getParameter(parameter, "name").trim();
		password = MapUtil.getParameter(parameter, "password").trim();
//		if ((!_token.equals("")) && _token.equals("code")) {
//			parameter = parameter.replace("\"_token\":code", "\"_token\":\""+ Page_token + "\"");
//		}
		if ((!name.equals("")) && name.equals("Enterprise_users")) {
			parameter = parameter.replace("\"name\":Enterprise_users", "\"name\":\""+ Enterprise_users.get("name") + "\"");
		}
		if ((!password.equals("")) && password.equals("Enterprise_users")) {
			parameter = parameter.replace("\"password\":Enterprise_users", "\"password\":\""+ Enterprise_users.get("pwd") + "\"");
		}
		
		
		if ((!name.equals("")) && name.equals("Business_Administrator")) {
			parameter = parameter.replace("\"name\":Business_Administrator", "\"name\":\""+ Business_Administrator.get("name") + "\"");
		}
		if ((!password.equals("")) && password.equals("Business_Administrator")) {
			parameter = parameter.replace("\"password\":Business_Administrator", "\"password\":\""+ Business_Administrator.get("pwd") + "\"");
		}
		// 替换原来的parameter
		data.put("parameter", parameter);
		
		return data;
	}

	@Override
	public Response SendRequest(HashMap<String, Object> data, String Url,
			String Request) {
		Response re = RequestDataUtils.Post_NOToken(data, "/web/login");
		return re;
	}

	@Override
	public String handleOutput(Response re, HashMap<String, Object> data) {
		JsonPath jp = re.body().jsonPath();
		boolean result = true;
		String failReason = "";

		String json = re.asString();
		Headers headers=re.getHeaders();
//		System.out.println(headers.toString());
//				System.out.println(re.getSessionId());
//		
//		System.out.println(MapUtil.showMap_String(re.getCookies()));

		//保存cookie
		laravel_session=re.getCookie("laravel_session");
		
		if ((data.get("statusCode") != null)
				&& (!data.get("statusCode").toString()
						.equals(String.valueOf(re.getStatusCode())))) {
			result = result && false;
			failReason = failReason + "statusCode is expected "
					+ data.get("statusCode").toString() + " but actually "
					+ String.valueOf(re.getStatusCode()) + ". ";
		}

		if (json.length() != 0) {
			
			String msg=StringUtils.decodeUnicode(jp.getString("msg"));
			
			if ((data.get("code") != null )
					&& ((jp.getString("code") == null) || (!jp.getString(
							"code").equals(data.get("code").toString())))) {
				result = result && false;
				failReason = failReason + "code is expected "
						+ data.get("code").toString() + " but actually "
						+ jp.getString("code") + ".";
			}

			if ((data.get("msg") != null)
					&& ((msg == null) || (!msg.equals(data.get("msg").toString())))) {
				result = result && false;
				failReason = failReason + "msg is expected "
						+ data.get("msg").toString() + " but actually "
						+ jp.getString("msg") + ".";
			}
			
			if(data.get("custom") != null && !re.asString().contains("</html>")){
				String custom=data.get("custom").toString();
				String[] ArrayString=StringUtils.getArrayString(custom,",");
				if(!StringUtils.VerificationString(jp.getString("data"),ArrayString)){
					result = result && false;
					failReason = failReason + "custom is expected "
							+ data.get("custom").toString() + " but actually "
							+ jp.getString("data") + ".";
				}
			}

		}
		if (result)
			return "Pass";
		else
			return "Fail:" + failReason;
	}

}
