package com.offcn.api.nwn;

import io.restassured.path.json.JsonPath;
import io.restassured.response.Response;

import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Random;

import net.sf.json.JSONArray;

import com.offcn.TestUnti.Log;
import com.offcn.TestUnti.MapUtil;
import com.offcn.TestUnti.RequestDataUtils;
import com.offcn.TestUnti.StringUtils;
import com.offcn.interfaces.API;
import com.offcn.process.NWN;
import com.offcn.process.TK;
import com.offcn.system.NwnStudent;
import com.offcn.TestUnti.ListUtil;

import net.sf.json.JSONObject;



/**
 * 学员管理-学员列表-添加学员（批量&单个）
 * 
 * @author puhui
 *
 */
public class addStudent extends NWN implements API {
	public String parameter;//参数集合
	
	public String user_info;//json数据，package_id必须一样
	public String package_id;//package_id
	public String username;//昵称
	public String phone;//电话
	public String remarks;//

	@Override
	public void initialize(HashMap<String, Object> data) {
	}

	@Override
	public HashMap<String, Object> handleInput(HashMap<String, Object> data) {
		// 获取parameter对应的内容
		parameter = MapUtil.getValue("parameter", data);

		try {
			NwnStudent[] ss =(NwnStudent[])JSONArray.toArray(JSONArray.fromObject(parameter),NwnStudent.class);
			if(ss.length>0){
				NwnStudent nwnStudent=ss[0];
				package_id= nwnStudent.getPackage_id();
				phone= nwnStudent.getPhone();
				remarks= nwnStudent.getRemarks();
				username= nwnStudent.getUsername();
				
				if ((package_id!=null) && package_id.equals("code")) {
					package_id=ListUtil.getListValue(n_package_idList, 0);
					nwnStudent.setPackage_id(package_id);
				}
				if ((phone!=null) && phone.equals("random")) {
					phone="1391"+(new Random().nextInt(9000000)+ 1000000);
					nwnStudent.setPhone(phone);
				}
				if ((phone!=null) && phone.equals("code")) {
					phone=ListUtil.getListValue(n_admin_phone_List, 0);
					nwnStudent.setPhone(phone);
				}
				if ((remarks!=null) && remarks.equals("random")) {
					remarks="1391"+(new Random().nextInt(9000000)+ 1000000);
					nwnStudent.setRemarks(remarks);
				}
				if ((username!=null) && username.equals("random")) {
					username="1391"+(new Random().nextInt(9000000)+ 1000000);
					nwnStudent.setUsername(username);
				}
				
				List<NwnStudent> lists=new ArrayList<NwnStudent>();
		        lists.add(nwnStudent);
		        JSONArray listArray=JSONArray.fromObject(lists);
		        parameter=listArray.toString();
			}
			
		} catch (Exception e) {
			return data;
		}
		
		data.put("parameter", parameter);
		return data;
	}

	@Override
	public Response SendRequest(HashMap<String, Object> data, String Url,
			String Request) {
		Map<String,String> m=new HashMap<String,String>();
		m.put("user_info", parameter);
		Response re = RequestDataUtils.Post_cooike_form_data(data, Url,"PHPSESSID",PHPSESSID,m);
		return re;
	}

	@Override
	public String handleOutput(Response re, HashMap<String, Object> data) {
		JsonPath jp = re.body().jsonPath();
		boolean result = true;
		String failReason = "";

		String json = re.asString();

		if ((data.get("statusCode") != null)
				&& (!data.get("statusCode").toString()
						.equals(String.valueOf(re.getStatusCode())))) {
			result = result && false;
			failReason = failReason + "statusCode is expected "
					+ data.get("statusCode").toString() + " but actually "
					+ String.valueOf(re.getStatusCode()) + ". ";
		}

		if (json.length() != 0) {
			
			String msg=StringUtils.decodeUnicode(getMsg(re));
			String code=getCode(re);
			
			if ((data.get("code") != null ) && (code != null) && (!code.equals(data.get("code").toString()))) {
				result = result && false;
				failReason = failReason + "code is expected "
						+ data.get("code").toString() + " but actually "
						+ jp.getString("code") + ".";
			}

			if ((data.get("msg") != null) && (msg != null) && (!msg.equals(data.get("msg").toString()))) {
				result = result && false;
				failReason = failReason + "msg is expected "
						+ data.get("msg").toString() + " but actually "
						+ jp.getString("msg") + ".";
			}
			
			if(data.get("custom") != null && jp.getString("data")!=null){
				String custom=data.get("custom").toString();
				String[] ArrayString=StringUtils.getArrayString(custom,",");
				if(!StringUtils.VerificationString(jp.getString("data"),ArrayString)){
					result = result && false;
					failReason = failReason + "custom is expected "
							+ data.get("custom").toString() + " but actually "
							+ jp.getString("data") + ".";
				}
			}
			
			
			if("成功1条,失败0条".equals(msg)){
				
				//是否验证数据库
				if (!isProduct) {
					
					try {
						String sql="select *  from  n_user  where phone='"+phone+"'";
						
						ResultSet rs_bankcard = this.sqlFromDB(sql);
						rs_bankcard.last();
						
						user_id_List.add(rs_bankcard.getString("id"));
						
					} catch (Exception e) {
						result = result && false;
						failReason = failReason + "cannot verify n_package info in DB;";
						e.printStackTrace();
					}
				}
			}
			
			
		}
		if (result)
			return "Pass";
		else
			return "Fail:" + failReason;
	}

}
