package aoutTestCode;

import java.io.File;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

import org.dom4j.Document;
import org.dom4j.DocumentException;
import org.dom4j.Element;
import org.dom4j.io.SAXReader;

public class xmlToftl {
	@SuppressWarnings("unused")
	private String filePath;
	private Document document;
	private Element root;
	
	public xmlToftl(String filePath) {
		this.filePath = filePath;
		this.load(filePath);
	}
	public  void load(String filePath) {
		File file=new File(filePath);
		if(file.exists()){
			SAXReader saxReader=new SAXReader();
			try {
				document=saxReader.read(file);
				root=document.getRootElement();
			} catch (DocumentException e) {
				System.out.println("文件加载异常"+filePath);
			}
		}else{
			System.out.println("文件没找到");
		}	
	}
	public static void main(String[] args) {
		xmlToftl x=new xmlToftl("templates/MakeCode.xml");
		x.go();
	}

	public  void go(){
		//获取包名
		String package_name=getName("package_name");
		
		//获取类名
		String class_name=getKey("class_name");
		
		//获取接口名
		String implements_name=getKey("implements_name");
		
		//获取boolean
		boolean b=getBoolean("initialize_Disable");
		System.out.println(b);
		
		//获取参数
		List<Map<String,String>> listParameters=getNameAndKey("parameters","parameter");
		
		//获取参数
		List<Map<String,String>> initializes=getNameAndKey("initializes","initialize");
		System.out.println(initializes.toString());
		
		//获取参数
		List<List<String>> getN=getNameAndTypeAndKey("handleInput_replaces","handleInput_replace");
		System.out.println(getN);
		
		
		//获取参数
		List<List<String>> getN1=getNameAndTypeAndKey("handleInputs_Verifications","handleInputs_Verification");
		System.out.println(getN1);
		
		//获取参数
		Map<String,List<String>> getn2=gethandleOutput_save("handleOutput_saves","handleOutput_save","handleOutput");
		System.out.println(getn2);
	}
	
	public  String getName(String str){
		if(str.equals("package_name")){
			return root.attributeValue("name");
		}
		Element element=root.element(str);
		return element.attributeValue("name");
	}
	
	public  String getKey(String str){
		Element ementsValue=root.element(str);
		String Value=ementsValue.getTextTrim();
		return Value;
	}
	
	public  boolean getBoolean(String str){
		String type=getKey(str);
		if("true".equals(type)){
			return true;
		}
		return false;
	}

	public  List<Map<String,String>> getNameAndKey(String parameters,String parameter){
		Element Elements=root.element(parameters);
		@SuppressWarnings("unchecked")
		List<Element> liste = Elements.elements(parameter);
		List<Map<String,String>> list = new ArrayList<Map<String,String>>();
		for (Element element : liste) {
			Map<String,String> root = new HashMap<String,String>();
			if(element.attributeValue("value")==null){
				root.put(element.attributeValue("name"), element.getTextTrim());
			}else{
				root.put(element.attributeValue("value"), element.getTextTrim());
			}
			list.add(root);
		}
		return list;
	}
	
	public  List<List<String>> getNameAndTypeAndKey(String parameters,String parameter){
		Element Elements=root.element(parameters);
		@SuppressWarnings("unchecked")
		List<Element> liste = Elements.elements(parameter);
		List<List<String>> list = new ArrayList<List<String>>();
		for (Element element : liste) {
			List<String> root = new ArrayList<String>();
			if(element.attributeValue("name")!=null){
				root.add(element.attributeValue("name"));
			}
			if(element.attributeValue("type")!=null){
				root.add(element.attributeValue("type"));
			}
			if(element.attributeValue("value")!=null){
				root.add(element.attributeValue("value"));
			}
			if(!element.getTextTrim().equals("")){
				root.add(element.getTextTrim());
			}
			list.add(root);
		}
		return list;
	}
	
	public  Map<String,List<String>> gethandleOutput_save(String parameters,String parameter,String handleOutput){
		Element Elements=root.element(parameters);
		@SuppressWarnings("unchecked")
		List<Element> liste = Elements.elements(parameter);
		Map<String,List<String>> map = new HashMap<String,List<String>>();
		String mapString="";
		for (Element element : liste) {
			List<String> root = new ArrayList<String>();
			if(element.attributeValue("name")!=null){
				mapString=element.attributeValue("name");
			}
			List<Element> listh = element.elements(handleOutput);
			for (Element element2 : listh) {
				root.add(element2.getTextTrim());
			}
			map.put(mapString,root);
		}
		return map;
	}
}
