/*
 * Decompiled with CFR 0.152.
 */
package org.dbunit.database;

import java.sql.DatabaseMetaData;
import java.sql.ResultSet;
import java.sql.SQLException;
import org.dbunit.database.IMetadataHandler;
import org.dbunit.util.SQLHelper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DefaultMetadataHandler
implements IMetadataHandler {
    private static final Logger logger = LoggerFactory.getLogger(DefaultMetadataHandler.class);

    public ResultSet getColumns(DatabaseMetaData databaseMetaData, String schemaName, String tableName) throws SQLException {
        if (logger.isTraceEnabled()) {
            logger.trace("getColumns(databaseMetaData={}, schemaName={}, tableName={}) - start", new Object[]{databaseMetaData, schemaName, tableName});
        }
        ResultSet resultSet = databaseMetaData.getColumns(null, schemaName, tableName, "%");
        return resultSet;
    }

    public boolean matches(ResultSet resultSet, String schema, String table, boolean caseSensitive) throws SQLException {
        return this.matches(resultSet, null, schema, table, null, caseSensitive);
    }

    public boolean matches(ResultSet columnsResultSet, String catalog, String schema, String table, String column, boolean caseSensitive) throws SQLException {
        if (logger.isTraceEnabled()) {
            logger.trace("matches(columnsResultSet={}, catalog={}, schema={}, table={}, column={}, caseSensitive={}) - start", new Object[]{columnsResultSet, catalog, schema, table, column, caseSensitive});
        }
        String catalogName = columnsResultSet.getString(1);
        String schemaName = columnsResultSet.getString(2);
        String tableName = columnsResultSet.getString(3);
        String columnName = columnsResultSet.getString(4);
        if (logger.isDebugEnabled()) {
            logger.debug("Comparing the following values using caseSensitive={} (searched<=>actual): catalog: {}<=>{} schema: {}<=>{} table: {}<=>{} column: {}<=>{}", new Object[]{caseSensitive, catalog, catalogName, schema, schemaName, table, tableName, column, columnName});
        }
        boolean areEqual = this.areEqualIgnoreNull(catalog, catalogName, caseSensitive) && this.areEqualIgnoreNull(schema, schemaName, caseSensitive) && this.areEqualIgnoreNull(table, tableName, caseSensitive) && this.areEqualIgnoreNull(column, columnName, caseSensitive);
        return areEqual;
    }

    private boolean areEqualIgnoreNull(String value1, String value2, boolean caseSensitive) {
        return SQLHelper.areEqualIgnoreNull(value1, value2, caseSensitive);
    }

    public String getSchema(ResultSet resultSet) throws SQLException {
        if (logger.isTraceEnabled()) {
            logger.trace("getColumns(resultSet={}) - start", (Object)resultSet);
        }
        String schemaName = resultSet.getString(2);
        return schemaName;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean tableExists(DatabaseMetaData metaData, String schemaName, String tableName) throws SQLException {
        if (logger.isTraceEnabled()) {
            logger.trace("tableExists(metaData={}, schemaName={}, tableName={}) - start", new Object[]{metaData, schemaName, tableName});
        }
        ResultSet tableRs = metaData.getTables(null, schemaName, tableName, null);
        try {
            boolean bl = tableRs.next();
            return bl;
        }
        finally {
            SQLHelper.close(tableRs);
        }
    }

    public ResultSet getTables(DatabaseMetaData metaData, String schemaName, String[] tableType) throws SQLException {
        if (logger.isTraceEnabled()) {
            logger.trace("getTables(metaData={}, schemaName={}, tableType={}) - start", new Object[]{metaData, schemaName, tableType});
        }
        return metaData.getTables(null, schemaName, "%", tableType);
    }

    public ResultSet getPrimaryKeys(DatabaseMetaData metaData, String schemaName, String tableName) throws SQLException {
        if (logger.isTraceEnabled()) {
            logger.trace("getPrimaryKeys(metaData={}, schemaName={}, tableName={}) - start", new Object[]{metaData, schemaName, tableName});
        }
        ResultSet resultSet = metaData.getPrimaryKeys(null, schemaName, tableName);
        return resultSet;
    }
}

