package com.offcn.api.xyzb.process;

import io.restassured.http.Headers;
import io.restassured.path.json.JsonPath;
import io.restassured.response.Response;

import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.HashMap;

import org.json.simple.JSONArray;

import com.offcn.TestUnti.MapUtil;
import com.offcn.TestUnti.RequestDataUtils;
import com.offcn.TestUnti.StringUtils;
import com.offcn.interfaces.API;
import com.offcn.process.XYZB;

import net.sf.json.JSONObject;



/**
 * 流程-打开小雨直播登录后台首页
 * 
 * @author puhui
 *
 */
public class webAdmin extends XYZB implements API {

	@Override
	public void initialize(HashMap<String, Object> data) {
	}

	@Override
	public HashMap<String, Object> handleInput(HashMap<String, Object> data) {
		return data;
	}

	@Override
	public Response SendRequest(HashMap<String, Object> data, String Url,
			String Request) {
		Response re = RequestDataUtils.Get_Notoken(data, "/web/admin");
		return re;
	}

	@Override
	public String handleOutput(Response re, HashMap<String, Object> data) {
		JsonPath jp = re.body().jsonPath();
		boolean result = true;
		String failReason = "";

		String json = re.asString();
		Headers headers=re.getHeaders();
//		System.out.println(headers.toString());
//				System.out.println(re.getSessionId());
//		System.out.println(MapUtil.showMap_String(re.getCookies()));
		XSRF_token=re.getCookie("XSRF-TOKEN");
		laravel_session=re.getCookie("laravel_session");
//		System.out.println(XSRF_token);
		
		if ((data.get("statusCode") != null)
				&& (!data.get("statusCode").toString()
						.equals(String.valueOf(re.getStatusCode())))) {
			result = result && false;
			failReason = failReason + "statusCode is expected "
					+ data.get("statusCode").toString() + " but actually "
					+ String.valueOf(re.getStatusCode()) + ". ";
		}

		if((data.get("custom") != null && !re.asString().contains("</html>"))
				) {
			result = result && false;
			failReason = failReason + "custom is expected "
					+ data.get("custom").toString() + " but actually "
					+ String.valueOf(json) + ". ";
		}
		
		if (result)
			return "Pass";
		else
			return "Fail:" + failReason;
	}

}
